/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.fits;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.fits.FitsDataset;
import ncsa.hdf.object.fits.FitsGroup;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayDataInput;

public class FitsFile
extends FileFormat {
    public static final long serialVersionUID = 240L;
    private MutableTreeNode rootNode;
    private Fits fitsFile;
    private static boolean isFileOpen;

    public FitsFile() {
        this("");
    }

    public FitsFile(String string) {
        super(string);
        this.isReadOnly = true;
        isFileOpen = false;
        this.fid = -1;
        try {
            this.fitsFile = new Fits(this.fullFileName);
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof FitsFile;
    }

    @Override
    public boolean isThisType(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {}
            return false;
        }
        byte[] byArray = new byte[80];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            String string2 = new String(byArray, 0, 9);
            if (!string2.startsWith("SIMPLE  =")) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
                return false;
            }
            String string3 = new String(byArray, 9, 70);
            if ((string3 = string3.trim()).length() < 1 || string3.charAt(0) != 'T') {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
                return false;
            }
            bl = true;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    @Override
    public FileFormat createInstance(String string, int n) throws Exception {
        return new FitsFile(string);
    }

    @Override
    public int open() throws Exception {
        if (!isFileOpen) {
            isFileOpen = true;
            this.rootNode = this.loadTree();
        }
        return 0;
    }

    private MutableTreeNode loadTree() {
        long[] lArray = new long[1];
        FitsGroup fitsGroup = new FitsGroup(this, this.getName(), null, null, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(fitsGroup){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        if (this.fitsFile == null) {
            return defaultMutableTreeNode;
        }
        BasicHDU[] basicHDUArray = null;
        try {
            basicHDUArray = this.fitsFile.read();
        }
        catch (Exception exception) {}
        if (basicHDUArray == null) {
            return defaultMutableTreeNode;
        }
        int n = basicHDUArray.length;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        BasicHDU basicHDU = null;
        int n4 = 0;
        while (n4 < n) {
            basicHDU = basicHDUArray[n4];
            string = null;
            if (basicHDU instanceof ImageHDU) {
                string = "ImageHDU #" + n2++;
            } else if (basicHDU instanceof RandomGroupsHDU) {
                string = "RandomGroupsHDU #" + n2++;
            } else if (basicHDU instanceof TableHDU) {
                string = basicHDU instanceof AsciiTableHDU ? "AsciiTableHDU #" + n3++ : (basicHDU instanceof BinaryTableHDU ? "BinaryTableHDU #" + n3++ : "TableHDU #" + n3++);
            }
            if (string != null) {
                lArray[0] = basicHDU.hashCode();
                FitsDataset fitsDataset = new FitsDataset((FileFormat)this, basicHDU, string, lArray);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fitsDataset);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                fitsGroup.addToMemberList(fitsDataset);
            }
            ++n4;
        }
        return defaultMutableTreeNode;
    }

    @Override
    public void close() throws IOException {
        if (this.fitsFile == null) {
            return;
        }
        ArrayDataInput arrayDataInput = this.fitsFile.getStream();
        if (arrayDataInput instanceof InputStream) {
            ((InputStream)arrayDataInput).close();
        }
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public Fits getFitsFile() {
        return this.fitsFile;
    }

    @Override
    public Group createGroup(String string, Group group) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for Fits.");
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for Fits.");
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for Fits.");
    }

    @Override
    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void delete(HObject hObject) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyDataset(Dataset dataset, FitsGroup fitsGroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyGroup(FitsGroup fitsGroup, FitsGroup fitsGroup2) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(HObject hObject, HObject hObject2) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(int n, int n2) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public String getLibversion() {
        String string = "Fits Java (version 2.4)";
        return string;
    }

    @Override
    public HObject get(String string) throws Exception {
        throw new UnsupportedOperationException("get() is not supported");
    }
}

