/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.fits;

import java.util.List;
import ncsa.hdf.object.Datatype;

public class FitsDatatype
extends Datatype {
    public static final long serialVersionUID = 240L;
    private int nativeType;

    public FitsDatatype(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public FitsDatatype(int n) {
        super(-1);
        this.nativeType = n;
        this.fromNative(0);
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    public static Object allocateArray(int n, int n2) throws OutOfMemoryError {
        Object[] objectArray = null;
        if (n2 <= 0) {
            return null;
        }
        switch (n) {
            case 8: {
                objectArray = new byte[n2];
                break;
            }
            case 16: {
                objectArray = new short[n2];
                break;
            }
            case 32: {
                objectArray = new int[n2];
                break;
            }
            case 64: {
                objectArray = new long[n2];
                break;
            }
            case -32: {
                objectArray = new float[n2];
                break;
            }
            case -64: {
                objectArray = new double[n2];
            }
        }
        return objectArray;
    }

    public void fromNative() {
        this.fromNative(this.nativeType);
    }

    @Override
    public void fromNative(int n) {
        switch (n) {
            case 8: {
                this.datatypeClass = 0;
                this.datatypeSize = 1;
                break;
            }
            case 16: {
                this.datatypeClass = 0;
                this.datatypeSize = 2;
                break;
            }
            case 32: {
                this.datatypeClass = 0;
                this.datatypeSize = 4;
                break;
            }
            case 64: {
                this.datatypeClass = 0;
                this.datatypeSize = 8;
                break;
            }
            case -32: {
                this.datatypeClass = 1;
                this.datatypeSize = 4;
                break;
            }
            case -64: {
                this.datatypeClass = 1;
                this.datatypeSize = 8;
            }
        }
    }

    @Override
    public String getDatatypeDescription() {
        String string = "Unknown data type.";
        switch (this.nativeType) {
            case 8: {
                string = "8-bit integer";
                break;
            }
            case 16: {
                string = "16-bit integer";
                break;
            }
            case 32: {
                string = "32-bit integer";
                break;
            }
            case 64: {
                string = "64-bit integer";
                break;
            }
            case -32: {
                string = "32-bit float";
                break;
            }
            case -64: {
                string = "64-bit float";
                break;
            }
            default: {
                if (this.datatypeClass == 3) {
                    string = "String";
                    break;
                }
                if (this.datatypeClass == 2) {
                    string = "Char";
                    break;
                }
                if (this.datatypeClass == 0) {
                    string = "Integer";
                    break;
                }
                if (this.datatypeClass != 1) break;
                string = "Float";
            }
        }
        return string;
    }

    @Override
    public boolean isUnsigned() {
        return false;
    }

    @Override
    public int toNative() {
        if (this.datatypeClass == 0) {
            if (this.datatypeSize == 1) {
                this.nativeType = 8;
            } else if (this.datatypeSize == 2) {
                this.nativeType = 16;
            } else if (this.datatypeSize == 4) {
                this.nativeType = 32;
            } else if (this.datatypeSize == 8) {
                this.nativeType = 64;
            }
        } else if (this.datatypeClass == 1) {
            if (this.datatypeSize == 4) {
                this.nativeType = -32;
            } else if (this.datatypeSize == 8) {
                this.nativeType = -64;
            }
        }
        return this.nativeType;
    }

    @Override
    public void close(int n) {
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

