/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.fits;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.fits.FitsDatatype;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;

public class FitsDataset
extends ScalarDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private BasicHDU nativeDataset;

    public FitsDataset(FileFormat fileFormat, BasicHDU basicHDU, String string, long[] lArray) {
        super(fileFormat, string, "/", lArray);
        this.unsignedConverted = false;
        this.nativeDataset = basicHDU;
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public byte[] readBytes() throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public Object read() throws Exception {
        Object object = null;
        Object object2 = null;
        if (this.nativeDataset == null) {
            return null;
        }
        try {
            object2 = this.nativeDataset.getData().getData();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("This implementation only supports integer and float dataset. It may not work for other datatypes. \n" + exception);
        }
        int n = this.get1DLength(object2);
        object = FitsDatatype.allocateArray(this.nativeDataset.getBitPix(), n);
        this.to1Darray(object2, object, 0);
        return object;
    }

    @Override
    public void write(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public List getMetadata() throws Exception {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        if (this.nativeDataset == null) {
            return null;
        }
        Header header = this.nativeDataset.getHeader();
        if (header == null) {
            return null;
        }
        this.attributeList = new Vector();
        HeaderCard headerCard = null;
        Cursor cursor = header.iterator();
        Attribute attribute = null;
        FitsDatatype fitsDatatype = new FitsDatatype(3, 80, 0, 0);
        long[] lArray = new long[]{1L};
        String string = null;
        while (cursor.hasNext()) {
            string = "";
            headerCard = (HeaderCard)cursor.next();
            attribute = new Attribute(headerCard.getKey(), fitsDatatype, lArray);
            String string2 = headerCard.getValue();
            if (string2 != null) {
                string = String.valueOf(string) + string2;
            }
            if ((string2 = headerCard.getComment()) != null) {
                string = String.valueOf(string) + " / " + string2;
            }
            attribute.setValue(string);
            this.attributeList.add(attribute);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void removeMetadata(Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public int open() {
        return -1;
    }

    @Override
    public void close(int n) {
    }

    @Override
    public void init() {
        int n;
        if (this.nativeDataset == null) {
            return;
        }
        if (this.rank > 0) {
            return;
        }
        int[] nArray = null;
        try {
            nArray = this.nativeDataset.getAxes();
        }
        catch (Exception exception) {}
        if (nArray == null) {
            return;
        }
        this.rank = nArray.length;
        if (this.rank == 0) {
            this.rank = 1;
            this.dims = new long[1];
            this.dims[0] = 1L;
        } else {
            this.dims = new long[this.rank];
            n = 0;
            while (n < this.rank) {
                this.dims[n] = nArray[n];
                ++n;
            }
        }
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        n = 0;
        while (n < this.rank) {
            this.startDims[n] = 0L;
            this.selectedDims[n] = 1L;
            ++n;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedDims[1] = 1L;
        }
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    @Override
    public byte[][] readPalette(int n) {
        return null;
    }

    public static FitsDataset create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public byte[] getPaletteRefs() {
        return null;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            try {
                this.datatype = new FitsDatatype(this.nativeDataset.getBitPix());
            }
            catch (Exception exception) {}
        }
        return this.datatype;
    }

    @Override
    public void setName(String string) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    private int get1DLength(Object object) throws Exception {
        if (!object.getClass().isArray()) {
            return 1;
        }
        int n = Array.getLength(object);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.get1DLength(Array.get(object, n3));
            ++n3;
        }
        return n2;
    }

    private int to1Darray(Object object, Object object2, int n) throws Exception {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            return n;
        }
        int n2 = Array.getLength(object);
        if (!clazz.isArray()) {
            System.arraycopy(object, 0, object2, n, n2);
            return n + n2;
        }
        int n3 = n2 - 1;
        while (n3 >= 0) {
            n = this.to1Darray(Array.get(object, n3), object2, n);
            --n3;
        }
        return n;
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

