/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.lang.reflect.Array;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Metadata;

public class Attribute
implements Metadata {
    public static final long serialVersionUID = 240L;
    private final String name;
    private final Datatype type;
    private int rank;
    private long[] dims;
    private Object value;
    private boolean isUnsigned;

    public Attribute(String string, Datatype datatype, long[] lArray) {
        this(string, datatype, lArray, null);
    }

    public Attribute(String string, Datatype datatype, long[] lArray, Object object) {
        this.name = string;
        this.type = datatype;
        this.dims = lArray;
        this.value = null;
        this.rank = 0;
        if (this.dims != null) {
            this.rank = this.dims.length;
        }
        if (object != null) {
            this.value = object;
        }
        this.isUnsigned = this.type.getDatatypeSign() == 0;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDataDims() {
        return this.dims;
    }

    public Datatype getType() {
        return this.type;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public String toString() {
        return this.name;
    }

    public String toString(String string) {
        StringBuffer stringBuffer;
        block19: {
            int n;
            block18: {
                if (this.value == null) {
                    return null;
                }
                Class<?> clazz = this.value.getClass();
                if (!clazz.isArray()) {
                    return this.value.toString();
                }
                stringBuffer = new StringBuffer();
                n = Array.getLength(this.value);
                if (!this.isUnsigned) break block18;
                String string2 = clazz.getName();
                char c = string2.charAt(string2.lastIndexOf("[") + 1);
                switch (c) {
                    case 'B': {
                        byte[] byArray = (byte[])this.value;
                        short s = byArray[0];
                        if (s < 0) {
                            s = (short)(s + 256);
                        }
                        stringBuffer.append(s);
                        int n2 = 1;
                        while (n2 < n) {
                            stringBuffer.append(string);
                            s = byArray[n2];
                            if (s < 0) {
                                s = (short)(s + 256);
                            }
                            stringBuffer.append(s);
                            ++n2;
                        }
                        break block19;
                    }
                    case 'S': {
                        short[] sArray = (short[])this.value;
                        int n3 = sArray[0];
                        if (n3 < 0) {
                            n3 += 65536;
                        }
                        stringBuffer.append(n3);
                        int n4 = 1;
                        while (n4 < n) {
                            stringBuffer.append(string);
                            n3 = sArray[n4];
                            if (n3 < 0) {
                                n3 += 65536;
                            }
                            stringBuffer.append(n3);
                            ++n4;
                        }
                        break block19;
                    }
                    case 'I': {
                        int[] nArray = (int[])this.value;
                        long l = nArray[0];
                        if (l < 0L) {
                            l += 0x100000000L;
                        }
                        stringBuffer.append(l);
                        int n5 = 1;
                        while (n5 < n) {
                            stringBuffer.append(string);
                            l = nArray[n5];
                            if (l < 0L) {
                                l += 0x100000000L;
                            }
                            stringBuffer.append(l);
                            ++n5;
                        }
                        break block19;
                    }
                    default: {
                        stringBuffer.append(Array.get(this.value, 0));
                        int n6 = 1;
                        while (n6 < n) {
                            stringBuffer.append(string);
                            stringBuffer.append(Array.get(this.value, n6));
                            ++n6;
                        }
                        break block19;
                    }
                }
            }
            stringBuffer.append(Array.get(this.value, 0));
            int n7 = 1;
            while (n7 < n) {
                stringBuffer.append(string);
                stringBuffer.append(Array.get(this.value, n7));
                ++n7;
            }
        }
        return stringBuffer.toString();
    }
}

