/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;

class TabDescriptor {
    String theType = "";
    Class theClass = null;
    int nfields;
    int totalsize = 0;
    Field[] flds;
    String[] fldTypeName;
    Class[] fldType;
    int[] fldLen;
    Object[] theFields;

    TabDescriptor(Object object) throws HDFException, IllegalAccessException {
        this.theClass = object.getClass();
        this.theType = this.theClass.toString();
        int n = 0;
        this.flds = this.theClass.getFields();
        this.nfields = Array.getLength(this.flds);
        this.fldType = new Class[this.nfields];
        this.fldTypeName = new String[this.nfields];
        this.fldLen = new int[this.nfields];
        this.theFields = new Object[this.nfields];
        n = 0;
        while (n < this.nfields) {
            this.fldType[n] = this.flds[n].getType();
            this.fldTypeName[n] = this.fldType[n].getName();
            this.theFields[n] = this.flds[n].get(object);
            if (this.theFields[n] == null) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: Field not defined: " + this.flds[n].getName());
                throw hDFJavaException;
            }
            this.fldLen[n] = this.calcsize(this.fldType[n], this.flds[n].get(object));
            this.totalsize += this.fldLen[n];
            ++n;
        }
    }

    int calcsize(Class clazz, Object object) throws HDFException {
        String string = clazz.toString();
        if (string.equals("int")) {
            return 4;
        }
        if (string.equals("byte")) {
            return 1;
        }
        if (string.equals("short")) {
            return 2;
        }
        if (string.equals("float")) {
            return 4;
        }
        if (string.equals("long")) {
            return 8;
        }
        if (string.equals("double")) {
            return 16;
        }
        if (string.equals("class java.lang.String")) {
            return ((String)object).length();
        }
        if (string.startsWith("class [")) {
            if (!object.getClass().isArray()) {
                System.out.println("Error:  byteify requires array");
                return -1;
            }
            int n = 6;
            int n2 = 0;
            int n3 = 32;
            while (n < string.length()) {
                n3 = string.charAt(n);
                ++n;
                if (n3 != 91) continue;
                ++n2;
            }
            int n4 = n3;
            int n5 = 0;
            if (n4 == 66) {
                n5 = 1;
            } else if (n4 == 83) {
                n5 = 2;
            } else if (n4 == 73 || n4 == 70) {
                n5 = 4;
            } else if (n4 == 74 || n4 == 68) {
                n5 = 8;
            } else {
                System.out.println("Error:  array is not numeric?");
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: Array is not numeric?: " + string);
                throw hDFJavaException;
            }
            Object object2 = object;
            int n6 = 1;
            int n7 = n5;
            int n8 = 1;
            while (n8 <= n2) {
                n6 = Array.getLength(object2);
                n7 *= n6;
                object2 = Array.get(object2, 0);
                ++n8;
            }
            return n7;
        }
        HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: Unsupported data type: " + string);
        throw hDFJavaException;
    }
}

