/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.hdflib.HDFNativeData;
import ncsa.hdf.hdflib.TabDescriptor;

public class HDFTable {
    TabDescriptor _desc = null;

    static {
        HDFLibrary.getJHIVersion();
    }

    void init() throws IllegalAccessException, HDFException {
        this._desc = new TabDescriptor(this);
    }

    public int size() throws HDFException, IllegalAccessException {
        if (this._desc == null) {
            this.init();
        }
        return this._desc.totalsize;
    }

    public byte[] byteify() throws IllegalAccessException, HDFException {
        if (this._desc == null) {
            this.init();
        }
        byte[] byArray = new byte[this._desc.totalsize];
        int n = 0;
        int n2 = 0;
        while (n2 < this._desc.nfields) {
            this.getfield(this._desc.fldType[n2], this._desc.flds[n2].get(this), byArray, n);
            n += this._desc.fldLen[n2];
            ++n2;
        }
        return byArray;
    }

    void getfield(Class clazz, Object object, byte[] byArray, int n) throws HDFException {
        String string = clazz.getName();
        if (string.equals("int")) {
            byte[] byArray2 = HDFNativeData.intToByte((Integer)object);
            System.arraycopy(byArray2, 0, byArray, n, 4);
            return;
        }
        if (string.equals("byte")) {
            byte by;
            byArray[n] = by = ((Byte)object).byteValue();
            return;
        }
        if (string.equals("short")) {
            byte[] byArray3 = HDFNativeData.shortToByte((Short)object);
            System.arraycopy(byArray3, 0, byArray, n, 2);
            return;
        }
        if (string.equals("float")) {
            byte[] byArray4 = HDFNativeData.floatToByte((Float)object);
            System.arraycopy(byArray4, 0, byArray, n, 4);
            return;
        }
        if (string.equals("long")) {
            byte[] byArray5 = HDFNativeData.longToByte((Long)object);
            System.arraycopy(byArray5, 0, byArray, n, 8);
            return;
        }
        if (string.equals("double")) {
            byte[] byArray6 = HDFNativeData.doubleToByte((Double)object);
            System.arraycopy(byArray6, 0, byArray, n, 8);
            return;
        }
        if (string.equals("java.lang.String")) {
            byte[] byArray7 = ((String)object).getBytes();
            System.arraycopy(byArray7, 0, byArray, n, Array.getLength(byArray7));
            return;
        }
        if (string.startsWith("[")) {
            if (!object.getClass().isArray()) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: getfield not an array?: " + clazz + " " + string);
                throw hDFJavaException;
            }
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray8 = hDFArray.byteify();
            System.arraycopy(byArray8, 0, byArray, n, Array.getLength(byArray8));
            return;
        }
        HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: getfield unsupported type?: " + clazz + " " + string);
        throw hDFJavaException;
    }

    public void structify(byte[] byArray) throws HDFException, IllegalAccessException {
        if (this._desc == null) {
            this.init();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this._desc.nfields) {
            Object object = this.setfield(this._desc.fldTypeName[n2], this._desc.flds[n2].get(this), byArray, n, this._desc.fldLen[n2]);
            this._desc.flds[n2].set(this, object);
            n += this._desc.fldLen[n2];
            ++n2;
        }
    }

    Object setfield(String string, Object object, byte[] byArray, int n, int n2) throws HDFException {
        if (string.equals("int")) {
            int[] nArray = HDFNativeData.byteToInt(n, 1, byArray);
            return new Integer(nArray[0]);
        }
        if (string.equals("byte")) {
            byte[] byArray2 = new byte[]{(Byte)object};
            return new Byte(byArray2[0]);
        }
        if (string.equals("short")) {
            short[] sArray = HDFNativeData.byteToShort(n, 1, byArray);
            return new Short(sArray[0]);
        }
        if (string.equals("float")) {
            float[] fArray = HDFNativeData.byteToFloat(n, 1, byArray);
            return new Float(fArray[0]);
        }
        if (string.equals("long")) {
            long[] lArray = HDFNativeData.byteToLong(n, 1, byArray);
            return new Long(lArray[0]);
        }
        if (string.equals("double")) {
            double[] dArray = HDFNativeData.byteToDouble(n, 1, byArray);
            return new Double(dArray[0]);
        }
        if (string.equals("java.lang.String")) {
            if (((String)object).length() > n2) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: setfield string is too big?: " + object + " " + string);
                throw hDFJavaException;
            }
            String string2 = new String(byArray, n, ((String)object).length());
            return string2;
        }
        if (string.startsWith("[")) {
            if (!object.getClass().isArray()) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: setfield type is not array?: " + object + " " + string);
                throw hDFJavaException;
            }
            HDFArray hDFArray = new HDFArray(object);
            if (Array.getLength(object) > n2) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: setfield array too big?: " + object + " " + string);
                throw hDFJavaException;
            }
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            Object object2 = hDFArray.arrayify(byArray3);
            return object2;
        }
        HDFJavaException hDFJavaException = new HDFJavaException("HDFTable: setfield bad type: " + object + " " + string);
        throw hDFJavaException;
    }
}

