/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.io.Serializable;
import java.lang.reflect.Array;
import ncsa.hdf.hdflib.ArrayDescriptor;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;
import ncsa.hdf.hdflib.HDFNativeData;

public class HDFArray {
    private Object _theArray = null;
    private ArrayDescriptor _desc = null;
    private byte[] _barray = null;

    public HDFArray(Object object) throws HDFException {
        Serializable serializable;
        if (object == null) {
            serializable = new HDFJavaException("HDFArray: array is null?: ");
            ((Throwable)serializable).printStackTrace();
        }
        if (!((Class)(serializable = object.getClass())).isArray()) {
            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: not an array?: ");
            hDFJavaException.printStackTrace();
            throw hDFJavaException;
        }
        this._theArray = object;
        this._desc = new ArrayDescriptor(this._theArray);
        if (this._desc == null) {
            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: internal error: array description failed?: ");
            throw hDFJavaException;
        }
    }

    public byte[] emptyBytes() throws HDFException {
        byte[] byArray = null;
        byArray = ArrayDescriptor.dims == 1 && ArrayDescriptor.NT == 'B' ? (byte[])this._theArray : new byte[ArrayDescriptor.totalSize];
        if (byArray == null) {
            System.out.println("Error:  HDFArray can't allocate bytes for array");
            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: emptyBytes: allocation failed");
            throw hDFJavaException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] byteify() throws HDFException {
        int n;
        int n2;
        if (this._barray != null) {
            return this._barray;
        }
        if (this._theArray == null) {
            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: byteify not an array?: ");
            throw hDFJavaException;
        }
        if (ArrayDescriptor.dims == 1) {
            if (ArrayDescriptor.NT == 'B') {
                this._barray = (byte[])this._theArray;
                return this._barray;
            }
            try {
                byte[] byArray;
                this._barray = new byte[ArrayDescriptor.totalSize];
                if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[1], (int[])this._theArray);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[1], (short[])this._theArray);
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[1], (float[])this._theArray);
                } else if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[1], (long[])this._theArray);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[1], (double[])this._theArray);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: unknown type of Object?");
                        throw hDFJavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])this._theArray);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: unknown type of Object?");
                            throw hDFJavaException;
                        }
                        byArray = this.LongObjToByte((Long[])this._theArray);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, 0, ArrayDescriptor.dimlen[1] * ArrayDescriptor.NTsize);
                return this._barray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: byteify array too big?");
                hDFJavaException.printStackTrace();
                throw hDFJavaException;
            }
        }
        try {
            this._barray = new byte[ArrayDescriptor.totalSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: byteify array too big?");
            hDFJavaException.printStackTrace();
            throw hDFJavaException;
        }
        Object object = this._theArray;
        int n3 = 0;
        for (n2 = 0; n2 < ArrayDescriptor.totalSize; n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1]) {
            object = ArrayDescriptor.objs[0];
            n3 = n2 / ArrayDescriptor.bytetoindex[0];
            n3 %= ArrayDescriptor.dimlen[0];
            n = 0;
            while (n < ArrayDescriptor.dims) {
                n3 = n2 / ArrayDescriptor.bytetoindex[n];
                if ((n3 %= ArrayDescriptor.dimlen[n]) == ArrayDescriptor.currentindex[n]) {
                    object = ArrayDescriptor.objs[n];
                } else {
                    if (n3 > ArrayDescriptor.dimlen[n] - 1) {
                        System.out.println("out of bounds?");
                        return null;
                    }
                    object = Array.get(object, n3);
                    ArrayDescriptor.currentindex[n] = n3;
                    ArrayDescriptor.objs[n] = object;
                }
                ++n;
            }
            try {
                byte[] byArray;
                if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (int[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'B') {
                    byArray = (byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1];
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: byteify Object type not implemented?");
                        throw hDFJavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: byteify Object type not implemented?");
                            throw hDFJavaException;
                        }
                        byArray = this.LongObjToByte((Long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims] * ArrayDescriptor.NTsize);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: byteify array too big?");
                hDFJavaException.printStackTrace();
                throw hDFJavaException;
            }
        }
        if (n2 < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray:::byteify: Panic didn't complete all input data: n=  " + n2 + " size = " + ArrayDescriptor.totalSize));
        }
        n = 0;
        while (n < ArrayDescriptor.dims) {
            if (ArrayDescriptor.currentindex[n] != ArrayDescriptor.dimlen[n] - 1) {
                throw new InternalError(new String("Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + " ?)"));
            }
            ++n;
        }
        return this._barray;
    }

    public Object arrayify(byte[] byArray) throws HDFException {
        int n;
        if (this._theArray == null) {
            HDFJavaException hDFJavaException = new HDFJavaException("arrayify: not an array?: ");
            throw hDFJavaException;
        }
        if (Array.getLength(byArray) != ArrayDescriptor.totalSize) {
            new HDFJavaException("arrayify: array is wrong size?: ");
        }
        this._barray = byArray;
        if (ArrayDescriptor.dims == 1) {
            try {
                if (ArrayDescriptor.NT == 'I') {
                    int[] nArray = HDFNativeData.byteToInt(this._barray);
                    System.arraycopy(nArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'S') {
                    short[] sArray = HDFNativeData.byteToShort(this._barray);
                    System.arraycopy(sArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'F') {
                    float[] fArray = HDFNativeData.byteToFloat(this._barray);
                    System.arraycopy(fArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'J') {
                    long[] lArray = HDFNativeData.byteToLong(this._barray);
                    System.arraycopy(lArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'D') {
                    double[] dArray = HDFNativeData.byteToDouble(this._barray);
                    System.arraycopy(dArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        Byte[] byteArray = this.ByteToByteObj(this._barray);
                        System.arraycopy(byteArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        Integer[] integerArray = this.ByteToInteger(this._barray);
                        System.arraycopy(integerArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        Short[] shortArray = this.ByteToShort(this._barray);
                        System.arraycopy(shortArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        Float[] floatArray = this.ByteToFloatObj(this._barray);
                        System.arraycopy(floatArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        Double[] doubleArray = this.ByteToDoubleObj(this._barray);
                        System.arraycopy(doubleArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        Long[] longArray = this.ByteToLongObj(this._barray);
                        System.arraycopy(longArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    HDFJavaException hDFJavaException = new HDFJavaException("arrayify:  Object type not implemented yet...");
                    throw hDFJavaException;
                }
                HDFJavaException hDFJavaException = new HDFJavaException("arrayify:  Object type not implemented yet...");
                throw hDFJavaException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDFJavaException hDFJavaException = new HDFJavaException("HDFArray: arrayify array too big?");
                hDFJavaException.printStackTrace();
                throw hDFJavaException;
            }
        }
        Object object = this._theArray;
        int n2 = 0;
        int n3 = 0;
        while (n2 < ArrayDescriptor.totalSize) {
            Object object2;
            object = ArrayDescriptor.objs[0];
            n3 = n2 / ArrayDescriptor.bytetoindex[0];
            n3 %= ArrayDescriptor.dimlen[0];
            n = 0;
            while (n < ArrayDescriptor.dims) {
                n3 = n2 / ArrayDescriptor.bytetoindex[n];
                if ((n3 %= ArrayDescriptor.dimlen[n]) == ArrayDescriptor.currentindex[n]) {
                    object = ArrayDescriptor.objs[n];
                } else {
                    if (n3 > ArrayDescriptor.dimlen[n] - 1) {
                        System.out.println("out of bounds?");
                        return null;
                    }
                    object = Array.get(object, n3);
                    ArrayDescriptor.currentindex[n] = n3;
                    ArrayDescriptor.objs[n] = object;
                }
                ++n;
            }
            try {
                if (ArrayDescriptor.NT == 'J') {
                    object2 = HDFNativeData.byteToLong(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n4 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n4] = ArrayDescriptor.currentindex[n4] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'I') {
                    object2 = HDFNativeData.byteToInt(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n5 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n5] = ArrayDescriptor.currentindex[n5] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'S') {
                    object2 = HDFNativeData.byteToShort(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n6 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n6] = ArrayDescriptor.currentindex[n6] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, n2, ArrayDescriptor.objs[ArrayDescriptor.dims - 1], 0, ArrayDescriptor.dimlen[ArrayDescriptor.dims]);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    continue;
                }
                if (ArrayDescriptor.NT == 'F') {
                    object2 = HDFNativeData.byteToFloat(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n7 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n7] = ArrayDescriptor.currentindex[n7] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'D') {
                    object2 = HDFNativeData.byteToDouble(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n8 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n8] = ArrayDescriptor.currentindex[n8] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        object2 = this.ByteToByteObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n9 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n9] = ArrayDescriptor.currentindex[n9] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        object2 = this.ByteToInteger(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n10 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n10] = ArrayDescriptor.currentindex[n10] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        object2 = this.ByteToShort(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n11 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n11] = ArrayDescriptor.currentindex[n11] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        object2 = this.ByteToFloatObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n12 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n12] = ArrayDescriptor.currentindex[n12] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        object2 = this.ByteToDoubleObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n13 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n13] = ArrayDescriptor.currentindex[n13] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        object2 = this.ByteToLongObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n14 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n14] = ArrayDescriptor.currentindex[n14] + 1;
                        continue;
                    }
                    object2 = new HDFJavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                    throw object2;
                }
                object2 = new HDFJavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                throw object2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                object2 = new HDFJavaException("HDFArray: arrayify array too big?");
                object2.printStackTrace();
                throw object2;
            }
        }
        if (n2 < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all input data: n=  " + n2 + " size = " + ArrayDescriptor.totalSize));
        }
        n = 0;
        while (n <= ArrayDescriptor.dims - 2) {
            if (ArrayDescriptor.currentindex[n] != ArrayDescriptor.dimlen[n] - 1) {
                throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + "?"));
            }
            ++n;
        }
        if (ArrayDescriptor.NT != 'B') {
            if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1]) {
                throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + ArrayDescriptor.dimlen[n] + "?"));
            }
        } else if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1] - 1) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + "?"));
        }
        return this._theArray;
    }

    private byte[] IntegerToByte(Integer[] integerArray) {
        int n = Array.getLength(integerArray);
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = integerArray[n2];
            ++n2;
        }
        return HDFNativeData.intToByte(0, n, nArray);
    }

    private Integer[] ByteToInteger(byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(byArray);
        int n = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n];
        int n2 = 0;
        while (n2 < n) {
            integerArray[n2] = new Integer(nArray[n2]);
            ++n2;
        }
        return integerArray;
    }

    private Integer[] ByteToInteger(int n, int n2, byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(n, n2, byArray);
        int n3 = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n3];
        int n4 = 0;
        while (n4 < n3) {
            integerArray[n4] = new Integer(nArray[n4]);
            ++n4;
        }
        return integerArray;
    }

    private byte[] ShortToByte(Short[] shortArray) {
        int n = Array.getLength(shortArray);
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = shortArray[n2];
            ++n2;
        }
        return HDFNativeData.shortToByte(0, n, sArray);
    }

    private Short[] ByteToShort(byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(byArray);
        int n = Array.getLength(sArray);
        Short[] shortArray = new Short[n];
        int n2 = 0;
        while (n2 < n) {
            shortArray[n2] = new Short(sArray[n2]);
            ++n2;
        }
        return shortArray;
    }

    private Short[] ByteToShort(int n, int n2, byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(n, n2, byArray);
        int n3 = Array.getLength(sArray);
        Short[] shortArray = new Short[n3];
        int n4 = 0;
        while (n4 < n3) {
            shortArray[n4] = new Short(sArray[n4]);
            ++n4;
        }
        return shortArray;
    }

    private byte[] ByteObjToByte(Byte[] byteArray) {
        int n = Array.getLength(byteArray);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = byteArray[n2];
            ++n2;
        }
        return byArray;
    }

    private Byte[] ByteToByteObj(byte[] byArray) {
        int n = Array.getLength(byArray);
        Byte[] byteArray = new Byte[n];
        int n2 = 0;
        while (n2 < n) {
            byteArray[n2] = new Byte(byArray[n2]);
            ++n2;
        }
        return byteArray;
    }

    private Byte[] ByteToByteObj(int n, int n2, byte[] byArray) {
        Byte[] byteArray = new Byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byteArray[n3] = new Byte(byArray[n3]);
            ++n3;
        }
        return byteArray;
    }

    private byte[] FloatObjToByte(Float[] floatArray) {
        int n = Array.getLength(floatArray);
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = floatArray[n2].floatValue();
            ++n2;
        }
        return HDFNativeData.floatToByte(0, n, fArray);
    }

    private Float[] ByteToFloatObj(byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(byArray);
        int n = Array.getLength(fArray);
        Float[] floatArray = new Float[n];
        int n2 = 0;
        while (n2 < n) {
            floatArray[n2] = new Float(fArray[n2]);
            ++n2;
        }
        return floatArray;
    }

    private Float[] ByteToFloatObj(int n, int n2, byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(n, n2, byArray);
        int n3 = Array.getLength(fArray);
        Float[] floatArray = new Float[n3];
        int n4 = 0;
        while (n4 < n3) {
            floatArray[n4] = new Float(fArray[n4]);
            ++n4;
        }
        return floatArray;
    }

    private byte[] DoubleObjToByte(Double[] doubleArray) {
        int n = Array.getLength(doubleArray);
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = doubleArray[n2];
            ++n2;
        }
        return HDFNativeData.doubleToByte(0, n, dArray);
    }

    private Double[] ByteToDoubleObj(byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(byArray);
        int n = Array.getLength(dArray);
        Double[] doubleArray = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            doubleArray[n2] = new Double(dArray[n2]);
            ++n2;
        }
        return doubleArray;
    }

    private Double[] ByteToDoubleObj(int n, int n2, byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(n, n2, byArray);
        int n3 = Array.getLength(dArray);
        Double[] doubleArray = new Double[n3];
        int n4 = 0;
        while (n4 < n3) {
            doubleArray[n4] = new Double(dArray[n4]);
            ++n4;
        }
        return doubleArray;
    }

    private byte[] LongObjToByte(Long[] longArray) {
        int n = Array.getLength(longArray);
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = longArray[n2];
            ++n2;
        }
        return HDFNativeData.longToByte(0, n, lArray);
    }

    private Long[] ByteToLongObj(byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(byArray);
        int n = Array.getLength(lArray);
        Long[] longArray = new Long[n];
        int n2 = 0;
        while (n2 < n) {
            longArray[n2] = new Long(lArray[n2]);
            ++n2;
        }
        return longArray;
    }

    private Long[] ByteToLongObj(int n, int n2, byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(n, n2, byArray);
        int n3 = Array.getLength(lArray);
        Long[] longArray = new Long[n3];
        int n4 = 0;
        while (n4 < n3) {
            longArray[n4] = new Long(lArray[n4]);
            ++n4;
        }
        return longArray;
    }
}

