/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;

class ArrayDescriptor {
    static String theType = "";
    static Class theClass = null;
    static int[] dimlen = null;
    static int[] dimstart = null;
    static int[] currentindex = null;
    static int[] bytetoindex = null;
    static int totalSize = 0;
    static Object[] objs = null;
    static char NT = (char)32;
    static int NTsize = 0;
    static int dims = 0;
    static String className;

    public ArrayDescriptor(Object object) throws HDFException {
        Object object2;
        String string;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            HDFJavaException hDFJavaException = new HDFJavaException("ArrayDescriptor: not an array?: ");
            throw hDFJavaException;
        }
        theClass = clazz;
        theType = string = clazz.toString();
        int n = 6;
        dims = 0;
        int n2 = 32;
        while (n < string.length()) {
            n2 = string.charAt(n);
            ++n;
            if (n2 != 91) continue;
            ++dims;
        }
        String string2 = string.substring(string.lastIndexOf(91) + 1);
        Class<?> clazz2 = clazz.getComponentType();
        clazz2.toString();
        NT = (char)n2;
        if (NT == 'B') {
            NTsize = 1;
        } else if (NT == 'S') {
            NTsize = 2;
        } else if (NT == 'I' || NT == 'F') {
            NTsize = 4;
        } else if (NT == 'J' || NT == 'D') {
            NTsize = 8;
        } else if (string2.startsWith("Ljava.lang.Byte")) {
            NT = (char)76;
            className = "java.lang.Byte";
            NTsize = 1;
        } else if (string2.startsWith("Ljava.lang.Short")) {
            NT = (char)76;
            className = "java.lang.Short";
            NTsize = 2;
        } else if (string2.startsWith("Ljava.lang.Integer")) {
            NT = (char)76;
            className = "java.lang.Integer";
            NTsize = 4;
        } else if (string2.startsWith("Ljava.lang.Float")) {
            NT = (char)76;
            className = "java.lang.Float";
            NTsize = 4;
        } else if (string2.startsWith("Ljava.lang.Double")) {
            NT = (char)76;
            className = "java.lang.Double";
            NTsize = 8;
        } else if (string2.startsWith("Ljava.lang.Long")) {
            NT = (char)76;
            className = "java.lang.Long";
            NTsize = 8;
        } else {
            if (string2.startsWith("Ljava.lang.String")) {
                throw new HDFJavaException(new String("ArrayDesciptor: Error:  String array not supported yet"));
            }
            throw new HDFJavaException(new String("Error:  array is not numeric? (type is " + string2 + ")"));
        }
        dimlen = new int[dims + 1];
        dimstart = new int[dims + 1];
        currentindex = new int[dims + 1];
        bytetoindex = new int[dims + 1];
        objs = new Object[dims + 1];
        ArrayDescriptor.objs[0] = object2 = object;
        ArrayDescriptor.dimlen[0] = 1;
        ArrayDescriptor.dimstart[0] = 0;
        ArrayDescriptor.currentindex[0] = 0;
        int n3 = 1;
        while (n3 <= dims) {
            ArrayDescriptor.dimlen[n3] = Array.getLength(object2);
            ArrayDescriptor.objs[n3] = object2 = Array.get(object2, 0);
            ArrayDescriptor.dimstart[n3] = 0;
            ArrayDescriptor.currentindex[n3] = 0;
            ++n3;
        }
        ArrayDescriptor.bytetoindex[ArrayDescriptor.dims] = NTsize;
        n3 = dims;
        while (n3 >= 0) {
            int n4 = NTsize;
            int n5 = n3;
            while (n5 < dims) {
                n4 *= dimlen[n5 + 1];
                ++n5;
            }
            ArrayDescriptor.bytetoindex[n3] = n4;
            --n3;
        }
        totalSize = bytetoindex[0];
    }

    public void dumpInfo() {
        System.out.println("Type: " + theType);
        System.out.println("Class: " + theClass);
        System.out.println("NT: " + NT + " NTsize: " + NTsize);
        System.out.println("Array has " + dims + " dimensions (" + totalSize + " bytes)");
        int n = 0;
        while (n <= dims) {
            Class<?> clazz = objs[n].getClass();
            String string = clazz.toString();
            System.out.println(String.valueOf(n) + ":  start " + dimstart[n] + ": len " + dimlen[n] + " current " + currentindex[n] + " bytetoindex " + bytetoindex[n] + " object " + objs[n] + " otype " + string);
            ++n;
        }
    }
}

