/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib.exceptions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

public class HDF5LibraryException
extends HDF5Exception {
    public HDF5LibraryException() {
        try {
            H5.H5open();
        }
        catch (Exception exception) {}
        this.detailMessage = this.getMinorError(this.getMinorErrorNumber());
    }

    public HDF5LibraryException(String string) {
        super(string);
        try {
            H5.H5open();
        }
        catch (Exception exception) {}
    }

    public native int getMajorErrorNumber();

    public native int getMinorErrorNumber();

    public String getMinorError(int n) {
        if (n == HDF5Constants.H5E_NONE_MINOR) {
            return "special zero no error";
        }
        if (n == HDF5Constants.H5E_UNINITIALIZED) {
            return "information is unitialized";
        }
        if (n == HDF5Constants.H5E_UNSUPPORTED) {
            return "feature is unsupported";
        }
        if (n == HDF5Constants.H5E_BADTYPE) {
            return "incorrect type found";
        }
        if (n == HDF5Constants.H5E_BADRANGE) {
            return "argument out of range";
        }
        if (n == HDF5Constants.H5E_BADVALUE) {
            return "bad value for argument";
        }
        if (n == HDF5Constants.H5E_NOSPACE) {
            return "no space available for allocation";
        }
        if (n == HDF5Constants.H5E_CANTCOPY) {
            return "unable to copy object";
        }
        if (n == HDF5Constants.H5E_CANTFREE) {
            return "unable to free object";
        }
        if (n == HDF5Constants.H5E_ALREADYEXISTS) {
            return "Object already exists";
        }
        if (n == HDF5Constants.H5E_CANTLOCK) {
            return "Unable to lock object";
        }
        if (n == HDF5Constants.H5E_CANTUNLOCK) {
            return "Unable to unlock object";
        }
        if (n == HDF5Constants.H5E_FILEEXISTS) {
            return "file already exists";
        }
        if (n == HDF5Constants.H5E_FILEOPEN) {
            return "file already open";
        }
        if (n == HDF5Constants.H5E_CANTCREATE) {
            return "Can't create file";
        }
        if (n == HDF5Constants.H5E_CANTOPENFILE) {
            return "Can't open file";
        }
        if (n == HDF5Constants.H5E_CANTCLOSEFILE) {
            return "Can't close file";
        }
        if (n == HDF5Constants.H5E_NOTHDF5) {
            return "not an HDF5 format file";
        }
        if (n == HDF5Constants.H5E_BADFILE) {
            return "bad file ID accessed";
        }
        if (n == HDF5Constants.H5E_TRUNCATED) {
            return "file has been truncated";
        }
        if (n == HDF5Constants.H5E_MOUNT) {
            return "file mount error";
        }
        if (n == HDF5Constants.H5E_SEEKERROR) {
            return "seek failed";
        }
        if (n == HDF5Constants.H5E_READERROR) {
            return "read failed";
        }
        if (n == HDF5Constants.H5E_WRITEERROR) {
            return "write failed";
        }
        if (n == HDF5Constants.H5E_CLOSEERROR) {
            return "close failed";
        }
        if (n == HDF5Constants.H5E_OVERFLOW) {
            return "address overflowed";
        }
        if (n == HDF5Constants.H5E_FCNTL) {
            return "file fcntl failed";
        }
        if (n == HDF5Constants.H5E_CANTINIT) {
            return "Can't initialize object";
        }
        if (n == HDF5Constants.H5E_ALREADYINIT) {
            return "object already initialized";
        }
        if (n == HDF5Constants.H5E_CANTRELEASE) {
            return "Can't release object";
        }
        if (n == HDF5Constants.H5E_BADATOM) {
            return "Can't find atom information";
        }
        if (n == HDF5Constants.H5E_BADGROUP) {
            return "Can't find group information";
        }
        if (n == HDF5Constants.H5E_CANTREGISTER) {
            return "Can't register new atom";
        }
        if (n == HDF5Constants.H5E_CANTINC) {
            return "Can't increment reference count";
        }
        if (n == HDF5Constants.H5E_CANTDEC) {
            return "Can't decrement reference count";
        }
        if (n == HDF5Constants.H5E_NOIDS) {
            return "Out of IDs for group";
        }
        if (n == HDF5Constants.H5E_CANTFLUSH) {
            return "Can't flush object from cache";
        }
        if (n == HDF5Constants.H5E_CANTLOAD) {
            return "Can't load object into cache";
        }
        if (n == HDF5Constants.H5E_PROTECT) {
            return "protected object error";
        }
        if (n == HDF5Constants.H5E_NOTCACHED) {
            return "object not currently cached";
        }
        if (n == HDF5Constants.H5E_NOTFOUND) {
            return "object not found";
        }
        if (n == HDF5Constants.H5E_EXISTS) {
            return "object already exists";
        }
        if (n == HDF5Constants.H5E_CANTENCODE) {
            return "Can't encode value";
        }
        if (n == HDF5Constants.H5E_CANTDECODE) {
            return "Can't decode value";
        }
        if (n == HDF5Constants.H5E_CANTSPLIT) {
            return "Can't split node";
        }
        if (n == HDF5Constants.H5E_CANTINSERT) {
            return "Can't insert object";
        }
        if (n == HDF5Constants.H5E_CANTLIST) {
            return "Can't list node";
        }
        if (n == HDF5Constants.H5E_LINKCOUNT) {
            return "bad object header link count";
        }
        if (n == HDF5Constants.H5E_VERSION) {
            return "wrong version number";
        }
        if (n == HDF5Constants.H5E_ALIGNMENT) {
            return "alignment error";
        }
        if (n == HDF5Constants.H5E_BADMESG) {
            return "unrecognized message";
        }
        if (n == HDF5Constants.H5E_CANTDELETE) {
            return " Can't delete message";
        }
        if (n == HDF5Constants.H5E_CANTOPENOBJ) {
            return "Can't open object";
        }
        if (n == HDF5Constants.H5E_COMPLEN) {
            return "name component is too long";
        }
        if (n == HDF5Constants.H5E_LINK) {
            return "link count failure";
        }
        if (n == HDF5Constants.H5E_CANTCONVERT) {
            return "Can't convert datatypes";
        }
        if (n == HDF5Constants.H5E_BADSIZE) {
            return "Bad size for object";
        }
        if (n == HDF5Constants.H5E_CANTCLIP) {
            return "Can't clip hyperslab region";
        }
        if (n == HDF5Constants.H5E_CANTCOUNT) {
            return "Can't count elements";
        }
        if (n == HDF5Constants.H5E_CANTSELECT) {
            return "Can't select hyperslab";
        }
        if (n == HDF5Constants.H5E_CANTNEXT) {
            return "Can't move to next iterator location";
        }
        if (n == HDF5Constants.H5E_BADSELECT) {
            return "Invalid selection";
        }
        if (n == HDF5Constants.H5E_CANTGET) {
            return "Can't get value";
        }
        if (n == HDF5Constants.H5E_CANTSET) {
            return "Can't set value";
        }
        if (n == HDF5Constants.H5E_DUPCLASS) {
            return "Duplicate class name in parent class";
        }
        if (n == HDF5Constants.H5E_MPI) {
            return "some MPI function failed";
        }
        if (n == HDF5Constants.H5E_MPIERRSTR) {
            return "MPI Error String";
        }
        if (n == HDF5Constants.H5E_NOFILTER) {
            return "requested filter is not available";
        }
        if (n == HDF5Constants.H5E_CALLBACK) {
            return "callback failed";
        }
        if (n == HDF5Constants.H5E_CANAPPLY) {
            return "error from filter \"can apply\" callback";
        }
        if (n == HDF5Constants.H5E_SETLOCAL) {
            return "error from filter \"set local\" callback";
        }
        return "undefined error(" + n + ")";
    }

    @Override
    public void printStackTrace() {
        System.err.println(this);
        this.printStackTrace0(null);
        super.printStackTrace();
    }

    public void printStackTrace(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canWrite()) {
            this.printStackTrace();
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(this);
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println(this);
            }
            this.printStackTrace0(file.getPath());
            super.printStackTrace();
        }
    }

    private native void printStackTrace0(String var1);
}

