/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDF5GroupInfo;
import ncsa.hdf.hdf5lib.HDFArray;
import ncsa.hdf.hdf5lib.callbacks.H5L_iterate_cb;
import ncsa.hdf.hdf5lib.callbacks.H5L_iterate_t;
import ncsa.hdf.hdf5lib.callbacks.H5O_iterate_cb;
import ncsa.hdf.hdf5lib.callbacks.H5O_iterate_t;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5A_info_t;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5L_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;

public class H5 {
    public static final int[] LIB_VERSION = new int[]{1, 8, 6};
    public static final String H5PATH_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.hdf5lib";
    public static final String H5_LIBRARY_NAME_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.loadLibraryName";
    public static int LOGGING_LEVEL = 2;
    private static Logger s_logger;
    private static String s_libraryName;
    private static boolean isLibraryLoaded;
    private static final boolean IS_CRITICAL_PINNING = true;
    private static final Vector<Integer> OPEN_IDS;

    static {
        isLibraryLoaded = false;
        OPEN_IDS = new Vector();
        H5.loadH5Lib();
    }

    public static void loadH5Lib() {
        Comparable<File> comparable;
        Object object;
        block30: {
            String string;
            block28: {
                block26: {
                    if (isLibraryLoaded) {
                        return;
                    }
                    s_logger = Logger.getLogger("ncsa.hdf.hdf5lib");
                    if (LOGGING_LEVEL == 2) {
                        s_logger.setLevel(Level.SEVERE);
                    } else if (LOGGING_LEVEL == 1) {
                        s_logger.setLevel(Level.WARNING);
                    } else {
                        s_logger.setLevel(Level.INFO);
                    }
                    s_libraryName = System.getProperty(H5_LIBRARY_NAME_PROPERTY_KEY, null);
                    string = null;
                    if (s_libraryName != null && s_libraryName.length() > 0) {
                        try {
                            try {
                                string = System.mapLibraryName(s_libraryName);
                                System.loadLibrary(s_libraryName);
                                isLibraryLoaded = true;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                isLibraryLoaded = false;
                                s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                            throw throwable;
                        }
                        s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    }
                }
                if (!isLibraryLoaded && (object = System.getProperty(H5PATH_PROPERTY_KEY, null)) != null && ((String)object).length() > 0) {
                    comparable = new File((String)object);
                    if (((File)comparable).exists() && ((File)comparable).canRead() && ((File)comparable).isFile()) {
                        try {
                            try {
                                System.load((String)object);
                                isLibraryLoaded = true;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                isLibraryLoaded = false;
                                s_logger.log(Level.INFO, "HDF5 library: " + (String)object + (isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                                break block28;
                            }
                        }
                        catch (Throwable throwable) {
                            s_logger.log(Level.INFO, "HDF5 library: " + (String)object + (isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                            throw throwable;
                        }
                        s_logger.log(Level.INFO, "HDF5 library: " + (String)object + (isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                    } else {
                        isLibraryLoaded = false;
                        throw new UnsatisfiedLinkError("Invalid HDF5 library, " + (String)object);
                    }
                }
            }
            if (!isLibraryLoaded) {
                try {
                    try {
                        s_libraryName = "jhdf5";
                        string = System.mapLibraryName(s_libraryName);
                        System.loadLibrary("jhdf5");
                        isLibraryLoaded = true;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        isLibraryLoaded = false;
                        s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable;
                }
                s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
            }
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            System.exit(1);
        }
        H5.H5error_off();
        object = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5maj", null);
        comparable = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5min", null);
        Integer n = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5rel", null);
        if (object != null && comparable != null && n != null) {
            H5.H5check_version((Integer)object, (Integer)comparable, n);
        }
    }

    public static synchronized native int H5error_off();

    public static final int getOpenIDCount() {
        return OPEN_IDS.size();
    }

    public static final int getOpenID(int n) {
        int n2 = -1;
        if (n >= 0 && n < OPEN_IDS.size()) {
            n2 = OPEN_IDS.elementAt(n);
        }
        return n2;
    }

    public static synchronized native int H5open() throws HDF5LibraryException;

    public static synchronized native int H5close() throws HDF5LibraryException;

    private static synchronized native int H5dont_atexit() throws HDF5LibraryException;

    public static synchronized native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static synchronized native int H5check_version(int var0, int var1, int var2);

    public static synchronized native int H5garbage_collect() throws HDF5LibraryException;

    public static int H5Eclear() throws HDF5LibraryException {
        H5.H5Eclear2(HDF5Constants.H5E_DEFAULT);
        return 0;
    }

    @Deprecated
    public static int H5Acreate(int n, String string, int n2, int n3, int n4) throws HDF5LibraryException, NullPointerException {
        int n5 = H5._H5Acreate(n, string, n2, n3, n4);
        if (n5 > 0) {
            OPEN_IDS.addElement(n5);
        }
        return n5;
    }

    private static synchronized native int _H5Acreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Aopen_name(int n, String string) throws HDF5LibraryException, NullPointerException {
        int n2 = H5._H5Aopen_name(n, string);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Aopen_name(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Aopen_idx(int n, int n2) throws HDF5LibraryException {
        int n3 = H5._H5Aopen_idx(n, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Aopen_idx(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Awrite(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Awrite(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native int H5Acopy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Aread(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n3 = H5.H5Aread(n, n2, byArray);
        if (n3 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n3;
    }

    public static synchronized native int H5AreadVL(int var0, int var1, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Aget_space(int n) throws HDF5LibraryException {
        int n2 = H5._H5Aget_space(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Aget_space(int var0) throws HDF5LibraryException;

    public static int H5Aget_type(int n) throws HDF5LibraryException {
        int n2 = H5._H5Aget_type(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Aget_type(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Aget_name(int var0, long var1, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Aget_name(int n, String[] stringArray) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long l = H5.H5Aget_name(n, 0L, null);
        return H5.H5Aget_name(n, l + 1L, stringArray);
    }

    @Deprecated
    public static synchronized native int H5Aget_num_attrs(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Adelete(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Aclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Aclose(n);
    }

    private static synchronized native int _H5Aclose(int var0) throws HDF5LibraryException;

    @Deprecated
    public static int H5Dcreate(int n, String string, int n2, int n3, int n4) throws HDF5LibraryException, NullPointerException {
        int n5 = H5._H5Dcreate(n, string, n2, n3, n4);
        if (n5 > 0) {
            OPEN_IDS.addElement(n5);
        }
        return n5;
    }

    private static synchronized native int _H5Dcreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Dopen(int n, String string) throws HDF5LibraryException, NullPointerException {
        int n2 = H5._H5Dopen(n, string);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Dopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dchdir_ext(String var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dgetdir_ext(String[] var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Dget_space(int n) throws HDF5LibraryException {
        int n2 = H5._H5Dget_space(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Dget_space(int var0) throws HDF5LibraryException;

    public static int H5Dget_type(int n) throws HDF5LibraryException {
        int n2 = H5._H5Dget_type(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Dget_type(int var0) throws HDF5LibraryException;

    public static int H5Dget_create_plist(int n) throws HDF5LibraryException {
        int n2 = H5._H5Dget_create_plist(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Dget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dread(int var0, int var1, int var2, int var3, int var4, byte[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread(int n, int n2, int n3, int n4, int n5, byte[] byArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread(n, n2, n3, n4, n5, byArray, true);
    }

    public static synchronized native int H5DreadVL(int var0, int var1, int var2, int var3, int var4, Object[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread(int n, int n2, int n3, int n4, int n5, Object object, boolean bl) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n6 = -1;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl2 && c == 'B') {
            n6 = H5.H5Dread(n, n2, n3, n4, n5, (byte[])object, bl);
        } else if (bl2 && c == 'S') {
            n6 = H5.H5Dread_short(n, n2, n3, n4, n5, (short[])object, bl);
        } else if (bl2 && c == 'I') {
            n6 = H5.H5Dread_int(n, n2, n3, n4, n5, (int[])object, bl);
        } else if (bl2 && c == 'J') {
            n6 = H5.H5Dread_long(n, n2, n3, n4, n5, (long[])object);
        } else if (bl2 && c == 'F') {
            n6 = H5.H5Dread_float(n, n2, n3, n4, n5, (float[])object, bl);
        } else if (bl2 && c == 'D') {
            n6 = H5.H5Dread_double(n, n2, n3, n4, n5, (double[])object, bl);
        } else if (H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_DSETREG)) {
            n6 = H5.H5Dread_reg_ref(n, n2, n3, n4, n5, (String[])object);
        } else if (bl2 && clazz.getComponentType() == String.class) {
            n6 = H5.H5Tis_variable_str(n2) ? H5.H5DreadVL(n, n2, n3, n4, n5, (Object[])object) : H5.H5Dread_string(n, n2, n3, n4, n5, (String[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            n6 = H5.H5Dread(n, n2, n3, n4, n5, byArray, bl);
            if (n6 >= 0) {
                object = hDFArray.arrayify(byArray);
            }
            byArray = null;
            hDFArray = null;
        }
        return n6;
    }

    public static synchronized int H5Dread(int n, int n2, int n3, int n4, int n5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dread(n, n2, n3, n4, n5, object, true);
    }

    public static synchronized native int H5DwriteString(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, byte[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite(int n, int n2, int n3, int n4, int n5, byte[] byArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(n, n2, n3, n4, n5, byArray, true);
    }

    public static synchronized int H5Dwrite(int n, int n2, int n3, int n4, int n5, Object object, boolean bl) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n6 = -1;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl2 && c == 'B') {
            n6 = H5.H5Dwrite(n, n2, n3, n4, n5, (byte[])object, bl);
        } else if (bl2 && c == 'S') {
            n6 = H5.H5Dwrite_short(n, n2, n3, n4, n5, (short[])object, bl);
        } else if (bl2 && c == 'I') {
            n6 = H5.H5Dwrite_int(n, n2, n3, n4, n5, (int[])object, bl);
        } else if (bl2 && c == 'J') {
            n6 = H5.H5Dwrite_long(n, n2, n3, n4, n5, (long[])object, bl);
        } else if (bl2 && c == 'F') {
            n6 = H5.H5Dwrite_float(n, n2, n3, n4, n5, (float[])object, bl);
        } else if (bl2 && c == 'D') {
            n6 = H5.H5Dwrite_double(n, n2, n3, n4, n5, (double[])object, bl);
        } else if (H5.H5Tget_class(n2) == HDF5Constants.H5T_STRING && H5.H5Tis_variable_str(n2) && clazz.isArray() && clazz.getComponentType() == String.class && bl2) {
            n6 = H5.H5DwriteString(n, n2, n3, n4, n5, (String[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.byteify();
            n6 = H5.H5Dwrite(n, n2, n3, n4, n5, byArray, bl);
            byArray = null;
            hDFArray = null;
        }
        return n6;
    }

    public static synchronized int H5Dwrite(int n, int n2, int n3, int n4, int n5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(n, n2, n3, n4, n5, object, true);
    }

    @Deprecated
    public static synchronized native int H5Dextend(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized int H5Dextend(int n, long[] lArray) throws HDF5Exception, NullPointerException {
        int n2 = -1;
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        n2 = H5.H5Dextend(n, byArray);
        byArray = null;
        hDFArray = null;
        return n2;
    }

    public static int H5Dclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Dclose(n);
    }

    private static synchronized native int _H5Dclose(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_storage_size(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dcopy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Dvlen_get_buf_size(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException;

    public static synchronized native int H5Dvlen_reclaim(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Fopen(String string, int n, int n2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Fopen(string, n, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Fopen(String var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Fcreate(String string, int n, int n2, int n3) throws HDF5LibraryException, NullPointerException {
        int n4 = H5._H5Fcreate(string, n, n2, n3);
        if (n4 > 0) {
            OPEN_IDS.addElement(n4);
        }
        return n4;
    }

    private static synchronized native int _H5Fcreate(String var0, int var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fflush(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static int H5Fget_create_plist(int n) throws HDF5LibraryException {
        int n2 = H5._H5Fget_create_plist(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Fget_create_plist(int var0) throws HDF5LibraryException;

    public static int H5Fget_access_plist(int n) throws HDF5LibraryException {
        int n2 = H5._H5Fget_access_plist(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Fget_access_plist(int var0) throws HDF5LibraryException;

    public static int H5Fclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Fclose(n);
    }

    private static synchronized native int _H5Fclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fmount(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Funmount(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Freopen(int n) throws HDF5LibraryException {
        int n2 = H5._H5Freopen(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Freopen(int var0) throws HDF5LibraryException;

    @Deprecated
    public static int H5Gcreate(int n, String string, long l) throws HDF5LibraryException, NullPointerException {
        int n2 = H5._H5Gcreate(n, string, l);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Gcreate(int var0, String var1, long var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Gopen(int n, String string) throws HDF5LibraryException, NullPointerException {
        int n2 = H5._H5Gopen(n, string);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Gopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Gclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Gclose(n);
    }

    private static synchronized native int _H5Gclose(int var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Glink(int var0, int var1, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Glink2(int var0, String var1, int var2, int var3, String var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gunlink(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gmove(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_linkval(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized native int H5Gset_comment(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_comment(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Iget_type(int var0) throws HDF5LibraryException;

    public static int H5Pcreate(int n) throws HDF5LibraryException {
        int n2 = H5._H5Pcreate(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Pcreate(int var0) throws HDF5LibraryException;

    public static int H5Pclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Pclose(n);
    }

    private static synchronized native int _H5Pclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_class(int var0) throws HDF5LibraryException;

    public static int H5Pcopy(int n) throws HDF5LibraryException {
        int n2 = H5._H5Pcopy(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Pcopy(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_version(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_userblock(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_userblock(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_small_data_block_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_small_data_block_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_sizes(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sizes(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sym_k(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sym_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_istore_k(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_istore_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_layout(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_layout(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_chunk(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Pset_chunk(int n, int n2, long[] lArray) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Pset_chunk(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native int H5Pget_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_alignment(int var0, long var1, long var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_alignment(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_external(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_external_count(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_external(int var0, int var1, int var2, String[] var3, long[] var4) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static synchronized int H5Pset_fill_value(int n, int n2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Pset_fill_value(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native int H5Pget_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static synchronized int H5Pget_fill_value(int n, int n2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n3 = H5.H5Pget_fill_value(n, n2, byArray);
        if (n3 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n3;
    }

    public static synchronized native int H5Pset_filter(int var0, int var1, int var2, int var3, int[] var4) throws HDF5LibraryException;

    public static synchronized native int H5Pget_nfilters(int var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Pget_filter(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_cache(int var0, int var1, int var2, int var3, double var4) throws HDF5LibraryException;

    public static synchronized native int H5Pget_cache(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_buffer(int var0, int var1, byte[] var2, byte[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_buffer(int var0, byte[] var1, byte[] var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_preserve(int var0, boolean var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_preserve(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_deflate(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pset_gc_references(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_gc_references(int var0, boolean[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Pget_gc_reference(int n, boolean[] blArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Pget_gc_references(n, blArray);
    }

    public static synchronized native int H5Pset_btree_ratios(int var0, double var1, double var3, double var5) throws HDF5LibraryException;

    public static synchronized native int H5Pget_btree_ratios(int var0, double[] var1, double[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    private static synchronized native int H5Rcreate(byte[] var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized byte[] H5Rcreate(int n, String string, int n2, int n3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int n4 = 8;
        if (n2 == HDF5Constants.H5R_DATASET_REGION) {
            n4 = 12;
        }
        byte[] byArray = new byte[n4];
        H5.H5Rcreate(byArray, n, string, n2, n3);
        return byArray;
    }

    public static int H5Rdereference(int n, int n2, byte[] byArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int n3 = H5._H5Rdereference(n, n2, byArray);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Rdereference(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Rget_region(int n, int n2, byte[] byArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int n3 = H5._H5Rget_region(n, n2, byArray);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Rget_region(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized native int H5Rget_obj_type(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Screate(int n) throws HDF5LibraryException {
        int n2 = H5._H5Screate(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Screate(int var0) throws HDF5LibraryException;

    public static int H5Screate_simple(int n, long[] lArray, long[] lArray2) throws HDF5Exception, NullPointerException {
        int n2 = H5._H5Screate_simple(n, lArray, lArray2);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    public static synchronized native int _H5Screate_simple(int var0, long[] var1, long[] var2) throws HDF5Exception, NullPointerException;

    @Deprecated
    public static int H5Screate_simple(int n, byte[] byArray, byte[] byArray2) throws HDF5Exception, NullPointerException {
        ByteBuffer byteBuffer;
        long[] lArray;
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        long[] lArray2 = byteBuffer2.asLongBuffer().array();
        int n2 = H5._H5Screate_simple(n, lArray2, lArray = (byteBuffer = ByteBuffer.wrap(byArray2)).asLongBuffer().array());
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    public static int H5Scopy(int n) throws HDF5LibraryException {
        int n2 = H5._H5Scopy(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Scopy(int var0) throws HDF5LibraryException;

    private static synchronized native int H5Sselect_elements(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_elements(int n, int n2, int n3, long[][] lArray) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n4 = H5.H5Sselect_elements(n, n2, n3, byArray);
        byArray = null;
        hDFArray = null;
        return n4;
    }

    public static synchronized native int H5Sselect_all(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sselect_none(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_valid(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_simple_extent_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_ndims(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_dims(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_simple_extent_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_simple(int var0, int var1, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sset_extent_simple(int n, int n2, byte[] byArray, byte[] byArray2) throws HDF5LibraryException, NullPointerException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        long[] lArray = byteBuffer.asLongBuffer().array();
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        long[] lArray2 = byteBuffer2.asLongBuffer().array();
        return H5.H5Sset_extent_simple(n, n2, lArray, lArray2);
    }

    public static synchronized native boolean H5Sis_simple(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Soffset_simple(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Soffset_simple(int n, long[] lArray) throws HDF5Exception, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n2 = H5.H5Soffset_simple(n, byArray);
        byArray = null;
        hDFArray = null;
        return n2;
    }

    public static synchronized native int H5Sextent_copy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_none(int var0) throws HDF5LibraryException;

    public static synchronized int H5Sselect_hyperslab(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        long[] lArray = byteBuffer.asLongBuffer().array();
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        long[] lArray2 = byteBuffer2.asLongBuffer().array();
        ByteBuffer byteBuffer3 = ByteBuffer.wrap(byArray3);
        long[] lArray3 = byteBuffer3.asLongBuffer().array();
        ByteBuffer byteBuffer4 = ByteBuffer.wrap(byArray4);
        long[] lArray4 = byteBuffer4.asLongBuffer().array();
        return H5.H5Sselect_hyperslab(n, n2, lArray, lArray2, lArray3, lArray4);
    }

    public static synchronized native int H5Sselect_hyperslab(int var0, int var1, long[] var2, long[] var3, long[] var4, long[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Sclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Sclose(n);
    }

    private static synchronized native int _H5Sclose(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_hyper_nblocks(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_elem_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_hyper_blocklist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_elem_pointlist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_bounds(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Topen(int n, String string) throws HDF5LibraryException, NullPointerException {
        int n2 = H5._H5Topen(n, string);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Topen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Tcommit(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tcommit1(n, string, n2);
    }

    public static synchronized native int H5Tcommit1(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tcommitted(int var0) throws HDF5LibraryException;

    public static int H5Tcreate(int n, int n2) throws HDF5LibraryException {
        return H5.H5Tcreate(n, (long)n2);
    }

    public static int H5Tcopy(int n) throws HDF5LibraryException {
        int n2 = H5._H5Tcopy(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Tcopy(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Tequal(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tlock(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_class(int var0) throws HDF5LibraryException;

    public static String H5Tget_class_name(int n) {
        String string = null;
        string = HDF5Constants.H5T_INTEGER == n ? "H5T_INTEGER" : (HDF5Constants.H5T_FLOAT == n ? "H5T_FLOAT" : (HDF5Constants.H5T_TIME == n ? "H5T_TIME" : (HDF5Constants.H5T_STRING == n ? "H5T_STRING" : (HDF5Constants.H5T_BITFIELD == n ? "H5T_BITFIELD" : (HDF5Constants.H5T_OPAQUE == n ? "H5T_OPAQUE" : (HDF5Constants.H5T_COMPOUND == n ? "H5T_COMPOUND" : (HDF5Constants.H5T_REFERENCE == n ? "H5T_REFERENCE" : (HDF5Constants.H5T_ENUM == n ? "H5T_ENUM" : (HDF5Constants.H5T_VLEN == n ? "H5T_VLEN" : (HDF5Constants.H5T_ARRAY == n ? "H5T_ARRAY" : "H5T_NO_CLASS"))))))))));
        return string;
    }

    public static synchronized native int H5Tget_size(int var0) throws HDF5LibraryException;

    public static int H5Tset_size(int n, int n2) throws HDF5LibraryException {
        H5.H5Tset_size(n, (long)n2);
        return 0;
    }

    public static synchronized native int H5Tget_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_precision(int var0) throws HDF5LibraryException;

    public static int H5Tset_precision(int n, int n2) throws HDF5LibraryException {
        H5.H5Tset_precision(n, (long)n2);
        return 0;
    }

    public static synchronized native int H5Tget_offset(int var0) throws HDF5LibraryException;

    public static int H5Tset_offset(int n, int n2) throws HDF5LibraryException {
        H5.H5Tset_offset(n, (long)n2);
        return 0;
    }

    public static synchronized native int H5Tget_pad(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tset_pad(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_sign(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_sign(int var0, int var1) throws HDF5LibraryException;

    public static int H5Tget_fields(int n, int[] nArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        return H5.H5Tget_fields_int(n, nArray);
    }

    private static synchronized native int H5Tget_fields_int(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Tset_fields(int n, int n2, int n3, int n4, int n5, int n6) throws HDF5LibraryException {
        H5.H5Tset_fields(n, (long)n2, (long)n3, (long)n4, (long)n5, (long)n6);
        return 0;
    }

    public static synchronized native int H5Tget_ebias(int var0) throws HDF5LibraryException;

    public static int H5Tset_ebias(int n, int n2) throws HDF5LibraryException {
        H5.H5Tset_ebias(n, (long)n2);
        return 0;
    }

    public static synchronized native int H5Tget_norm(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_norm(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_inpad(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_inpad(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_cset(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_cset(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_strpad(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_strpad(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_nmembers(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Tget_member_name(int var0, int var1);

    public static synchronized native int H5Tget_member_index(int var0, String var1);

    public static synchronized native int H5Tget_member_class(int var0, int var1) throws HDF5LibraryException;

    public static int H5Tget_member_type(int n, int n2) throws HDF5LibraryException {
        int n3 = H5._H5Tget_member_type(n, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Tget_member_type(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Tget_member_offset(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tinsert(int var0, String var1, long var2, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tpack(int var0) throws HDF5LibraryException;

    public static int H5Tclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Tclose(n);
    }

    private static synchronized native int _H5Tclose(int var0) throws HDF5LibraryException;

    public static int H5Tenum_create(int n) throws HDF5LibraryException {
        int n2 = H5._H5Tenum_create(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Tenum_create(int var0) throws HDF5LibraryException;

    public static int H5Tenum_insert(int n, String string, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_insert_int(n, string, nArray);
    }

    public static int H5Tenum_insert(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int[] nArray = new int[]{n2};
        return H5.H5Tenum_insert_int(n, string, nArray);
    }

    private static synchronized native int H5Tenum_insert_int(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_nameof(int n, int[] nArray, String[] stringArray, int n2) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_nameof_int(n, nArray, stringArray, n2);
    }

    private static synchronized native int H5Tenum_nameof_int(int var0, int[] var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_valueof(int n, String string, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_valueof_int(n, string, nArray);
    }

    private static synchronized native int H5Tenum_valueof_int(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tvlen_create(int n) throws HDF5LibraryException {
        int n2 = H5._H5Tvlen_create(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Tvlen_create(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_tag(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native String H5Tget_tag(int var0) throws HDF5LibraryException;

    public static int H5Tget_super(int n) throws HDF5LibraryException {
        int n2 = H5._H5Tget_super(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Tget_super(int var0) throws HDF5LibraryException;

    public static int H5Tget_member_value(int n, int n2, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_member_value_int(n, n2, nArray);
    }

    private static synchronized native int H5Tget_member_value_int(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Tarray_create(int n, int n2, int[] nArray, int[] nArray2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Tarray_create(n, n2, nArray, nArray2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Tarray_create(int var0, int var1, int[] var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_array_ndims(int var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Tget_array_dims(int var0, int[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_num_objs(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native long H5Gget_objname_by_idx(int var0, long var1, String[] var3, long var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_objtype_by_idx(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Tget_native_type(int n, int n2) throws HDF5LibraryException {
        int n3 = H5._H5Tget_native_type(n, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Tget_native_type(int var0, int var1) throws HDF5LibraryException;

    public static synchronized long H5Gn_members_long(int n, String string) throws HDF5LibraryException, NullPointerException {
        int n2 = H5.H5Gopen(n, string);
        long l = -1L;
        try {
            H5G_info_t h5G_info_t = H5.H5Gget_info(n2);
            l = h5G_info_t.nlinks;
        }
        finally {
            H5.H5Gclose(n2);
        }
        return l;
    }

    public static synchronized int H5Gn_members(int n, String string) throws HDF5LibraryException, NullPointerException {
        return (int)H5.H5Gn_members_long(n, string);
    }

    public static synchronized int H5Gget_obj_info_idx(int n, String string, int n2, String[] stringArray, int[] nArray) throws HDF5LibraryException, NullPointerException {
        long l = 4096L;
        String[] stringArray2 = new String[]{new String("")};
        int n3 = H5.H5Gopen(n, string);
        long l2 = H5.H5Gget_objname_by_idx(n3, n2, stringArray2, l);
        int n4 = H5.H5Gget_objtype_by_idx(n3, n2);
        stringArray[0] = new String(stringArray2[0]);
        nArray[0] = n4;
        int n5 = new Long(l2).intValue();
        return n5;
    }

    public static synchronized int H5Gget_obj_info_all(int n, String string, String[] stringArray, int[] nArray, long[] lArray) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        if (nArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): object type array is null");
        }
        if (stringArray.length == 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): array size is zero");
        }
        if (stringArray.length != nArray.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_all(n, string, stringArray, nArray, new int[stringArray.length], lArray, stringArray.length, HDF5Constants.H5_INDEX_NAME);
    }

    public static synchronized int H5Gget_obj_info_all(int n, String string, String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, int n2) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        if (nArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): object type array is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): link type array is null");
        }
        if (stringArray.length == 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): array size is zero");
        }
        if (stringArray.length != nArray.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_all(n, string, stringArray, nArray, nArray2, lArray, stringArray.length, n2);
    }

    private static synchronized native int H5Gget_obj_info_all(int var0, String var1, String[] var2, int[] var3, int[] var4, long[] var5, int var6, int var7) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_objinfo(int var0, String var1, boolean var2, long[] var3, long[] var4, int[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized int H5Gget_objinfo(int n, String string, boolean bl, HDF5GroupInfo hDF5GroupInfo) throws HDF5LibraryException, NullPointerException {
        int n2 = -1;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        int[] nArray = new int[3];
        long[] lArray3 = new long[1];
        n2 = H5.H5Gget_objinfo(n, string, bl, lArray, lArray2, nArray, lArray3);
        if (n2 >= 0) {
            hDF5GroupInfo.setGroupInfo(lArray, lArray2, nArray[0], nArray[1], lArray3[0], nArray[2]);
        }
        return n2;
    }

    public static synchronized int H5Tget_native_type(int n) throws HDF5LibraryException {
        return H5.H5Tget_native_type(n, HDF5Constants.H5T_DIR_ASCEND);
    }

    public static synchronized native int H5Pset_alloc_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_alloc_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fill_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fill_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pfill_value_defined(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fletcher32(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_edc_check(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_edc_check(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shuffle(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_szip(int var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Dget_space_status(int n, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5._H5Dget_space_status(n, nArray);
    }

    private static synchronized native int _H5Dget_space_status(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Iget_name(int var0, String[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5set_free_list_limits(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static synchronized native int H5Fget_obj_ids(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fget_obj_count(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native boolean H5Tis_variable_str(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zfilter_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Zunregister(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pmodify_filter(int var0, int var1, int var2, long var3, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_filter_by_id(int var0, int var1, int[] var2, long[] var3, int[] var4, long var5, String[] var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pall_filters_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_hyper_vector_size(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_hyper_vector_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tdetect_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Dread_short(int var0, int var1, int var2, int var3, int var4, short[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_short(int n, int n2, int n3, int n4, int n5, short[] sArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_short(n, n2, n3, n4, n5, sArray, true);
    }

    public static synchronized native int H5Dread_int(int var0, int var1, int var2, int var3, int var4, int[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_int(int n, int n2, int n3, int n4, int n5, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_int(n, n2, n3, n4, n5, nArray, true);
    }

    public static synchronized native int H5Dread_long(int var0, int var1, int var2, int var3, int var4, long[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_long(int n, int n2, int n3, int n4, int n5, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_long(n, n2, n3, n4, n5, lArray, true);
    }

    public static synchronized native int H5Dread_float(int var0, int var1, int var2, int var3, int var4, float[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_float(int n, int n2, int n3, int n4, int n5, float[] fArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_float(n, n2, n3, n4, n5, fArray, true);
    }

    public static synchronized native int H5Dread_double(int var0, int var1, int var2, int var3, int var4, double[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_double(int n, int n2, int n3, int n4, int n5, double[] dArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_double(n, n2, n3, n4, n5, dArray, true);
    }

    public static synchronized native int H5Dread_string(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_reg_ref(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_short(int var0, int var1, int var2, int var3, int var4, short[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_short(int n, int n2, int n3, int n4, int n5, short[] sArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_short(n, n2, n3, n4, n5, sArray, true);
    }

    public static synchronized native int H5Dwrite_int(int var0, int var1, int var2, int var3, int var4, int[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_int(int n, int n2, int n3, int n4, int n5, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_int(n, n2, n3, n4, n5, nArray, true);
    }

    public static synchronized native int H5Dwrite_long(int var0, int var1, int var2, int var3, int var4, long[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_long(int n, int n2, int n3, int n4, int n5, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_long(n, n2, n3, n4, n5, lArray, true);
    }

    public static synchronized native int H5Dwrite_float(int var0, int var1, int var2, int var3, int var4, float[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_float(int n, int n2, int n3, int n4, int n5, float[] fArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_float(n, n2, n3, n4, n5, fArray, true);
    }

    public static synchronized native int H5Dwrite_double(int var0, int var1, int var2, int var3, int var4, double[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_double(int n, int n2, int n3, int n4, int n5, double[] dArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_double(n, n2, n3, n4, n5, dArray, true);
    }

    public static synchronized native int H5Pset_fclose_degree(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fclose_degree(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iinc_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Idec_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_family(int var0, long var1, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_family(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_core(int var0, int var1, boolean var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_core(int var0, int[] var1, boolean[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_family_offset(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_family_offset(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_log(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Fget_name(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Fget_filesize(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_file_id(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Premove_filter(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Zget_filter_info(int var0) throws HDF5LibraryException;

    public static synchronized native int H5INcreate(String var0, int var1, int var2, int var3, String var4, String var5, long var6);

    public static synchronized native int H5INquery(int var0, String[] var1, Object var2, Object var3, int var4);

    public static synchronized native int H5Pset(int var0, String var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pexist(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_size(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nprops(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Pget_class_name(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_class_parent(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pisa_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pequal(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pcopy_prop(int var0, int var1, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Premove(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Punregister(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pclose_class(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Eregister_class(String var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eunregister_class(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_msg(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Ecreate_msg(int var0, int var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Ecreate_stack() throws HDF5LibraryException;

    public static synchronized native int H5Eget_current_stack() throws HDF5LibraryException;

    public static synchronized native void H5Eclose_stack(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Eget_class_name(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eset_current_stack(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Epop(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Eprint2(int var0, Object var1) throws HDF5LibraryException;

    public static void H5Eclear(int n) throws HDF5LibraryException {
        H5.H5Eclear2(n);
    }

    public static synchronized native void H5Eclear2(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Eauto_is_v2(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Eget_msg(int var0, int[] var1) throws HDF5LibraryException;

    public static synchronized native long H5Eget_num(int var0) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native void H5Eprint1(Object var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_intent(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_count_long(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_ids_long(int var0, int var1, long var2, int[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Fget_freespace(int var0) throws HDF5LibraryException;

    public static synchronized native double H5Fget_mdc_hit_rate(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_mdc_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Freset_mdc_hit_rate_stats(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Fget_name(int var0) throws HDF5LibraryException;

    public static int H5Gcreate(int n, String string, int n2, int n3, int n4) throws HDF5LibraryException, NullPointerException {
        int n5 = H5._H5Gcreate2(n, string, n2, n3, n4);
        if (n5 > 0) {
            OPEN_IDS.addElement(n5);
        }
        return n5;
    }

    public static synchronized native int _H5Gcreate2(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static int H5Gcreate_anon(int n, int n2, int n3) throws HDF5LibraryException {
        int n4 = H5._H5Gcreate_anon(n, n2, n3);
        if (n4 > 0) {
            OPEN_IDS.addElement(n4);
        }
        return n4;
    }

    public static synchronized native int _H5Gcreate_anon(int var0, int var1, int var2) throws HDF5LibraryException;

    public static int H5Gopen(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Gopen2(n, string, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    public static synchronized native int _H5Gopen2(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info(int var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info_by_name(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5G_info_t H5Gget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_max(int n, String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, int n2) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): name array is null");
        }
        if (nArray == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): object type array is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): link type array is null");
        }
        if (stringArray.length <= 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): array size is zero");
        }
        if (n2 <= 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): maximum array size is zero");
        }
        if (stringArray.length != nArray.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_max(n, stringArray, nArray, nArray2, lArray, n2, stringArray.length);
    }

    private static synchronized native int H5Gget_obj_info_max(int var0, String[] var1, int[] var2, int[] var3, long[] var4, int var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcopy(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_external(String var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_hard(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_soft(String var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Lexists(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Lget_name_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_val(int var0, String var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_val_by_idx(int var0, String var1, int var2, int var3, long var4, String[] var6, int var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lmove(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lvisit(int var0, int var1, int var2, H5L_iterate_cb var3, H5L_iterate_t var4) throws HDF5LibraryException;

    public static synchronized native int H5Lvisit_by_name(int var0, String var1, int var2, int var3, H5L_iterate_cb var4, H5L_iterate_t var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Literate(int var0, int var1, int var2, long var3, H5L_iterate_cb var5, H5L_iterate_t var6) throws HDF5LibraryException;

    public static synchronized native int H5Literate_by_name(int var0, String var1, int var2, int var3, long var4, H5L_iterate_cb var6, H5L_iterate_t var7, int var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Sextent_equal(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native byte[] H5Sencode(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static int H5Tcreate(int n, long l) throws HDF5LibraryException {
        int n2 = H5._H5Tcreate(n, l);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Tcreate(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Tcommit(int var0, String var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Topen(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Topen2(n, string, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Topen2(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tcommit_anon(int var0, int var1, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Tget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tencode(int var0, byte[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tenum_insert(int var0, String var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Tenum_nameof(int var0, byte[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tenum_valueof(int var0, String var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tarray_create(int n, int n2, long[] lArray) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Tarray_create2(n, n2, lArray);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Tarray_create2(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tget_array_dims(int n, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_array_dims2(n, lArray);
    }

    public static synchronized native int H5Tget_array_dims2(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Tget_size_long(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Tget_precision_long(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tget_fields(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Tget_ebias_long(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tget_member_value(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tset_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Tset_precision(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Tset_offset(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Tset_fields(int var0, long var1, long var3, long var5, long var7, long var9) throws HDF5LibraryException;

    public static synchronized native void H5Tset_ebias(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Tcompiler_conv(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5Tconvert(int var0, int var1, long var2, byte[] var4, byte[] var5, int var6) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Tget_array_dims(int n, long[] lArray, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_array_dims1(n, lArray, nArray);
    }

    @Deprecated
    private static synchronized native int H5Tget_array_dims1(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Dcreate(int n, String string, int n2, int n3, int n4, int n5, int n6) throws HDF5LibraryException, NullPointerException {
        int n7 = H5._H5Dcreate2(n, string, n2, n3, n4, n5, n6);
        if (n7 > 0) {
            OPEN_IDS.addElement(n7);
        }
        return n7;
    }

    private static synchronized native int _H5Dcreate2(int var0, String var1, int var2, int var3, int var4, int var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Dcreate_anon(int n, int n2, int n3, int n4, int n5) throws HDF5LibraryException {
        int n6 = H5._H5Dcreate_anon(n, n2, n3, n4, n5);
        if (n6 > 0) {
            OPEN_IDS.addElement(n6);
        }
        return n6;
    }

    private static synchronized native int _H5Dcreate_anon(int var0, int var1, int var2, int var3, int var4) throws HDF5LibraryException;

    public static int H5Dopen(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Dopen2(n, string, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Dopen2(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dget_space_status(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dget_access_plist(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_offset(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Dvlen_get_buf_size(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Dfill(byte[] var0, int var1, byte[] var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Dset_extent(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Rget_name(int var0, int var1, byte[] var2, String[] var3, long var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Rget_obj_type(int n, int n2, byte[] byArray, int[] nArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        return H5.H5Rget_obj_type2(n, n2, byArray, nArray);
    }

    private static synchronized native int H5Rget_obj_type2(int var0, int var1, byte[] var2, int[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Pget_nlinks(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_nlinks(int var0, long var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_libver_bounds(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_libver_bounds(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_link_creation_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_link_creation_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_attr_creation_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_attr_creation_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5Pset_copy_object(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_copy_object(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_create_intermediate_group(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_create_intermediate_group(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_data_transform(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_data_transform(int var0, String[] var1, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_elink_acc_flags(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_acc_flags(int var0, int var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_link_phase_change(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_link_phase_change(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_attr_phase_change(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_shared_mesg_phase_change(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shared_mesg_phase_change(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_nindexes(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_shared_mesg_nindexes(int var0, int var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_shared_mesg_index(int var0, int var1, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_index(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_local_heap_size_hint(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_local_heap_size_hint(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_nbit(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_scaleoffset(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_est_link_info(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_est_link_info(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_elink_fapl(int var0, int var1) throws HDF5LibraryException;

    public static int H5Pget_elink_fapl(int n) throws HDF5LibraryException {
        int n2 = H5._H5Pget_elink_fapl(n);
        if (n2 > 0) {
            OPEN_IDS.addElement(n2);
        }
        return n2;
    }

    private static synchronized native int _H5Pget_elink_fapl(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_prefix(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_elink_prefix(int var0, String[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_direct(int var0, int var1, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_fapl_direct(int var0, int[] var1) throws HDF5LibraryException;

    public static int H5Pget_filter(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, String[] stringArray, int[] nArray4) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter2(n, n2, nArray, nArray2, nArray3, n3, stringArray, nArray4);
    }

    private static synchronized native int H5Pget_filter2(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6, int[] var7) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_type_ref(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Inmembers(int var0) throws HDF5LibraryException;

    public static int H5Acreate(int n, String string, int n2, int n3, int n4, int n5) throws HDF5LibraryException, NullPointerException {
        int n6 = H5._H5Acreate2(n, string, n2, n3, n4, n5);
        if (n6 > 0) {
            OPEN_IDS.addElement(n6);
        }
        return n6;
    }

    private static synchronized native int _H5Acreate2(int var0, String var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Aopen(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Aopen(n, string, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    private static synchronized native int _H5Aopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Aopen_by_idx(int n, String string, int n2, int n3, long l, int n4, int n5) throws HDF5LibraryException, NullPointerException {
        int n6 = H5._H5Aopen_by_idx(n, string, n2, n3, l, n4, n5);
        if (n6 > 0) {
            OPEN_IDS.addElement(n6);
        }
        return n6;
    }

    private static synchronized native int _H5Aopen_by_idx(int var0, String var1, int var2, int var3, long var4, int var6, int var7) throws HDF5LibraryException, NullPointerException;

    public static int H5Acreate_by_name(int n, String string, String string2, int n2, int n3, int n4, int n5, int n6) throws HDF5LibraryException, NullPointerException {
        int n7 = H5._H5Acreate_by_name(n, string, string2, n2, n3, n4, n5, n6);
        if (n7 > 0) {
            OPEN_IDS.addElement(n7);
        }
        return n7;
    }

    private static synchronized native int _H5Acreate_by_name(int var0, String var1, String var2, int var3, int var4, int var5, int var6, int var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename_by_name(int var0, String var1, String var2, String var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Aget_name_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Aget_storage_size(int var0) throws HDF5LibraryException;

    public static synchronized native H5A_info_t H5Aget_info(int var0) throws HDF5LibraryException;

    public static synchronized native H5A_info_t H5Aget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Adelete_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Aopen_by_name(int n, String string, String string2, int n2, int n3) throws HDF5LibraryException, NullPointerException {
        int n4 = H5._H5Aopen_by_name(n, string, string2, n2, n3);
        if (n4 > 0) {
            OPEN_IDS.addElement(n4);
        }
        return n4;
    }

    private static synchronized native int _H5Aopen_by_name(int var0, String var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static int H5Oopen(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int n3 = H5._H5Oopen(n, string, n2);
        if (n3 > 0) {
            OPEN_IDS.addElement(n3);
        }
        return n3;
    }

    public static synchronized native int _H5Oopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ocopy(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5O_info_t H5Oget_info(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5O_info_t H5Oget_info_by_name(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5O_info_t H5Oget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Olink(int var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Oset_comment(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native void H5Oset_comment_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Oget_comment(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Oget_comment_by_name(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Ovisit(int var0, int var1, int var2, H5O_iterate_cb var3, H5O_iterate_t var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Ovisit_by_name(int var0, String var1, int var2, int var3, H5O_iterate_cb var4, H5O_iterate_t var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Oclose(int n) throws HDF5LibraryException {
        if (n < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(n);
        return H5._H5Oclose(n);
    }

    private static synchronized native int _H5Oclose(int var0) throws HDF5LibraryException;
}

