/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.xml;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.digester.substitution.MultiVariableExpander;
import org.apache.commons.digester.substitution.VariableExpander;
import org.apache.commons.digester.substitution.VariableSubstitutor;
import org.dawb.common.util.io.Grep;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtils {
    private static final String VARIABLE_EXPRESSION = "\\$\\{([a-zA-Z0-9_ ]+)\\}";
    private static final Pattern HEADER_PATTERN = Pattern.compile("^\\<\\?.+\\?\\>(.*)", 32);

    public static List<String> getVariables(String string) throws Exception {
        return Grep.group(string, VARIABLE_EXPRESSION, 1);
    }

    public static List<CharSequence> getVariables(IFile iFile) throws Exception {
        return Grep.group(iFile, VARIABLE_EXPRESSION, 1);
    }

    public static Map<String, String> getVariables(Map map, String string, Map<String, String> map2) throws Exception {
        XPathExpression xPathExpression;
        String string2;
        Object object2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = null;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        for (Object object2 : map.keySet()) {
            string2 = (String)map.get(object2.toString());
            if (string2 == null || "".equals(string2)) {
                hashMap.put(object2.toString(), map2.get(object2));
                continue;
            }
            if ("/".equals(string2)) {
                hashMap.put(object2.toString(), string);
                continue;
            }
            xPathExpression = xPath.compile(string2);
            if (document == null) {
                document = documentBuilder.parse(new InputSource(new StringReader(string)));
            }
            Object object3 = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            hashMap.put(object2.toString(), XMLUtils.getNodeValue((NodeList)object3));
        }
        object2 = new HashMap(hashMap.size());
        object2.putAll(map2);
        object2.putAll(hashMap);
        HashMap hashMap2 = new HashMap(map.size());
        string2 = new MultiVariableExpander();
        string2.addSource("$", (Map)object2);
        xPathExpression = new VariableSubstitutor((VariableExpander)string2);
        for (Object object3 : hashMap.keySet()) {
            if (!((String)object3).contains("$")) {
                hashMap2.put(object3, (String)hashMap.get(object3));
                continue;
            }
            hashMap2.put(xPathExpression.substitute((String)object3), (String)hashMap.get(object3));
        }
        return hashMap2;
    }

    private static String getNodeValue(NodeList nodeList) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setURIResolver(null);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nodeList.getLength()) {
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(nodeList.item(n)), new StreamResult(stringWriter));
            String string = stringWriter.toString();
            Matcher matcher = HEADER_PATTERN.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(1);
            }
            stringBuilder.append(string);
            stringBuilder.append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String getXPathValue(IFile iFile, String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(string);
        Document document = documentBuilder.parse(new InputSource(iFile.getContents()));
        NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        return XMLUtils.getNodeValue(nodeList);
    }

    public static String getXPathValue(File file, String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(string);
        Document document = documentBuilder.parse(new InputSource(file.getAbsolutePath()));
        NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        return XMLUtils.getNodeValue(nodeList);
    }

    public static void isLegalXPath(String string) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.compile(string);
    }
}

