/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class TokenFileParser {
    private String token = "\\t";
    private String commentChar = "#";
    private List<List<String>> data = new ArrayList<List<String>>(7);
    private BufferedReader reader;

    public TokenFileParser(URL uRL) throws IOException {
        this(uRL.openStream());
    }

    public TokenFileParser(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public TokenFileParser(InputStream inputStream) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
    }

    public void parse() throws IOException {
        boolean bl = true;
        String string = null;
        while ((string = this.reader.readLine()) != null) {
            if (this.getCommentChar() != null && string.startsWith(this.getCommentChar())) continue;
            String[] stringArray = string.trim().split(this.token);
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2].trim();
                if (!"".equals(string2)) {
                    if (bl) {
                        this.data.add(new ArrayList(31));
                    }
                    List<String> list = this.data.get(n);
                    list.add(string2);
                    ++n;
                }
                ++n2;
            }
            bl = false;
        }
    }

    public List<String> getColumn(int n) {
        return this.data.get(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.data.get(0).size();
        int n2 = 0;
        while (n2 < n) {
            for (List<String> list : this.data) {
                stringBuilder.append("\t");
                stringBuilder.append(list.get(n2));
            }
            stringBuilder.append("\n");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/fcp94556/workspace/uk.ac.gda.core/src/gda/gui/exafs/Element-CoreHole.txt");
        TokenFileParser tokenFileParser = new TokenFileParser(file);
        System.out.println(tokenFileParser);
    }

    public Double[] getColumnAsDoubleArray(int n, int ... nArray) {
        List<Double> list = this.getColumnAsDoubleList(n, nArray);
        return list.toArray(new Double[list.size()]);
    }

    public List<Double> getColumnAsDoubleList(int n, int ... nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        int n2 = 0;
        while (n2 < nArray.length) {
            arrayList.add(nArray[n2]);
            ++n2;
        }
        List<String> list = this.data.get(n);
        ArrayList<Double> arrayList2 = new ArrayList<Double>(list.size());
        int n3 = 0;
        while (n3 < list.size()) {
            if (!arrayList.contains(n3)) {
                arrayList2.add(Double.parseDouble(list.get(n3)));
            }
            ++n3;
        }
        return arrayList2;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(String string) {
        this.commentChar = string;
    }
}

