/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.dawb.common.util.list.SortNatural;

public class SortingUtils {
    public static final Comparator<File> NATURAL_SORT = new SortNatural<File>(true);
    public static final Comparator<File> NATURAL_SORT_CASE_INSENSITIVE = new SortNatural<File>(false);
    public static final Comparator<File> DATE_SORT = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            long l = file.lastModified() - file2.lastModified();
            if (l == 0L) {
                return NATURAL_SORT.compare(file, file2);
            }
            if (l > 0L) {
                return (int)file2.lastModified();
            }
            return -1;
        }
    };
    public static final Comparator<File> DATE_SORT_BACKWARDS = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            long l = file2.lastModified() - file.lastModified();
            if (l == 0L) {
                return NATURAL_SORT.compare(file, file2);
            }
            if (l > 0L) {
                return (int)file.lastModified();
            }
            return -1;
        }
    };
    public static final Comparator<File> DEFAULT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return file.compareTo(file2);
        }
    };

    public static List<File> getSortedFileList(File file) {
        return SortingUtils.getSortedFileList(file, DEFAULT_COMPARATOR);
    }

    public static List<File> getSortedFileList(File file, Comparator<File> comparator) {
        return SortingUtils.getSortedFileList(file.listFiles(), comparator);
    }

    public static List<File> getSortedFileList(File file, FileFilter fileFilter, Comparator<File> comparator) {
        return SortingUtils.getSortedFileList(file.listFiles(fileFilter), comparator);
    }

    public static List<File> getSortedFileList(File file, FileFilter fileFilter) {
        return SortingUtils.getSortedFileList(file.listFiles(fileFilter), DEFAULT_COMPARATOR);
    }

    public static List<File> getSortedFileList(File[] fileArray, Comparator<File> comparator) {
        if (fileArray == null || fileArray.length < 1) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        arrayList.addAll(Arrays.asList(fileArray));
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static void removeIgnoredNames(Collection<String> collection, Collection<Pattern> collection2) {
        if (collection2 == null) {
            return;
        }
        if (collection == null) {
            return;
        }
        Iterator<String> iterator = collection.iterator();
        block0: while (iterator.hasNext()) {
            String string = iterator.next();
            for (Pattern pattern : collection2) {
                if (!pattern.matcher(string).matches()) continue;
                iterator.remove();
                continue block0;
            }
        }
    }
}

