/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static void close(FileChannel fileChannel, String string) {
        if (fileChannel == null) {
            logger.error("FileChannel is null", (Object)string);
            return;
        }
        try {
            fileChannel.close();
        }
        catch (IOException iOException) {
            logger.error("Cannot close stream", (Throwable)iOException);
        }
    }

    public static void close(ZipFile zipFile, String string) {
        if (zipFile == null) {
            logger.error("ZipFile is null", (Object)string, (Object)1);
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            logger.error("Cannot close stream", (Throwable)iOException);
        }
    }

    public static void close(Reader reader, String string) {
        if (reader == null) {
            logger.error("Reader is null", (Object)string, (Object)1);
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            logger.error("Cannot close stream", (Throwable)iOException);
        }
    }

    public static void close(Writer writer, String string) {
        if (writer == null) {
            logger.error("Writer is null", (Object)string, (Object)1);
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            logger.error("Cannot close stream", (Throwable)iOException);
        }
    }

    public static void close(OutputStream outputStream, String string) {
        if (outputStream == null) {
            logger.error("OutputStream is null", (Object)string, (Object)1);
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            logger.error("Cannot close stream", (Throwable)iOException);
        }
    }

    public static void close(InputStream inputStream, String string) {
        if (inputStream == null) {
            logger.error("InputStream is null", (Object)string, (Object)1);
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            logger.error("Cannot close stream", (Throwable)iOException);
        }
    }

    public static String fileInfo(File file) {
        if (file == null) {
            return "File is null";
        }
        return file.getPath();
    }

    public static String fileInfo(ZipFile zipFile) {
        if (zipFile == null) {
            return "File is null";
        }
        return zipFile.getName();
    }
}

