/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.io;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;

public class IOCollectionUtils {
    public static void saveCollection(String string, Collection<?> collection) throws Exception {
        IOCollectionUtils.saveCollection(new File(string), collection);
    }

    public static void saveCollection(File file, Collection<?> collection) throws Exception {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(file));
        try {
            xMLEncoder.writeObject(collection);
        }
        finally {
            xMLEncoder.close();
        }
    }

    public static Collection<?> readCollection(String string) throws Exception {
        return IOCollectionUtils.readCollection(new File(string));
    }

    public static Collection<?> readCollection(File file) throws Exception {
        XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(file));
        try {
            Collection collection = (Collection)xMLDecoder.readObject();
            return collection;
        }
        finally {
            xMLDecoder.close();
        }
    }
}

