/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IFileUtils {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\/?(\\w+)(\\/.+)");

    public static void setReadOnly(IContainer iContainer, boolean bl) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] instanceof IFile) {
                IFile iFile = (IFile)iResourceArray[n];
                ResourceAttributes resourceAttributes = iFile.getResourceAttributes();
                if (!(resourceAttributes.isHidden() || iFile.isHidden() || iFile.getName().startsWith("."))) {
                    resourceAttributes.setReadOnly(true);
                    ((IFile)iResourceArray[n]).setResourceAttributes(resourceAttributes);
                }
            } else if (iResourceArray[n] instanceof IContainer) {
                IFileUtils.setReadOnly((IContainer)iResourceArray[n], bl);
            }
            ++n;
        }
    }

    public static IFile getUniqueIFile(IContainer iContainer, String string, String string2) {
        if (iContainer instanceof IFolder) {
            return IFileUtils.getUniqueIFile((IFolder)iContainer, string, string2);
        }
        if (iContainer instanceof IProject) {
            return IFileUtils.getUniqueIFile((IProject)iContainer, string, string2);
        }
        return null;
    }

    public static IFile getUniqueIFile(IFolder iFolder, String string, String string2) {
        return IFileUtils.getUniqueIFile(iFolder, string, 1, string2);
    }

    private static IFile getUniqueIFile(IFolder iFolder, String string, int n, String string2) {
        IFile iFile = iFolder.getFile(String.valueOf(string) + n + "." + string2);
        if (!iFile.exists()) {
            return iFile;
        }
        return IFileUtils.getUniqueIFile(iFolder, string, n + 1, string2);
    }

    public static IFile getUniqueIFile(IProject iProject, String string, String string2) {
        return IFileUtils.getUniqueIFile(iProject, string, 1, string2);
    }

    private static IFile getUniqueIFile(IProject iProject, String string, int n, String string2) {
        IFile iFile = iProject.getFile(String.valueOf(string) + n + "." + string2);
        if (!iFile.exists()) {
            return iFile;
        }
        return IFileUtils.getUniqueIFile(iProject, string, n + 1, string2);
    }

    public static String getPathWithoutProject(String string) {
        Matcher matcher = PATH_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }

    public static IContainer getContainer(String string, String string2, String string3) throws Exception {
        String string4;
        IContainer iContainer = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(string, true);
        if (iContainer != null) {
            return iContainer;
        }
        Matcher matcher = PATH_PATTERN.matcher(string);
        if (matcher.matches()) {
            IFolder iFolder;
            string4 = matcher.group(1);
            IProject iProject = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(string4, true);
            String string5 = matcher.group(2);
            if (("/" + string3 + "/").equals(string5)) {
                iFolder = iProject.getFolder(string3);
            } else {
                IResource iResource = iProject.findMember(string5);
                if (iResource == null) {
                    iResource = iProject.getFolder(string5);
                }
                IContainer iContainer2 = iFolder = iResource instanceof IContainer ? (IContainer)iResource : null;
                if (iFolder == null && (iFolder = iProject.getFolder((IPath)new Path(string5))) != null && !iFolder.exists()) {
                    iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            if (iFolder == null) {
                iFolder = iProject.getFolder(string3);
            }
            iContainer = iFolder;
            if (iFolder != null && !iFolder.exists() && iFolder instanceof IFolder) {
                IFileUtils.mkdirs(iFolder);
            }
        }
        if (iContainer == null && !(iContainer = (string4 = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(string2, true)).getFolder(string3)).exists()) {
            ((IFolder)iContainer).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return iContainer;
    }

    public static void mkdirs(IFolder iFolder) throws CoreException {
        IContainer iContainer = iFolder.getParent();
        if (!iContainer.exists()) {
            IFileUtils.mkdirs((IFolder)iContainer);
        }
        iFolder.create(true, true, null);
    }
}

