/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;

public class Grep {
    private static Pattern LINE_PATTERN = Pattern.compile(".*\r?\n?");

    private static void grep(CharBuffer charBuffer, Pattern pattern, List<CharSequence> list) {
        Matcher matcher = LINE_PATTERN.matcher(charBuffer);
        Matcher matcher2 = null;
        while (matcher.find()) {
            String string = matcher.group();
            if (matcher2 == null) {
                matcher2 = pattern.matcher(string);
            } else {
                matcher2.reset(string);
            }
            while (matcher2.find()) {
                list.add(string);
            }
            if (matcher.end() == charBuffer.limit()) break;
        }
    }

    public static List<CharSequence> grep(File file, String string, String string2) throws Exception {
        return Grep.grep(new FileInputStream(file), string, string2);
    }

    public static List<CharSequence> grep(IFile iFile, String string) throws Exception {
        FileInputStream fileInputStream = null;
        InputStream inputStream = iFile.getContents();
        fileInputStream = inputStream instanceof FileInputStream ? (FileInputStream)inputStream : new FileInputStream(iFile.getLocation().toFile());
        return Grep.grep(fileInputStream, string, iFile.getCharset());
    }

    public static List<CharSequence> grep(FileInputStream fileInputStream, String string, String string2) throws IOException {
        Charset charset = Charset.forName(string2);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        Pattern pattern = Pattern.compile(string);
        FileChannel fileChannel = fileInputStream.getChannel();
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(7);
        try {
            int n = (int)fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
            Grep.grep(charBuffer, pattern, arrayList);
        }
        finally {
            fileChannel.close();
        }
        return arrayList;
    }

    public static Matcher matcher(File file, String string, String string2) throws Exception {
        return Grep.matcher(new FileInputStream(file), string, string2);
    }

    public static Matcher matcher(IFile iFile, String string) throws Exception {
        FileInputStream fileInputStream = null;
        InputStream inputStream = iFile.getContents();
        fileInputStream = inputStream instanceof FileInputStream ? (FileInputStream)inputStream : new FileInputStream(iFile.getLocation().toFile());
        return Grep.matcher(fileInputStream, string, iFile.getCharset());
    }

    public static Matcher matcher(FileInputStream fileInputStream, String string, String string2) throws IOException {
        Charset charset = Charset.forName(string2);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        Pattern pattern = Pattern.compile(string);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            int n = (int)fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
            Matcher matcher = Grep.matcher(charBuffer, pattern);
            return matcher;
        }
        finally {
            fileChannel.close();
        }
    }

    private static Matcher matcher(CharBuffer charBuffer, Pattern pattern) {
        Matcher matcher = LINE_PATTERN.matcher(charBuffer);
        Matcher matcher2 = null;
        while (matcher.find()) {
            String string = matcher.group();
            if (matcher2 == null) {
                matcher2 = pattern.matcher(string);
            } else {
                matcher2.reset(string);
            }
            if (matcher2.find()) {
                return matcher2;
            }
            if (matcher.end() == charBuffer.limit()) break;
        }
        return null;
    }

    private static void group(CharBuffer charBuffer, Pattern pattern, List<CharSequence> list, int n) {
        Matcher matcher = LINE_PATTERN.matcher(charBuffer);
        Matcher matcher2 = null;
        while (matcher.find()) {
            String string = matcher.group();
            if (matcher2 == null) {
                matcher2 = pattern.matcher(string);
            } else {
                matcher2.reset(string);
            }
            while (matcher2.find()) {
                list.add(matcher2.group(n));
            }
            if (matcher.end() == charBuffer.limit()) break;
        }
    }

    public static List<CharSequence> group(File file, String string, String string2, int n) throws Exception {
        return Grep.group(new FileInputStream(file), string, string2, n);
    }

    public static List<CharSequence> group(IFile iFile, String string, int n) throws Exception {
        FileInputStream fileInputStream = null;
        InputStream inputStream = iFile.getContents();
        fileInputStream = inputStream instanceof FileInputStream ? (FileInputStream)inputStream : new FileInputStream(iFile.getLocation().toFile());
        return Grep.group(fileInputStream, string, iFile.getCharset(), n);
    }

    public static List<CharSequence> group(FileInputStream fileInputStream, String string, String string2, int n) throws IOException {
        Charset charset = Charset.forName(string2);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        Pattern pattern = Pattern.compile(string);
        FileChannel fileChannel = fileInputStream.getChannel();
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(7);
        try {
            int n2 = (int)fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n2);
            CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
            Grep.group(charBuffer, pattern, arrayList, n);
        }
        finally {
            fileChannel.close();
        }
        return arrayList;
    }

    public static List<String> group(String string, String string2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(n));
        }
        return arrayList;
    }
}

