/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.image;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public class ImageFileUtils {
    static final String EDFFORMAT = "edf";
    static final String EDFFORMATGZip = "edf.gz";
    static final String EDFFORMATBz2 = "edf.bz2";
    static final String CORFORMAT = "cor";
    static final String CORFORMATGZip = "cor.gz";
    static final String CORFORMATBz2 = "cor.bz2";
    static final String TIFFORMAT = "tif";
    static final String TIFFORMATGZip = "tif.gz";
    static final String TIFFORMATBz2 = "tif.bz2";
    static final String TIFF_FORMAT = "tiff";
    static final String TIFF_FORMATGZip = "tiff.gz";
    static final String TIFF_FORMATBz2 = "tiff.bz2";
    static final String ADSCFORMAT = "img";
    static final String ADSCFORMATGZip = "img.gz";
    static final String ADSCFORMATBz2 = "img.bz2";
    static final String MCCDFORMAT = "mccd";
    static final String MCCDFORMATGZip = "mccd.gz";
    static final String MCCDFORMATBz2 = "mccd.bz2";
    static final String MAR2300FORMAT = "mccd";
    static final String mar2300FormatGZip = "mccd.gz";
    static final String MAR2300FORMATBz2 = "mccd.bz2";
    static final String PNMFORMAT = "pnm";
    static final String PGMFORMAT = "pgm";
    static final String PBMFORMAT = "pbm";
    static final String BRUKERFORMAT = "\\.\\d{4}$";
    static final String BRUKERFORMATBz2 = "\\.\\d{4}\\.bz2$";
    static final String CCDFORMAT = "ccd";
    static final String UPDATEFILES_EVENT = "updatefiles";
    static String REGEX_FABIO_TYPES = "edf|edf.gz|edf.bz2|cor|cor.gz|cor.bz2|ccd|tif|tif.gz|tif.bz2|tiff|tiff.gz|tiff.bz2|img|img.gz|img.bz2|mccd|mccd.gz|mccd.bz2|mccd|mccd.gz|mccd.bz2|pnm|pgm|pbm|\\.\\d{4}$|\\.\\d{4}\\.bz2$";
    public static String FABIO_TYPES = "edf|edf.gz|edf.bz2|cor|cor.gz|cor.bz2|bruker|bruker.bz2";
    private static final Collection<String> IMAGES;

    static {
        HashSet<String> hashSet = new HashSet<String>(31);
        hashSet.add(TIFFORMAT);
        hashSet.add(TIFFORMATBz2);
        hashSet.add(TIFFORMATGZip);
        hashSet.add(TIFF_FORMAT);
        hashSet.add(TIFF_FORMATBz2);
        hashSet.add(TIFF_FORMATGZip);
        hashSet.add(ADSCFORMAT);
        hashSet.add(ADSCFORMATBz2);
        hashSet.add(ADSCFORMATGZip);
        hashSet.add(EDFFORMAT);
        hashSet.add(EDFFORMATBz2);
        hashSet.add(EDFFORMATGZip);
        hashSet.add(CORFORMAT);
        hashSet.add(CORFORMATBz2);
        hashSet.add(CORFORMATGZip);
        hashSet.add(BRUKERFORMAT);
        hashSet.add(BRUKERFORMATBz2);
        hashSet.add("mccd");
        hashSet.add("mccd.bz2");
        hashSet.add("mccd.gz");
        hashSet.add("mccd");
        hashSet.add("mccd.bz2");
        hashSet.add("mccd.gz");
        hashSet.add(CCDFORMAT);
        hashSet.add(PNMFORMAT);
        hashSet.add(PGMFORMAT);
        hashSet.add(PBMFORMAT);
        hashSet.add("jpg");
        hashSet.add("jpeg");
        hashSet.add("png");
        hashSet.add("gif");
        hashSet.add("cbf");
        hashSet.add("cbf.bz2");
        IMAGES = Collections.unmodifiableCollection(hashSet);
    }

    public static final boolean isImage(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        String string3 = string2 = n < 0 ? string : string.substring(n + 1);
        if (IMAGES.contains(string2.toLowerCase())) {
            return true;
        }
        try {
            n = string.lastIndexOf(46, n - 1);
            string2 = n < 0 ? string : string.substring(n + 1);
            return IMAGES.contains(string2.toLowerCase());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isTiff(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith(TIFFORMAT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(TIFFORMATGZip)) {
            return true;
        }
        if (string.toLowerCase().endsWith(TIFFORMATBz2)) {
            return true;
        }
        if (string.toLowerCase().endsWith(TIFF_FORMAT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(TIFF_FORMATGZip)) {
            return true;
        }
        return string.toLowerCase().endsWith(TIFF_FORMATBz2);
    }

    public static boolean isImg(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith(ADSCFORMAT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(ADSCFORMATGZip)) {
            return true;
        }
        return string.toLowerCase().endsWith(ADSCFORMATBz2);
    }

    public static boolean isEdf(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith(EDFFORMAT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EDFFORMATGZip)) {
            return true;
        }
        return string.toLowerCase().endsWith(EDFFORMATBz2);
    }

    public static boolean isCor(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith(CORFORMAT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(CORFORMATGZip)) {
            return true;
        }
        return string.toLowerCase().endsWith(CORFORMATBz2);
    }

    public static boolean isBruker(String string) {
        if (string == null) {
            return false;
        }
        if (Pattern.compile(".*\\.\\d{4}$").matcher(string).matches()) {
            return true;
        }
        return Pattern.compile(".*\\.\\d{4}\\.bz2$").matcher(string).matches();
    }
}

