/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util.eclipse;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleUtils {
    public static File getBundleLocation(String string) throws IOException {
        Bundle bundle = Platform.getBundle((String)string);
        return BundleUtils.getBundleLocation(bundle);
    }

    public static File getBundleLocation(Bundle bundle) throws IOException {
        String string = BundleUtils.cleanPath(bundle.getLocation());
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        String string2 = BundleUtils.getEclipseHome();
        File file2 = new File(String.valueOf(string2) + "/" + string);
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(String.valueOf(string2) + "/plugins/");
        if (file3.exists()) {
            File[] fileArray = file3.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file4 = fileArray[n];
                if (file4.getName().equals(bundle.getSymbolicName())) {
                    return file4;
                }
                if (file4.getName().startsWith(String.valueOf(bundle.getSymbolicName()) + "_")) {
                    return file4;
                }
                ++n;
            }
        }
        throw new IOException("Cannot locate bundle " + bundle.getSymbolicName());
    }

    private static String cleanPath(String string) {
        if (string.startsWith("reference:file:")) {
            string = string.substring(15);
        } else if (string.startsWith("file:")) {
            string = string.substring(5);
        } else {
            return string;
        }
        string = string.replace("//", "/");
        string = string.replace("\\\\", "\\");
        return string;
    }

    public static File getBundlePathNoLoading(String string) {
        return new File(String.valueOf(BundleUtils.getEclipseHome()) + "/plugins/" + string);
    }

    public static String getEclipseHome() {
        String string = System.getProperty("eclipse.home.location");
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        String string2 = string.endsWith("/plugins/") || string.endsWith("/bundles/") ? new File(string).getParentFile().getParentFile().getAbsolutePath() : string;
        return string2;
    }
}

