/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.digester.substitution.MultiVariableExpander;
import org.apache.commons.digester.substitution.VariableExpander;
import org.apache.commons.digester.substitution.VariableSubstitutor;
import org.dawb.common.util.io.FileUtils;

public class SubstituteUtils {
    public static String substitute(InputStream inputStream, Map<String, String> map) throws Exception {
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray, 0, 4096)) > 0) {
                if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == FileUtils.BOM) {
                    stringBuilder.delete(0, 0);
                }
                stringBuilder.append(cArray, 0, n);
            }
            String string = SubstituteUtils.substitute(stringBuilder.toString(), map);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static final String substitute(String string, Map<String, String> map) {
        if (map == null) {
            return string;
        }
        MultiVariableExpander multiVariableExpander = new MultiVariableExpander();
        multiVariableExpander.addSource("$", map);
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor((VariableExpander)multiVariableExpander);
        return variableSubstitutor.substitute(string);
    }
}

