/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.pages.extractlocal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalRefactoring;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalRequestProcessor;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.pages.core.eclipse.RowLayouter;
import org.python.pydev.refactoring.ui.pages.core.eclipse.TextInputWizardPage;

public class ExtractLocalInputPage
extends TextInputWizardPage {
    public static final String PAGE_NAME = "ExtractLocalInputPage";
    private static final String EXTRACT_LOCAL_REPLACE_DUPLICATES = "EXTRACT_LOCAL_REPLACE_DUPLICATES";
    private Button replaceDuplicates;

    public ExtractLocalInputPage() {
        super(PAGE_NAME, true);
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        Label label = new Label(result, 0);
        label.setText(Messages.extractLocalVariableName);
        Text text = this.createTextInputField(result);
        text.selectAll();
        text.setLayoutData((Object)new GridData(768));
        this.replaceDuplicates = new Button(result, 32);
        ExtractLocalRequestProcessor requestProcessor = this.getRequestProcessor();
        this.replaceDuplicates.setText(StringUtils.format((String)"Also replace &duplicates (%s references)?", (Object[])new Object[]{requestProcessor.getDuplicatesSize()}));
        IPreferenceStore preferences = PydevPrefs.getPreferences();
        boolean replace = preferences.getBoolean(EXTRACT_LOCAL_REPLACE_DUPLICATES);
        this.replaceDuplicates.setSelection(replace);
        requestProcessor.setReplaceDuplicates(replace);
        this.replaceDuplicates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractLocalInputPage.this.getRequestProcessor().setReplaceDuplicates(ExtractLocalInputPage.this.replaceDuplicates.getSelection());
                IPreferenceStore preferences = PydevPrefs.getPreferences();
                preferences.setValue(ExtractLocalInputPage.EXTRACT_LOCAL_REPLACE_DUPLICATES, ExtractLocalInputPage.this.replaceDuplicates.getSelection());
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.replaceDuplicates.setLayoutData((Object)gridData);
        layouter.perform((Control)label, (Control)text, 1);
        Dialog.applyDialogFont((Control)result);
    }

    protected void textModified(String text) {
        this.getRequestProcessor().setVariableName(text);
        super.textModified(text);
    }

    protected RefactoringStatus validateTextField(String text) {
        return this.getExtractlocalRefactoring().checkVarName(text);
    }

    private ExtractLocalRequestProcessor getRequestProcessor() {
        return this.getExtractlocalRefactoring().getRequestProcessor();
    }

    private ExtractLocalRefactoring getExtractlocalRefactoring() {
        return (ExtractLocalRefactoring)this.getRefactoring();
    }
}

