/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.meta.views;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;

public class MetadataTableView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.HeaderView";
    private static final Logger logger = LoggerFactory.getLogger(MetadataTableView.class);
    private IMetaData meta;
    private TableViewer table;
    UIJob updateTable = new UIJob("Updating Metadata Table"){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (MetadataTableView.this.table.getControl().isDisposed()) {
                logger.warn("The header table is disposed, cannot update table");
                return Status.CANCEL_STATUS;
            }
            MetadataTableView.this.table.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object object, Object object2) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object object) {
                    try {
                        Object[] objectArray;
                        Collection collection;
                        Collection collection2 = collection = MetadataTableView.this.meta == null ? null : MetadataTableView.this.meta.getMetaNames();
                        if (collection == null) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = "";
                        } else {
                            objectArray = collection.toArray(new Object[collection.size()]);
                        }
                        return objectArray;
                    }
                    catch (Exception exception) {
                        return new Object[]{""};
                    }
                }
            });
            if (MetadataTableView.this.table.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            MetadataTableView.this.table.setInput((Object)new String());
            return Status.OK_STATUS;
        }
    };

    public void createPartControl(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text text = new Text(composite2, 2944);
        text.setLayoutData((Object)new GridData(768));
        text.setToolTipText("Search on data set name or expression value.");
        this.table = new TableViewer(composite2, 68356);
        this.table.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.getTable().setLinesVisible(true);
        this.table.getTable().setHeaderVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.table, 0, 0);
        tableViewerColumn.getColumn().setText("Key");
        tableViewerColumn.getColumn().setWidth(200);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new HeaderColumnLabelProvider(0));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.table, 0, 1);
        tableViewerColumn2.getColumn().setText("Value");
        tableViewerColumn2.getColumn().setWidth(200);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new HeaderColumnLabelProvider(1));
        this.table.setColumnProperties(new String[]{"Key", "Value"});
        this.table.setUseHashlookup(true);
        final HeaderFilter headerFilter = new HeaderFilter();
        this.table.addFilter((ViewerFilter)headerFilter);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (composite.isDisposed()) {
                    return;
                }
                headerFilter.setSearchText(text.getText());
                MetadataTableView.this.table.refresh();
            }
        });
    }

    public void setFocus() {
        this.table.getControl().setFocus();
    }

    public void setMeta(IMetaData iMetaData) {
        this.meta = iMetaData;
        this.updateTable.schedule();
    }

    private class HeaderColumnLabelProvider
    extends ColumnLabelProvider {
        private int column;

        public HeaderColumnLabelProvider(int n) {
            this.column = n;
        }

        public String getText(Object object) {
            if (this.column == 0) {
                return object.toString();
            }
            if (this.column == 1) {
                try {
                    Serializable serializable = MetadataTableView.this.meta == null ? null : MetadataTableView.this.meta.getMetaValue(object.toString());
                    return serializable == null ? "" : serializable.toString();
                }
                catch (Exception exception) {}
            }
            return "";
        }
    }

    class HeaderFilter
    extends ViewerFilter {
        private String searchString;

        HeaderFilter() {
        }

        public void setSearchText(String string) {
            if (string == null) {
                string = "";
            }
            this.searchString = ".*" + string.toLowerCase() + ".*";
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            String string = (String)object2;
            if (string == null || "".equals(string)) {
                return true;
            }
            if (string.toLowerCase().matches(this.searchString)) {
                return true;
            }
            return string.toLowerCase().matches(this.searchString);
        }
    }
}

