/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.meta.views;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.dawb.common.services.ILoaderService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IMetadataProvider;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.sda.meta.Activator;
import uk.ac.diamond.sda.meta.contribution.MetadataPageContribution;
import uk.ac.diamond.sda.meta.page.IMetadataPage;
import uk.ac.diamond.sda.meta.utils.MapUtils;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class MetadataPageView
extends ViewPart
implements ISelectionListener,
IPartListener {
    public static final String ID = "uk.ac.diamond.sda.meta.MetadataPageView";
    private static final Logger logger = LoggerFactory.getLogger(MetadataPageView.class);
    private IMetaData meta;
    private ArrayList<MetadataPageContribution> pagesRegister = new ArrayList();
    private HashMap<String, IMetadataPage> loadedPages = new HashMap();
    private HashMap<String, Action> actionRegistary = new HashMap();
    private HashMap<String, String> metatdataPageAssociation = new HashMap();
    private String defaultComposite;
    private IToolBarManager toolBarManager;
    private Composite parent;
    private static final String PAGE_EXTENTION_ID = "uk.ac.diamond.sda.meta.metadataPageRegister";

    public MetadataPageView() {
        this.getExtentionPoints();
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.initializePreferences();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
    }

    private void initializePreferences() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.defaultComposite = iPreferenceStore.getString("defaultPage");
        this.metatdataPageAssociation = (HashMap)MapUtils.getMap(iPreferenceStore.getString("defaultMetadataAssociation"));
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty() == "defaultMetadataAssociation") {
                    MetadataPageView.this.metatdataPageAssociation = (HashMap)MapUtils.getMap(propertyChangeEvent.getNewValue().toString());
                }
                if (propertyChangeEvent.getProperty() == "defaultPage") {
                    MetadataPageView.this.defaultComposite = propertyChangeEvent.getProperty().toString();
                }
            }
        });
    }

    private void getExtentionPoints() {
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(PAGE_EXTENTION_ID).getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                this.pagesRegister.add(new MetadataPageContribution(iConfigurationElementArray[n2]));
                ++n2;
            }
            ++n;
        }
    }

    private void metadataChanged(final IMetaData iMetaData) {
        UIJob uIJob = new UIJob("Update for new metadata"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                MetadataPageView.this.toolBarManager.removeAll();
                if (iMetaData == null) {
                    return Status.CANCEL_STATUS;
                }
                for (MetadataPageContribution metadataPageContribution : MetadataPageView.this.pagesRegister) {
                    if (!metadataPageContribution.isApplicableFor(iMetaData)) continue;
                    Action action = MetadataPageView.this.pageActionFactory(metadataPageContribution);
                    MetadataPageView.this.actionRegistary.put(metadataPageContribution.getExtentionPointname(), action);
                    MetadataPageView.this.toolBarManager.add((IAction)action);
                }
                MetadataPageView.this.toolBarManager.update(false);
                MetadataPageView.this.doDefaultBehaviour();
                return Status.OK_STATUS;
            }
        };
        uIJob.schedule();
    }

    private void doDefaultBehaviour() {
        if (this.metatdataPageAssociation != null && this.meta != null && this.metatdataPageAssociation.containsKey(this.meta.getClass().toString())) {
            String string = this.metatdataPageAssociation.get(this.meta.getClass().toString());
            if (this.actionRegistary.containsKey(string)) {
                this.actionRegistary.get(string).run();
            }
        } else if (this.actionRegistary.containsKey(this.defaultComposite)) {
            this.actionRegistary.get(this.defaultComposite).run();
        }
    }

    private Action pageActionFactory(final MetadataPageContribution metadataPageContribution) {
        Action action = new Action(metadataPageContribution.getExtentionPointname()){

            public void run() {
                if (MetadataPageView.this.meta == null) {
                    return;
                }
                try {
                    if (!MetadataPageView.this.loadedPages.containsKey(metadataPageContribution.getExtentionPointname())) {
                        MetadataPageView.this.loadedPages.put(metadataPageContribution.getExtentionPointname(), metadataPageContribution.getPage());
                    }
                }
                catch (CoreException coreException) {
                    logger.warn("Could not create " + metadataPageContribution.getExtentionPointname());
                    return;
                }
                UIJob uIJob = new UIJob("Update Composite"){

                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        Control[] controlArray = MetadataPageView.this.parent.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control control = controlArray[n2];
                            control.dispose();
                            ++n2;
                        }
                        ((IMetadataPage)MetadataPageView.this.loadedPages.get(metadataPageContribution.getExtentionPointname())).createComposite(MetadataPageView.this.parent);
                        ((IMetadataPage)MetadataPageView.this.loadedPages.get(metadataPageContribution.getExtentionPointname())).setMetaData(MetadataPageView.this.meta);
                        MetadataPageView.this.parent.layout();
                        return Status.OK_STATUS;
                    }
                };
                uIJob.schedule();
                MetadataPageView.this.metatdataPageAssociation.put(MetadataPageView.this.meta.getClass().toString(), metadataPageContribution.getExtentionPointname());
                MetadataPageView.this.updateAssociationsMap();
            }
        };
        action.setImageDescriptor(metadataPageContribution.getIcon());
        return action;
    }

    protected void updateAssociationsMap() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("defaultMetadataAssociation", MapUtils.getString(this.metatdataPageAssociation));
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof IMetadataProvider) {
            try {
                this.meta = ((IMetadataProvider)iWorkbenchPart).getMetadata();
                this.metadataChanged(this.meta);
            }
            catch (Exception exception) {
                logger.error("There was a error reading the metadata from the selection", (Throwable)exception);
            }
        } else if (iSelection != null && iSelection instanceof StructuredSelection) {
            Object object = ((StructuredSelection)iSelection).getFirstElement();
            if (object == null) {
                return;
            }
            if (object instanceof IFile) {
                IPath iPath = ((IFile)object).getLocation();
                if (iPath == null) {
                    return;
                }
                this.updatePath(iPath.toOSString());
            } else if (object instanceof File) {
                String string = ((File)object).getAbsolutePath();
                this.updatePath(string);
            } else if (object instanceof IMetadataProvider) {
                try {
                    this.meta = ((IMetadataProvider)object).getMetadata();
                    this.metadataChanged(this.meta);
                }
                catch (Exception exception) {
                    logger.error("Could not capture metadata from selection", (Throwable)exception);
                }
            }
        }
    }

    private void updatePath(final String string) {
        if (string == null) {
            return;
        }
        Job job = new Job("Extra Meta Data " + string){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                ILoaderService iLoaderService = (ILoaderService)PlatformUI.getWorkbench().getService(ILoaderService.class);
                try {
                    MetadataPageView.this.meta = iLoaderService.getMetaData(string, iProgressMonitor);
                }
                catch (Exception exception) {
                    logger.error("Cannot get meta data for " + string, (Throwable)exception);
                    return Status.CANCEL_STATUS;
                }
                MetadataPageView.this.metadataChanged(MetadataPageView.this.meta);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof IMetadataProvider) {
            try {
                this.meta = ((IMetadataProvider)iWorkbenchPart).getMetadata();
                this.metadataChanged(this.meta);
            }
            catch (Exception exception) {
                logger.warn("Could not get metadata from currently active window");
            }
        }
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            String string = EclipseUtils.getFilePath((IEditorInput)iEditorInput);
            this.updatePath(string);
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof IMetadataProvider) {
            try {
                this.meta = ((IMetadataProvider)iWorkbenchPart).getMetadata();
                this.metadataChanged(this.meta);
            }
            catch (Exception exception) {
                logger.warn("Could not get metadata from currently active window");
            }
        }
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
    }

    public void setFocus() {
    }
}

