/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.meta.preferences;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.progress.UIJob;
import uk.ac.diamond.sda.meta.Activator;
import uk.ac.diamond.sda.meta.utils.MapUtils;

public class MetadataAssociationPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List fileAssociations;
    private Text txtFileType;
    private Text txtFileAssociation;
    private Map<String, String> mapOfFileAssociations;
    private String defaultView;
    private Text defaultType;

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.getCurrentSetting();
    }

    private void getCurrentSetting() {
        this.mapOfFileAssociations = MapUtils.getMap(this.getPreferenceStore().getString("defaultMetadataAssociation"));
        this.defaultView = this.getPreferenceStore().getString("defaultPage");
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite2, 0);
        group.setText("Default Metadata Page");
        group.setLayout((Layout)new GridLayout(2, true));
        new Label((Composite)group, 0).setText("The default viewer is ");
        this.defaultType = new Text((Composite)group, 8);
        this.defaultType.setBackground(group.getBackground());
        Group group2 = new Group(composite2, 0);
        group2.setText("File Associations");
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridData = new GridData(1808);
        this.fileAssociations = new List((Composite)group2, 2048);
        this.fileAssociations.setLayoutData((Object)gridData);
        this.fileAssociations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                MetadataAssociationPreferences.this.updateAssociationDetails(MetadataAssociationPreferences.this.fileAssociations.getSelection());
            }
        });
        Group group3 = new Group(composite2, 0);
        group3.setText("Association Details");
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setLayoutData((Object)new GridData(4, 128, true, true));
        new Label((Composite)group3, 0).setText("File: ");
        this.txtFileType = new Text((Composite)group3, 8);
        this.txtFileType.setBackground(group3.getBackground());
        this.txtFileType.setLayoutData((Object)gridData);
        new Label((Composite)group3, 0).setText("Association: ");
        this.txtFileAssociation = new Text((Composite)group3, 0);
        this.txtFileAssociation.setBackground(group3.getBackground());
        this.txtFileAssociation.setLayoutData((Object)gridData);
        this.updateFileAssociationList();
        return composite2;
    }

    protected void updateAssociationDetails(final String[] stringArray) {
        UIJob uIJob = new UIJob("Updata details"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                Map map = MetadataAssociationPreferences.this.mapOfFileAssociations;
                MetadataAssociationPreferences.this.txtFileType.setText(stringArray[0]);
                MetadataAssociationPreferences.this.txtFileAssociation.setText((String)map.get(stringArray[0]));
                return Status.OK_STATUS;
            }
        };
        uIJob.schedule();
    }

    private void updateFileAssociationList() {
        final Set<String> set = this.mapOfFileAssociations.keySet();
        UIJob uIJob = new UIJob("Update the file lists"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                MetadataAssociationPreferences.this.fileAssociations.removeAll();
                for (String string : set) {
                    MetadataAssociationPreferences.this.fileAssociations.add(string);
                }
                MetadataAssociationPreferences.this.defaultType.setText(MetadataAssociationPreferences.this.defaultView);
                return Status.OK_STATUS;
            }
        };
        uIJob.schedule();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.mapOfFileAssociations = MapUtils.getMap(this.getPreferenceStore().getDefaultString("defaultMetadataAssociation"));
        this.defaultView = this.getPreferenceStore().getDefaultString("defaultPage");
        this.updateFileAssociationList();
        this.getPreferenceStore().setValue("defaultMetadataAssociation", MapUtils.getString(this.mapOfFileAssociations));
        this.getPreferenceStore().setValue("defaultPage", this.defaultView);
    }
}

