/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.meta.page;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.io.IDiffractionMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.sda.meta.Activator;
import uk.ac.diamond.sda.meta.page.IMetadataPage;

public class DiffractionMetadataComposite
implements IMetadataPage {
    private Text wavelength;
    private Text phiStart;
    private Text phiStop;
    private Text phiRange;
    private Text distanceToDetector;
    private Text detectorSizeX;
    private Text detectorSizeY;
    private Text PixelSizeX;
    private Text PixelSizeY;
    private Text ExposureTime;
    private Text maxPxVal;
    private Text minPxVal;
    private Text meanPxVal;
    private Text overload;
    private Button showBeam;
    private Text xBeam;
    private Text yBeam;
    private Composite content;

    @Override
    public Composite createComposite(Composite composite) {
        this.content = new Composite(composite, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.content, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite((Composite)scrolledComposite, 4);
        composite2.setLayoutData((Object)new GridData(4, 128, true, true));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group(composite2, 0);
        group.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("Experimental Information");
        Label label = new Label((Composite)group, 0);
        label.setText("Wavelength");
        this.wavelength = new Text((Composite)group, 8);
        this.wavelength.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00c5");
        label = new Label((Composite)group, 0);
        label.setText("Start");
        this.phiStart = new Text((Composite)group, 8);
        this.phiStart.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00b0");
        label = new Label((Composite)group, 0);
        label.setText("Stop");
        this.phiStop = new Text((Composite)group, 8);
        this.phiStop.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00b0");
        label = new Label((Composite)group, 0);
        label.setText("Oscillation Range");
        this.phiRange = new Text((Composite)group, 8);
        this.phiRange.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00b0");
        label = new Group(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 2));
        label.setLayout((Layout)new GridLayout(3, false));
        label.setText("Detector Metadata");
        Label label2 = new Label((Composite)label, 0);
        label2.setText("Distance");
        this.distanceToDetector = new Text((Composite)label, 8);
        this.distanceToDetector.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Size (x)");
        this.detectorSizeX = new Text((Composite)label, 8);
        this.detectorSizeX.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Size (y)");
        this.detectorSizeY = new Text((Composite)label, 8);
        this.detectorSizeY.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Pixel Size (x)");
        this.PixelSizeX = new Text((Composite)label, 8);
        this.PixelSizeX.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Pixel Size (y)");
        this.PixelSizeY = new Text((Composite)label, 8);
        this.PixelSizeY.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Exposure Time");
        this.ExposureTime = new Text((Composite)label, 8);
        this.ExposureTime.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("s");
        label2 = new Label((Composite)label, 0);
        label2.setText("Maximum Value");
        label2.setToolTipText("Maximum pixel value of the dataset being plotted.");
        this.maxPxVal = new Text((Composite)label, 8);
        this.maxPxVal.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("");
        label2 = new Label((Composite)label, 0);
        label2.setText("Minimum Value");
        label2.setToolTipText("Minimum pixel value of the dataset being plotted.");
        this.minPxVal = new Text((Composite)label, 8);
        this.minPxVal.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("");
        label2 = new Label((Composite)label, 0);
        label2.setText("Mean Value");
        label2.setToolTipText("Mean pixel value of the dataset being plotted.");
        this.meanPxVal = new Text((Composite)label, 8);
        this.meanPxVal.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("");
        label2 = new Label((Composite)label, 0);
        label2.setText("Overload Value");
        label2.setToolTipText("Displays the maximum possible pixel value");
        this.overload = new Text((Composite)label, 8);
        this.overload.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("");
        label2 = new Group(composite2, 0);
        label2.setLayout((Layout)new GridLayout(2, false));
        label2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        label2.setText("Beam Centre");
        Composite composite3 = new Composite((Composite)label2, 0);
        composite3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        composite3.setLayout((Layout)new GridLayout(3, false));
        new Label(composite3, 0).setText("");
        Button button = new Button(composite3, 0);
        button.setImage(Activator.getImageDescriptor("/icons/arrow_up.png").createImage());
        button.setEnabled(false);
        new Label(composite3, 0).setText("");
        button = new Button(composite3, 0);
        button.setImage(Activator.getImageDescriptor("/icons/arrow_left.png").createImage());
        button.setEnabled(false);
        this.showBeam = new Button(composite3, 2);
        this.showBeam.setToolTipText("Show beam centre");
        this.showBeam.setImage(Activator.getImageDescriptor("icons/asterisk_yellow.png").createImage());
        this.showBeam.setEnabled(false);
        button = new Button(composite3, 0);
        button.setImage(Activator.getImageDescriptor("/icons/arrow_right.png").createImage());
        button.setEnabled(false);
        new Label(composite3, 0).setText("");
        button = new Button(composite3, 0);
        button.setImage(Activator.getImageDescriptor("/icons/arrow_down.png").createImage());
        button.setEnabled(false);
        new Label(composite3, 0).setText("");
        button = new Composite((Composite)label2, 4);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        button.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label((Composite)button, 0);
        label3.setText("Beam X");
        this.xBeam = new Text((Composite)button, 8);
        this.xBeam.setBackground(label2.getBackground());
        Label label4 = new Label((Composite)button, 0);
        label4.setText("Beam Y");
        this.yBeam = new Text((Composite)button, 8);
        this.yBeam.setBackground(label2.getBackground());
        scrolledComposite.setContent((Control)composite2);
        label2 = composite2.computeSize(-1, -1);
        composite2.setSize((Point)label2);
        return this.content;
    }

    private void updateGUI(final IDiffractionMetadata iDiffractionMetadata) {
        UIJob uIJob = new UIJob("Updating metadata GUI"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                DetectorProperties detectorProperties = iDiffractionMetadata.getDetector2DProperties();
                DiffractionCrystalEnvironment diffractionCrystalEnvironment = iDiffractionMetadata.getDiffractionCrystalEnvironment();
                DiffractionMetadataComposite.this.wavelength.setText(String.valueOf(diffractionCrystalEnvironment.getWavelength()));
                DiffractionMetadataComposite.this.phiStart.setText(String.valueOf(diffractionCrystalEnvironment.getPhiStart()));
                DiffractionMetadataComposite.this.phiStop.setText(String.valueOf(diffractionCrystalEnvironment.getPhiStart() + diffractionCrystalEnvironment.getPhiRange()));
                DiffractionMetadataComposite.this.phiRange.setText(String.valueOf(diffractionCrystalEnvironment.getPhiRange()));
                DiffractionMetadataComposite.this.distanceToDetector.setText(String.valueOf(detectorProperties.getOrigin().z));
                DiffractionMetadataComposite.this.detectorSizeX.setText(String.valueOf(detectorProperties.getDetectorSizeH()));
                DiffractionMetadataComposite.this.detectorSizeY.setText(String.valueOf(detectorProperties.getDetectorSizeV()));
                DiffractionMetadataComposite.this.PixelSizeX.setText(String.valueOf(detectorProperties.getHPxSize()));
                DiffractionMetadataComposite.this.PixelSizeY.setText(String.valueOf(detectorProperties.getVPxSize()));
                DiffractionMetadataComposite.this.ExposureTime.setText(String.valueOf(diffractionCrystalEnvironment.getExposureTime()));
                DiffractionMetadataComposite.this.maxPxVal.setText("N/A");
                DiffractionMetadataComposite.this.minPxVal.setText(String.valueOf("N/A"));
                DiffractionMetadataComposite.this.meanPxVal.setText(String.valueOf("N/A"));
                DiffractionMetadataComposite.this.overload.setText(String.valueOf("N/A"));
                int[] nArray = detectorProperties.pixelCoords(detectorProperties.getBeamPosition());
                DiffractionMetadataComposite.this.xBeam.setText(String.valueOf((double)nArray[0] * detectorProperties.getHPxSize()));
                DiffractionMetadataComposite.this.yBeam.setText(String.valueOf((double)nArray[1] * detectorProperties.getVPxSize()));
                return Status.OK_STATUS;
            }
        };
        uIJob.schedule();
    }

    private void clearGUI() {
        UIJob uIJob = new UIJob("Updating metadata GUI"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                DiffractionMetadataComposite.this.wavelength.setText("");
                DiffractionMetadataComposite.this.phiStart.setText("");
                DiffractionMetadataComposite.this.phiStop.setText("");
                DiffractionMetadataComposite.this.phiRange.setText("");
                DiffractionMetadataComposite.this.distanceToDetector.setText("");
                DiffractionMetadataComposite.this.detectorSizeX.setText("");
                DiffractionMetadataComposite.this.detectorSizeY.setText("");
                DiffractionMetadataComposite.this.PixelSizeX.setText("");
                DiffractionMetadataComposite.this.PixelSizeY.setText("");
                DiffractionMetadataComposite.this.ExposureTime.setText("");
                DiffractionMetadataComposite.this.maxPxVal.setText("");
                DiffractionMetadataComposite.this.minPxVal.setText(String.valueOf(""));
                DiffractionMetadataComposite.this.meanPxVal.setText(String.valueOf(""));
                DiffractionMetadataComposite.this.overload.setText(String.valueOf(""));
                DiffractionMetadataComposite.this.xBeam.setText(String.valueOf(""));
                DiffractionMetadataComposite.this.yBeam.setText(String.valueOf(""));
                return Status.OK_STATUS;
            }
        };
        uIJob.schedule();
    }

    @Override
    public void setMetaData(IMetaData iMetaData) {
        if (iMetaData instanceof IDiffractionMetadata) {
            this.updateGUI((IDiffractionMetadata)iMetaData);
        }
        if (iMetaData == null) {
            this.clearGUI();
        }
    }
}

