/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.meta.contribution;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.sda.meta.discriminator.IMetadataDiscriminator;
import uk.ac.diamond.sda.meta.page.IMetadataPage;

public class MetadataPageContribution {
    private static final Logger logger = LoggerFactory.getLogger(MetadataPageContribution.class);
    public static final String CLASS_NAME = "class";
    public static final String NAME = "name";
    public static final String SUPPORTED_METADATA = "supportedMetadata";
    public static final String ICON = "icon";
    private String extentionPointname;
    private ImageDescriptor icon;
    private final IConfigurationElement configurationElement;
    private IMetadataDiscriminator discriminator;

    public MetadataPageContribution(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
        IContributor iContributor = this.configurationElement.getContributor();
        String string = iContributor instanceof RegistryContributor ? ((RegistryContributor)iContributor).getActualName() : iContributor.getName();
        URL uRL = FileLocator.find((Bundle)Platform.getBundle((String)string), (IPath)new Path(this.configurationElement.getAttribute(ICON)), null);
        this.icon = ImageDescriptor.createFromURL((URL)uRL);
        this.extentionPointname = iConfigurationElement.getAttribute(NAME);
        try {
            this.discriminator = (IMetadataDiscriminator)iConfigurationElement.createExecutableExtension(SUPPORTED_METADATA);
        }
        catch (CoreException coreException) {
            logger.warn("Could not load the discriminator for different metadata types");
        }
    }

    public IMetadataPage getPage() throws CoreException {
        return (IMetadataPage)this.configurationElement.createExecutableExtension(CLASS_NAME);
    }

    public String getExtentionPointname() {
        return this.extentionPointname;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public boolean isApplicableFor(IMetaData iMetaData) {
        if (this.discriminator == null) {
            return false;
        }
        return this.discriminator.isApplicableFor(iMetaData);
    }
}

