/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.u3d.u3dencoding;

import de.jreality.writer.u3d.u3dencoding.Constants;
import de.jreality.writer.u3d.u3dencoding.ContextManager;
import de.jreality.writer.u3d.u3dencoding.DataBlock;
import java.awt.Color;
import java.io.UnsupportedEncodingException;

public class BitStreamWrite {
    private ContextManager contextManager = new ContextManager();
    private long high = 65535L;
    private long low;
    private long underflow;
    private boolean compressed = false;
    private long[] data = new long[9208];
    private int dataPosition;
    private long dataLocal;
    private long dataLocalNext;
    private int dataBitOffset;
    private final int DataSizeIncrement = 9208;

    public void WriteString(String s) {
        this.WriteU16((short)s.length());
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < bytes.length; ++i) {
            this.WriteU8(bytes[i]);
        }
    }

    public void WriteColor(Color c) {
        this.WriteF32((float)c.getRed() / 255.0f);
        this.WriteF32((float)c.getGreen() / 255.0f);
        this.WriteF32((float)c.getBlue() / 255.0f);
    }

    public void WriteU8(short uValue) {
        long symbol = this.SwapBits8(uValue);
        this.WriteSymbol(0L, symbol);
    }

    public void WriteU16(int uValue) {
        this.WriteU8((short)(0xFF & uValue));
        this.WriteU8((short)(0xFF & uValue >> 8));
    }

    public void WriteU32(long uValue) {
        this.WriteU16((int)(0xFFFFL & uValue));
        this.WriteU16((int)(0xFFFFL & uValue >> 16));
    }

    public void WriteU64(long uValue) {
        this.WriteU32(0xFFFFFFFFFFFFFFFFL & uValue);
        this.WriteU32(0xFFFFFFFFFFFFFFFFL & uValue >> 32);
    }

    public void WriteI32(int iValue) {
        this.WriteU32(iValue);
    }

    public void WriteI16(short iValue) {
        this.WriteU16(iValue);
    }

    public void WriteF32(float fValue) {
        this.WriteU32(Float.floatToRawIntBits(fValue));
    }

    public void WriteCompressedU32(long context, long uValue) {
        this.compressed = true;
        boolean escape = false;
        if (context != 0L && context < 17407L) {
            escape = this.WriteSymbol(context, uValue);
            if (escape) {
                this.WriteU32(uValue);
                this.contextManager.AddSymbol(context, uValue + 1L);
            }
        } else {
            this.WriteU32(uValue);
        }
    }

    public void WriteCompressedU16(long context, int uValue) {
        this.compressed = true;
        boolean escape = false;
        if (context != 0L && context < 17407L) {
            escape = this.WriteSymbol(context, uValue);
            if (escape) {
                this.WriteU16(uValue);
                this.contextManager.AddSymbol(context, uValue + 1);
            }
        } else {
            this.WriteU16(uValue);
        }
    }

    public void WriteCompressedU8(long context, short uValue) {
        this.compressed = true;
        boolean escape = false;
        if (context != 0L && context < 17407L) {
            escape = this.WriteSymbol(context, uValue);
            if (escape) {
                this.WriteU8(uValue);
                this.contextManager.AddSymbol(context, uValue + 1);
            }
        } else {
            this.WriteU8(uValue);
        }
    }

    public void WriteDataBlock(DataBlock b) {
        int i;
        int dataSize = (int)Math.ceil((double)b.getDataSize() / 4.0);
        int metaDataSize = (int)Math.ceil((double)b.getMetaDataSize() / 4.0);
        this.WriteU32(b.getBlockType());
        this.WriteU32(b.getDataSize());
        this.WriteU32(b.getMetaDataSize());
        for (i = 0; i < dataSize; ++i) {
            this.WriteU32(b.getData()[i]);
        }
        for (i = 0; i < metaDataSize; ++i) {
            this.WriteU32(b.getMetaData()[i]);
        }
    }

    public DataBlock GetDataBlock() {
        if (this.compressed) {
            this.WriteU32(0L);
        }
        this.AlignToByte();
        long numBytes = ((long)this.dataPosition << 2) + ((long)this.dataBitOffset >> 3);
        DataBlock rDataBlock = new DataBlock();
        this.PutLocal();
        rDataBlock.setDataSize(numBytes);
        long[] tempData = rDataBlock.getData();
        System.arraycopy(this.data, 0, tempData, 0, tempData.length);
        rDataBlock.setData(tempData);
        return rDataBlock;
    }

    public void AlignToByte() {
        int uBitCount = this.GetBitCount();
        uBitCount = 8 - (uBitCount & 7) & 7;
        this.dataBitOffset += uBitCount;
        if (this.dataBitOffset >= 32) {
            this.dataBitOffset -= 32;
            this.IncrementPosition();
        }
    }

    public void AlignTo4Byte() {
        if (this.dataBitOffset > 0) {
            this.dataBitOffset = 0;
            this.IncrementPosition();
        }
    }

    private boolean WriteSymbol(long context, long symbol) {
        ++symbol;
        boolean rEscape = false;
        long totalCumFreq = 0L;
        long symbolCumFreq = 0L;
        long symbolFreq = 0L;
        totalCumFreq = this.contextManager.GetTotalSymbolFrequency(context);
        symbolCumFreq = this.contextManager.GetCumulativeSymbolFrequency(context, symbol);
        symbolFreq = this.contextManager.GetSymbolFrequency(context, symbol);
        if (0L == symbolFreq) {
            symbol = 0L;
            symbolCumFreq = this.contextManager.GetCumulativeSymbolFrequency(context, symbol);
            symbolFreq = this.contextManager.GetSymbolFrequency(context, symbol);
        }
        if (0L == symbol) {
            rEscape = true;
        }
        long range = this.high + 1L - this.low;
        this.high = this.low - 1L + range * (symbolCumFreq + symbolFreq) / totalCumFreq;
        this.low += range * symbolCumFreq / totalCumFreq;
        this.contextManager.AddSymbol(context, symbol);
        long bit = this.low >> 15;
        while ((this.high & 0x8000L) == (this.low & 0x8000L)) {
            this.high &= 0xFFFFFFFFFFFF7FFFL;
            this.high += this.high + 1L;
            this.WriteBit(bit);
            while (this.underflow > 0L) {
                --this.underflow;
                this.WriteBit((bit ^ 0xFFFFFFFFFFFFFFFFL) & 1L);
            }
            this.low &= 0xFFFFFFFFFFFF7FFFL;
            this.low += this.low;
            bit = this.low >> 15;
        }
        while (0L == (this.high & 0x4000L) && 16384L == (this.low & 0x4000L)) {
            this.high &= 0xFFFFFFFFFFFF7FFFL;
            this.high <<= 1;
            this.low <<= 1;
            this.high |= 0x8000L;
            this.high |= 1L;
            this.low &= 0xFFFFFFFFFFFF7FFFL;
            ++this.underflow;
        }
        return rEscape;
    }

    private long SwapBits8(long rValue) {
        return Constants.Swap8[(int)(rValue & 0xFL)] << 4 | Constants.Swap8[(int)(rValue >> 4)];
    }

    private void WriteBit(long bit) {
        long mask = 1L;
        this.dataLocal &= mask << this.dataBitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        this.dataLocal |= (bit &= mask) << this.dataBitOffset;
        ++this.dataBitOffset;
        if (this.dataBitOffset >= 32) {
            this.dataBitOffset -= 32;
            this.IncrementPosition();
        }
    }

    private void IncrementPosition() {
        ++this.dataPosition;
        this.CheckPosition();
        this.data[this.dataPosition - 1] = this.dataLocal;
        this.dataLocal = this.dataLocalNext;
        this.dataLocalNext = this.data[this.dataPosition + 1];
    }

    private void PutLocal() {
        this.data[this.dataPosition] = this.dataLocal;
        this.data[this.dataPosition + 1] = this.dataLocalNext;
    }

    private void CheckPosition() {
        if (this.dataPosition + 2 > this.data.length) {
            this.AllocateDataBuffer(this.dataPosition + 2 + 9208);
        }
    }

    private void AllocateDataBuffer(int size) {
        if (null != this.data) {
            long[] oldData = this.data;
            this.data = new long[size];
            for (int i = 0; i < oldData.length; ++i) {
                this.data[i] = oldData[i];
            }
        } else {
            this.data = new long[size];
        }
    }

    int GetBitCount() {
        return (this.dataPosition << 5) + this.dataBitOffset;
    }
}

