/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.u3d.texture;

import de.jreality.backends.texture.EnvironmentTexture;
import de.jreality.shader.CubeMap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class SphereMapGenerator {
    public static int i = 0;

    public static BufferedImage create(CubeMap map, int width, int height) {
        BufferedImage r = new BufferedImage(width, height, 2);
        EnvironmentTexture tex = new EnvironmentTexture(map, null, Color.WHITE);
        WritableRaster raster = r.getRaster();
        for (double y = 0.0; y < (double)height; y += 1.0) {
            double v = Math.PI * y / (double)height;
            double ry = Math.cos(v);
            double sinV = Math.sin(v);
            for (double x = 0.0; x < (double)width; x += 1.0) {
                double u = Math.PI * 2 * x / (double)width - 1.5707963267948966;
                double rx = Math.cos(u) * sinV;
                double rz = Math.sin(u) * sinV;
                double[] ray = new double[]{rx, ry, rz};
                double[] color = new double[4];
                tex.getColor(0.0, 0.0, ray[0], ray[1], ray[2], 0, 0, color);
                double[] iColor = new double[]{color[0], color[1], color[2], 255.0};
                raster.setPixel((int)x, (int)y, iColor);
            }
        }
        return r;
    }
}

