/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.u3d;

import de.jreality.shader.CubeMap;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.writer.u3d.texture.SphereMapGenerator;
import java.util.Arrays;

public class U3DTexture {
    private ImageData[] image = null;
    private CubeMap cm = null;
    private ImageData imageData = null;

    public U3DTexture(Texture2D tex) {
        this.image = new ImageData[]{tex.getImage()};
    }

    public U3DTexture(ImageData image) {
        this.image = new ImageData[]{image};
    }

    public U3DTexture(CubeMap cm) {
        this.image = new ImageData[]{cm.getLeft(), cm.getRight(), cm.getFront(), cm.getBack(), cm.getTop(), cm.getBottom()};
        this.cm = cm;
    }

    public ImageData getImage() {
        if (this.imageData == null) {
            this.imageData = this.image.length == 1 ? this.image[0] : new ImageData(SphereMapGenerator.create(this.cm, 768, 768));
        }
        return this.imageData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.image);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        U3DTexture other = (U3DTexture)obj;
        return Arrays.equals(this.image, other.image);
    }
}

