/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer;

import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.util.ImageUtility;
import de.jreality.writer.VRMLWriterHelper;
import de.jreality.writer.WriterVRML;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.WeakHashMap;

public class WriterVRML2 {
    private boolean useDefs = true;
    private boolean drawTubes = false;
    private boolean drawSpheres = false;
    private boolean moveLightsToSceneRoot = true;
    private boolean writeTextureFiles = false;
    private boolean flipTextureUpsideDown = true;
    private boolean evaluateTextureMatrix = true;
    private boolean writeTextureCoordIndices = true;
    private VRMLWriterHelper wHelp = new VRMLWriterHelper();
    private DefaultGeometryShader dgs;
    private DefaultPolygonShader dps;
    private DefaultLineShader dls;
    private DefaultPointShader dvs;
    private DefaultTextShader dpts;
    private DefaultTextShader dlts;
    private DefaultTextShader dvts;
    private DefaultPolygonShader dlps;
    private DefaultPolygonShader dvps;
    private String fileStem = String.format("texture-%10d-", System.currentTimeMillis());
    private PrintWriter out = null;
    private static final String spacing = "  ";
    private static String hist = "";
    private Color amb;
    private Color spec;
    private Color diff;
    private double tra;
    String writePath = "";
    WeakHashMap<ImageData, String> textureMaps = new WeakHashMap();
    int textureCount = 0;

    public WriterVRML2(OutputStream outS) {
        this.out = new PrintWriter(outS);
    }

    public WriterVRML2(FileWriter outS) {
        this.out = new PrintWriter(outS);
    }

    public WriterVRML2(PrintWriter outS) {
        this.out = outS;
    }

    public static void write(SceneGraphComponent sceneRoot, FileOutputStream stream) {
        WriterVRML writer = new WriterVRML(stream);
        writer.write(sceneRoot);
    }

    public void setWritePath(String path) {
        this.writePath = path;
        if (!this.writePath.endsWith("/")) {
            this.writePath = this.writePath + "/";
        }
    }

    public void write(SceneGraphNode sgn) {
        this.out.println("#VRML V2.0 utf8");
        if (this.useDefs) {
            this.wHelp.inspect(sgn);
        }
        if (this.moveLightsToSceneRoot) {
            this.out.println("" + hist + "Group { # collected lights and sceneRoot");
            String oldhist = hist;
            hist = hist + spacing;
            this.out.println(hist + "children [");
            hist = hist + spacing;
            sgn.accept(new MyLightVisitor());
            sgn.accept(new MyVisitor());
            hist = oldhist;
            this.out.println("" + hist + spacing + "]");
            this.out.println("" + hist + "}");
        } else {
            sgn.accept(new MyVisitor());
        }
        this.out.flush();
    }

    private void updateShaders(EffectiveAppearance eap) {
        this.dgs = ShaderUtility.createDefaultGeometryShader(eap);
        if (this.dgs.getPointShader() instanceof DefaultPointShader) {
            this.dvs = (DefaultPointShader)this.dgs.getPointShader();
            this.dvts = this.dvs.getTextShader() instanceof DefaultTextShader ? (DefaultTextShader)this.dvs.getTextShader() : null;
            this.dvps = this.dvs.getPolygonShader() instanceof DefaultPolygonShader ? (DefaultPolygonShader)this.dvs.getPolygonShader() : null;
        } else {
            this.dvs = null;
        }
        if (this.dgs.getLineShader() instanceof DefaultLineShader) {
            this.dls = (DefaultLineShader)this.dgs.getLineShader();
            this.dlts = this.dls.getTextShader() instanceof DefaultTextShader ? (DefaultTextShader)this.dls.getTextShader() : null;
            this.dlps = this.dls.getPolygonShader() instanceof DefaultPolygonShader ? (DefaultPolygonShader)this.dls.getPolygonShader() : null;
        } else {
            this.dls = null;
        }
        if (this.dgs.getPolygonShader() instanceof DefaultPolygonShader) {
            this.dps = (DefaultPolygonShader)this.dgs.getPolygonShader();
            this.dpts = this.dps.getTextShader() instanceof DefaultTextShader ? (DefaultTextShader)this.dps.getTextShader() : null;
        } else {
            this.dps = null;
        }
    }

    private void writeCoords(double[][] coords, String hist) {
        this.out.println(hist + "Coordinate { point [");
        String hist2 = hist + spacing;
        double[][] coords3 = coords;
        if (coords[0].length == 4) {
            coords3 = Pn.dehomogenize((double[][])null, coords3);
        }
        for (int i = 0; i < coords.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(coords3[i], hist2, ",", 3, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeColors(double[][] colors, String hist) {
        this.out.println(hist + "Color { color [");
        String hist2 = hist + spacing;
        for (int i = 0; i < colors.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(colors[i], hist2, ",", 3, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeNormals(double[][] normals, String hist) {
        this.out.println(hist + "Normal { vector [");
        String hist2 = hist + spacing;
        for (int i = 0; i < normals.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(normals[i], hist2, ",", 3, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeIndices(int[][] in, String hist) {
        this.out.println(hist + "coordIndex [");
        for (int i = 0; i < in.length; ++i) {
            int le = in[i].length;
            this.out.print(hist + spacing);
            for (int j = 0; j < le; ++j) {
                this.out.print("" + in[i][j] + ", ");
            }
            this.out.println(" -1, ");
        }
        this.out.println(hist + "]");
    }

    private void writeTexture(Texture2D tex) {
        int[] channels = new int[]{1, 2, 3, 0};
        try {
            Matrix mat = tex.getTextureMatrix();
            if (mat == null) {
                throw new IOException("missing texture component");
            }
            ImageData id = tex.getImage();
            if (id == null) {
                throw new IOException("missing texture component");
            }
            String hist2 = hist + spacing;
            if (this.writeTextureFiles) {
                String fileName = this.textureMaps.get(tex.getImage());
                if (fileName == null) {
                    fileName = this.fileStem + String.format("%04d", this.textureCount) + ".png";
                    String fullName = this.writePath + fileName;
                    ++this.textureCount;
                    BufferedImage image = (BufferedImage)tex.getImage().getImage();
                    image = ImageUtility.getValidBufferedImage(tex.getImage());
                    ImageUtility.writeBufferedImage(new File(fullName), image);
                    this.textureMaps.put(tex.getImage(), fileName);
                }
                this.out.println(hist + "ImageTexture { ");
                this.out.println(hist2 + "url " + "\"" + fileName + "\" ");
                this.writeTextureRepeat(hist, tex);
                this.out.println(hist + "}");
            } else {
                this.out.println(hist + "PixelTexture { ");
                VRMLWriterHelper.writeImage(tex, hist2, this.out);
                this.writeTextureRepeat(hist2, tex);
                this.out.println(hist + "}");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeTextureRepeat(String hist, Texture2D tex) {
        this.out.print(hist + "repeatS ");
        if (tex.getRepeatS() == 10497) {
            this.out.println("TRUE");
        } else {
            this.out.println("FALSE");
        }
        this.out.print(hist + "repeatT ");
        if (tex.getRepeatT() == 10497) {
            this.out.println("TRUE");
        } else {
            this.out.println("FALSE");
        }
    }

    private void writeTexCoords(double[][] texCoords, String hist) {
        Texture2D tex;
        if (this.evaluateTextureMatrix && (tex = this.dps.getTexture2d()) != null && tex instanceof Texture2D) {
            int i;
            Matrix mat = new Matrix(tex.getTextureMatrix().getArray());
            if (this.flipTextureUpsideDown) {
                Matrix flip = MatrixBuilder.euclidean().translate(0.0, 1.0, 0.0).scale(1.0, -1.0, 1.0).getMatrix();
                mat.multiplyOnLeft(flip);
            }
            int dim = texCoords[0].length;
            for (i = 0; i < texCoords.length; ++i) {
                if (dim == 2) {
                    texCoords[i] = new double[]{texCoords[i][0], texCoords[i][1], 0.0, 1.0};
                }
                if (dim != 3) continue;
                texCoords[i] = new double[]{texCoords[i][0], texCoords[i][1], texCoords[i][2], 1.0};
            }
            Rn.matrixTimesVector(texCoords, mat.getArray(), texCoords);
            Pn.dehomogenize(texCoords, texCoords);
            for (i = 0; i < texCoords.length; ++i) {
                texCoords[i] = new double[]{texCoords[i][0], texCoords[i][1]};
            }
        }
        String hist2 = hist + spacing;
        this.out.println(hist + "TextureCoordinate { point [");
        for (int i = 0; i < texCoords.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(texCoords[i], hist2, ",", 2, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeMaterial(GeoTyp typ) {
        String histold = hist;
        hist = hist + spacing;
        this.out.println(hist + "Material { ");
        hist = hist + spacing;
        switch (typ) {
            case TEX_FACE: 
            case FACE: 
            case SPHERE: 
            case TUBE: {
                if (this.spec != null) {
                    this.out.println(hist + "specularColor " + VRMLWriterHelper.ColorToString(this.spec));
                }
                if (this.tra != 0.0) {
                    this.out.println(hist + "transparency " + this.tra);
                }
                if (this.diff == null) break;
                this.out.println(hist + "diffuseColor " + VRMLWriterHelper.ColorToString(this.diff));
                break;
            }
            case LINE: 
            case POINT: {
                if (this.diff == null) break;
                this.out.println(hist + "emissiveColor " + VRMLWriterHelper.ColorToString(this.diff));
            }
        }
        hist = histold;
        this.out.println(hist + spacing + "}");
    }

    private void writeTextureTransform(Texture2D tex, GeoTyp typ) {
        String hist2 = hist + spacing;
        Matrix mat = new Matrix(tex.getTextureMatrix().getArray());
        if (this.flipTextureUpsideDown) {
            Matrix flip = MatrixBuilder.euclidean().translate(0.0, 1.0, 0.0).scale(1.0, -1.0, 1.0).getMatrix();
            mat.multiplyOnRight(flip);
        }
        FactoredMatrix matrix = new FactoredMatrix(mat.getArray());
        double[] trans = matrix.getTranslation();
        double ang = matrix.getRotationAngle();
        double[] rotA = matrix.getRotationAxis();
        double[] scale = matrix.getStretch();
        if (ang > 0.0 && rotA[2] < 0.0) {
            ang = -ang;
        }
        this.out.println(hist + "TextureTransform {");
        this.out.println(hist2 + "center 0 0");
        this.out.println(hist2 + "rotation  " + ang);
        this.out.println(hist2 + "scale " + scale[0] + " " + scale[1]);
        this.out.println(hist2 + "translation  " + trans[0] / trans[3] + " " + trans[1] / trans[3]);
        this.out.println(hist + "}");
    }

    private void writeApp(GeoTyp typ) {
        String histOld = hist;
        String hist2 = hist + spacing;
        String hist3 = hist2 + spacing;
        this.out.println(hist + "Appearance { ");
        hist = hist2;
        this.out.println(hist + "material ");
        hist = hist3;
        this.writeMaterial(typ);
        hist = hist2;
        this.out.println(hist + "texture ");
        hist = hist3;
        Texture2D tex = this.dps.getTexture2d();
        if (tex != null && typ == GeoTyp.TEX_FACE) {
            this.writeTexture(tex);
            hist = hist2;
            this.out.println(hist + "textureTransform ");
            hist = hist3;
            if (!this.evaluateTextureMatrix) {
                this.writeTextureTransform(tex, typ);
            }
        }
        hist = histOld;
        this.out.println(hist + "} ");
    }

    private boolean tryWriteShapeNode(GeoTyp typ, double[] forcedDiffuseColor) {
        switch (typ) {
            case TEX_FACE: 
            case FACE: {
                this.amb = this.dps.getAmbientColor();
                this.spec = this.dps.getSpecularColor();
                this.diff = this.dps.getDiffuseColor();
                this.tra = this.dps.getTransparency();
                if (this.tra != 0.0 || this.diff != null || forcedDiffuseColor != null || this.spec != null || this.amb != null) break;
                return false;
            }
            case TUBE: {
                this.amb = this.dlps.getAmbientColor();
                this.spec = this.dlps.getSpecularColor();
                this.diff = this.dlps.getDiffuseColor();
                this.tra = this.dlps.getTransparency();
                if (this.tra != 0.0 || this.diff != null || forcedDiffuseColor != null || this.spec != null || this.amb != null) break;
                return false;
            }
            case LINE: {
                this.diff = this.dls.getDiffuseColor();
                if (this.diff != null) break;
                return false;
            }
            case SPHERE: {
                this.amb = this.dvps.getAmbientColor();
                this.spec = this.dvps.getSpecularColor();
                this.diff = this.dvps.getDiffuseColor();
                this.tra = this.dvps.getTransparency();
                if (this.tra != 0.0 || this.diff != null || forcedDiffuseColor != null || this.spec != null || this.amb != null) break;
                return false;
            }
            case POINT: {
                this.diff = this.dvs.getDiffuseColor();
                if (this.diff != null) break;
                return false;
            }
        }
        if (forcedDiffuseColor != null) {
            this.diff = VRMLWriterHelper.DoublesToColor(forcedDiffuseColor);
        }
        this.writeShapeNode(typ);
        return true;
    }

    private void closeShapeNode(String oldHist) {
        hist = oldHist;
        this.out.println(hist + "}");
    }

    private void writeShapeNode(GeoTyp typ) {
        String hist2 = hist + spacing;
        String hist3 = hist2 + spacing;
        this.out.println(hist + "Shape { ");
        hist = hist2;
        this.out.println(hist + "appearance ");
        hist = hist3;
        this.writeApp(typ);
        hist = hist2;
        this.out.println(hist + "geometry ");
        hist = hist3;
    }

    private void writeTrafo(Transformation trafo) {
        FactoredMatrix fm = new FactoredMatrix(trafo.getMatrix());
        fm.update();
        double[] cen = fm.getCenter();
        if (cen != null) {
            this.out.println(hist + spacing + "center ");
            VRMLWriterHelper.writeDoubleArray(cen, hist, "", 3, this.out);
        }
        this.out.println(hist + spacing + "rotation ");
        VRMLWriterHelper.writeDoubleArray(fm.getRotationAxis(), hist, spacing + fm.getRotationAngle(), 3, this.out);
        this.out.println(hist + spacing + "scale ");
        VRMLWriterHelper.writeDoubleArray(fm.getStretch(), hist, "", 3, this.out);
        this.out.println(hist + spacing + "translation ");
        VRMLWriterHelper.writeDoubleArray(fm.getTranslation(), hist, "", 3, this.out);
    }

    private void writeDirLight(DirectionalLight l, String hist, PrintWriter out, double[] dir) {
        double di = l.getIntensity();
        double[] dc = VRMLWriterHelper.colorToDoubleArray(l.getColor());
        out.println(hist + "DirectionalLight { # " + l.getName());
        String oldHist = hist;
        hist = hist + spacing;
        out.println(hist + "intensity " + di);
        out.print(hist + "color ");
        VRMLWriterHelper.writeDoubleArray(dc, "", "", 3, out);
        if (dir == null) {
            out.println(hist + "direction  0 0 1");
        } else {
            out.print(hist + "direction ");
            VRMLWriterHelper.writeDoubleArray(dir, "", "", 3, out);
        }
        hist = oldHist;
        out.println(hist + "}");
    }

    private void writePointLight(PointLight l, String hist, PrintWriter out, double[] location) {
        double di = l.getIntensity();
        double[] dc = VRMLWriterHelper.colorToDoubleArray(l.getColor());
        out.println(hist + "PointLight { # " + l.getName());
        String oldHist = hist;
        hist = hist + spacing;
        out.println(hist + "intensity " + di);
        if (location != null) {
            out.print(hist + "location ");
            VRMLWriterHelper.writeDoubleArray(location, "", "", 3, out);
        }
        out.print(hist + "color ");
        VRMLWriterHelper.writeDoubleArray(dc, "", "", 3, out);
        hist = oldHist;
        out.println(hist + "}");
    }

    private void writeSpotLight(SpotLight l, String hist, PrintWriter out, double[] location, double[] dir) {
        double di = l.getIntensity();
        double[] dc = VRMLWriterHelper.colorToDoubleArray(l.getColor());
        out.println(hist + "SpotLight { # " + l.getName());
        String oldHist = hist;
        hist = hist + spacing;
        out.println(hist + "intensity " + di);
        out.print(hist + "color ");
        VRMLWriterHelper.writeDoubleArray(dc, "", "", 3, out);
        if (dir != null) {
            out.print(hist + "direction ");
            VRMLWriterHelper.writeDoubleArray(dir, "", "", 3, out);
        }
        if (location != null) {
            out.print(hist + "location ");
            VRMLWriterHelper.writeDoubleArray(location, "", "", 3, out);
        }
        out.println(hist + "beamWidth " + (l.getConeAngle() - l.getConeDeltaAngle()));
        out.println(hist + "cutOffAngle " + l.getConeAngle());
        hist = oldHist;
        out.println(hist + "}");
    }

    public void setWriteTextureFiles(boolean writeTextureFiles2) {
        this.writeTextureFiles = writeTextureFiles2;
    }

    public boolean isWriteTextureFiles() {
        return this.writeTextureFiles;
    }

    public boolean isDrawSpheres() {
        return this.drawSpheres;
    }

    public boolean isDrawTubes() {
        return this.drawTubes;
    }

    public boolean isMoveLightsToSceneRoot() {
        return this.moveLightsToSceneRoot;
    }

    public boolean isUseDefs() {
        return this.useDefs;
    }

    public void setDrawSpheres(boolean drawSpheres) {
        this.drawSpheres = drawSpheres;
    }

    public void setDrawTubes(boolean drawTubes) {
        this.drawTubes = drawTubes;
    }

    public void setUseDefs(boolean useDefs) {
        this.useDefs = useDefs;
    }

    public void setMoveLightsToSceneRoot(boolean moveLightsToSceneRoot) {
        this.moveLightsToSceneRoot = moveLightsToSceneRoot;
    }

    public boolean isEvaluateTextureMatrix() {
        return this.evaluateTextureMatrix;
    }

    public boolean isFlipTextureUpsideDown() {
        return this.flipTextureUpsideDown;
    }

    public void setEvaluateTextureMatrix(boolean evaluateTextureMatrix) {
        this.evaluateTextureMatrix = evaluateTextureMatrix;
    }

    public void setFlipTextureUpsideDown(boolean flipTextureUpsideDown) {
        this.flipTextureUpsideDown = flipTextureUpsideDown;
    }

    public void setWriteTextureCoordIndices(boolean writeTextureCoordIndices) {
        this.writeTextureCoordIndices = writeTextureCoordIndices;
    }

    public boolean isWriteTextureCoordIndices() {
        return this.writeTextureCoordIndices;
    }

    private class MyLightVisitor
    extends SceneGraphVisitor {
        SceneGraphPath p = new SceneGraphPath();

        public void visit(SceneGraphComponent c) {
            if (!c.isVisible()) {
                return;
            }
            this.p.push(c);
            c.childrenAccept(this);
            super.visit(c);
            this.p.pop();
        }

        public void visit(DirectionalLight l) {
            FactoredMatrix fm = new FactoredMatrix(this.p.getMatrix(null));
            fm.update();
            double[] dir = fm.getRotation().multiplyVector(new double[]{0.0, 0.0, -1.0, 0.0});
            WriterVRML2.this.writeDirLight(l, hist, WriterVRML2.this.out, dir);
            super.visit(l);
        }

        public void visit(PointLight l) {
            if (!(l instanceof SpotLight)) {
                FactoredMatrix fm = new FactoredMatrix(this.p.getMatrix(null));
                fm.update();
                double[] c = fm.getTranslation();
                if (c != null) {
                    c = new double[]{c[0], c[1], c[2]};
                }
                WriterVRML2.this.writePointLight(l, hist, WriterVRML2.this.out, c);
            }
            super.visit(l);
        }

        public void visit(SpotLight l) {
            if (WriterVRML2.this.moveLightsToSceneRoot) {
                FactoredMatrix fm = new FactoredMatrix(this.p.getMatrix(null));
                fm.update();
                double[] c = fm.getTranslation();
                double[] dir = fm.getRotation().multiplyVector(new double[]{0.0, 0.0, -1.0, 0.0});
                WriterVRML2.this.writeSpotLight(l, hist, WriterVRML2.this.out, c, dir);
            }
            super.visit(l);
        }
    }

    private class MyVisitor
    extends SceneGraphVisitor {
        protected EffectiveAppearance effApp = EffectiveAppearance.create();

        public MyVisitor() {
        }

        public MyVisitor(MyVisitor mv) {
            this.effApp = mv.effApp;
        }

        public void visit(SceneGraphComponent c) {
            if (!c.isVisible()) {
                return;
            }
            Transformation trafo = c.getTransformation();
            if (trafo != null) {
                WriterVRML2.this.out.println("" + hist + "Transform { # " + c.getName());
                WriterVRML2.this.writeTrafo(trafo);
            } else {
                WriterVRML2.this.out.println("" + hist + "Group { # " + c.getName());
            }
            String oldhist = hist;
            hist = hist + WriterVRML2.spacing;
            WriterVRML2.this.out.println(hist + "children [");
            hist = hist + WriterVRML2.spacing;
            c.childrenAccept(new MyVisitor(this));
            super.visit(c);
            hist = oldhist;
            WriterVRML2.this.out.println("" + hist + WriterVRML2.spacing + "]");
            WriterVRML2.this.out.println("" + hist + "}");
        }

        public void visit(Appearance a) {
            this.effApp = this.effApp.create(a);
            super.visit(a);
        }

        public void visit(Sphere s) {
            super.visit(s);
            if (!WriterVRML2.this.dgs.getShowFaces().booleanValue()) {
                return;
            }
            String histOld = hist;
            boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(GeoTyp.FACE, null);
            WriterVRML2.this.out.println(hist + "Sphere { radius  1}");
            if (hasShapeNode) {
                WriterVRML2.this.closeShapeNode(histOld);
            }
        }

        public void visit(Cylinder c) {
            super.visit(c);
            if (!WriterVRML2.this.dgs.getShowFaces().booleanValue()) {
                return;
            }
            String histOld = hist;
            boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(GeoTyp.FACE, null);
            WriterVRML2.this.out.print(hist + "Cylinder { ");
            WriterVRML2.this.out.print("bottom    FALSE ");
            WriterVRML2.this.out.print("top    FALSE ");
            WriterVRML2.this.out.println("}");
            if (hasShapeNode) {
                WriterVRML2.this.closeShapeNode(histOld);
            }
        }

        public void visit(Geometry g) {
            WriterVRML2.this.updateShaders(this.effApp);
            super.visit(g);
        }

        public void visit(PointSet p) {
            double[][] colors;
            GeoTyp typ;
            super.visit(p);
            if (!WriterVRML2.this.dgs.getShowPoints().booleanValue() || p.getNumPoints() == 0) {
                return;
            }
            String histOld = hist;
            GeoTyp geoTyp = typ = WriterVRML2.this.dvs.getSpheresDraw() != false && WriterVRML2.this.drawSpheres ? GeoTyp.SPHERE : GeoTyp.POINT;
            if (typ == GeoTyp.SPHERE) {
                double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(p, Attribute.COORDINATES);
                double[][] colors2 = VRMLWriterHelper.getDoubleDoubleVertexAttr(p, Attribute.COLORS);
                double radius = WriterVRML2.this.dvs.getPointRadius();
                double[] forcedDiffuseColor = null;
                String hist2 = histOld + WriterVRML2.spacing;
                String hist3 = hist2 + WriterVRML2.spacing;
                hist = hist3;
                for (int i = 0; i < coords.length; ++i) {
                    WriterVRML2.this.out.println("" + histOld + "Transform { # sphere of PointSet ");
                    WriterVRML2.this.out.println(hist2 + "translation ");
                    VRMLWriterHelper.writeDoubleArray(coords[i], hist2, "", 3, WriterVRML2.this.out);
                    WriterVRML2.this.out.println(hist2 + "children [ ");
                    if (colors2 != null) {
                        forcedDiffuseColor = colors2[i];
                    }
                    boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(typ, forcedDiffuseColor);
                    WriterVRML2.this.out.println(hist + "Sphere { radius " + radius + " }");
                    if (hasShapeNode) {
                        WriterVRML2.this.closeShapeNode(hist3);
                    }
                    WriterVRML2.this.out.println(hist2 + "]");
                    WriterVRML2.this.out.println(histOld + "}");
                }
                return;
            }
            boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(typ, null);
            if (WriterVRML2.this.useDefs && WriterVRML2.this.wHelp.isDefinedPointSet(p)) {
                WriterVRML2.this.out.println("" + hist + "USE " + VRMLWriterHelper.str(p.hashCode() + "POINT") + " ");
                if (hasShapeNode) {
                    WriterVRML2.this.closeShapeNode(histOld);
                }
                return;
            }
            if (WriterVRML2.this.useDefs && WriterVRML2.this.wHelp.isMultipleUsedPointSet(p)) {
                WriterVRML2.this.out.print("" + hist + "DEF " + VRMLWriterHelper.str(p.hashCode() + "POINT") + " ");
                WriterVRML2.this.wHelp.setDefinedPointSet(p);
            } else {
                WriterVRML2.this.out.print("" + hist);
            }
            String hist2 = hist;
            hist = hist + WriterVRML2.spacing;
            WriterVRML2.this.out.println("PointSet { # " + p.getName());
            double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(p, Attribute.COORDINATES);
            if (coords != null) {
                WriterVRML2.this.out.println(hist + "coord ");
                WriterVRML2.this.writeCoords(coords, hist + WriterVRML2.spacing);
            }
            if ((colors = VRMLWriterHelper.getDoubleDoubleVertexAttr(p, Attribute.COLORS)) != null && colors.length > 0) {
                WriterVRML2.this.out.println(hist + "color ");
                WriterVRML2.this.writeColors(colors, hist + WriterVRML2.spacing);
            }
            hist = hist2;
            WriterVRML2.this.out.println(hist + "}");
            if (hasShapeNode) {
                WriterVRML2.this.closeShapeNode(histOld);
            }
        }

        public void visit(IndexedLineSet g) {
            double[][] colors;
            int[][] indis;
            GeoTyp typ;
            super.visit(g);
            if (!WriterVRML2.this.dls.getTubeDraw().booleanValue() || !WriterVRML2.this.dgs.getShowLines().booleanValue() || g.getNumEdges() == 0) {
                return;
            }
            String histOld = hist;
            GeoTyp geoTyp = typ = WriterVRML2.this.dls.getTubeDraw() != false && WriterVRML2.this.drawTubes ? GeoTyp.TUBE : GeoTyp.LINE;
            if (typ == GeoTyp.TUBE) {
                double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.COORDINATES);
                double[][] colors2 = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.COLORS);
                int[][] indices = VRMLWriterHelper.getIntIntEdgeAttr(g, Attribute.INDICES);
                if (indices == null) {
                    return;
                }
                double radius = WriterVRML2.this.dls.getTubeRadius();
                double[] forcedDiffuseColor = null;
                String hist2 = histOld + WriterVRML2.spacing;
                String hist3 = hist2 + WriterVRML2.spacing;
                hist = hist3;
                for (int[] line : indices) {
                    for (int i = 1; i < line.length; ++i) {
                        double[] v = coords[line[i - 1]];
                        double[] w = coords[line[i]];
                        WriterVRML2.this.out.println("" + histOld + "Transform { # tubes of LineSet ");
                        Transformation cylTrafo = new Transformation(VRMLWriterHelper.calcCylinderMatrix(v, w, radius));
                        WriterVRML2.this.writeTrafo(cylTrafo);
                        WriterVRML2.this.out.println(hist2 + "children [ ");
                        if (colors2 != null) {
                            forcedDiffuseColor = colors2[i];
                        }
                        boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(typ, forcedDiffuseColor);
                        WriterVRML2.this.out.print(hist + "Cylinder { ");
                        WriterVRML2.this.out.print("bottom    FALSE ");
                        WriterVRML2.this.out.print("top    FALSE ");
                        WriterVRML2.this.out.println(" } ");
                        if (hasShapeNode) {
                            WriterVRML2.this.closeShapeNode(hist3);
                        }
                        WriterVRML2.this.out.println(hist2 + "]");
                        WriterVRML2.this.out.println(histOld + "}");
                    }
                }
                return;
            }
            boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(typ, null);
            if (WriterVRML2.this.useDefs && WriterVRML2.this.wHelp.isDefinedLineSet(g)) {
                WriterVRML2.this.out.println("" + hist + "USE " + VRMLWriterHelper.str(g.hashCode() + "LINE") + " ");
                if (hasShapeNode) {
                    WriterVRML2.this.closeShapeNode(histOld);
                }
                return;
            }
            if (WriterVRML2.this.useDefs && WriterVRML2.this.wHelp.isMultipleUsedLineSet(g)) {
                WriterVRML2.this.out.print("" + hist + "DEF " + VRMLWriterHelper.str(g.hashCode() + "LINE") + " ");
                WriterVRML2.this.wHelp.setDefinedLineSet(g);
            } else {
                WriterVRML2.this.out.print("" + hist);
            }
            String hist2 = hist;
            hist = hist + WriterVRML2.spacing;
            WriterVRML2.this.out.println("IndexedLineSet { # " + g.getName());
            double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.COORDINATES);
            if (coords != null) {
                WriterVRML2.this.out.println(hist + "coord ");
                WriterVRML2.this.writeCoords(coords, hist + WriterVRML2.spacing);
            }
            if ((indis = VRMLWriterHelper.getIntIntEdgeAttr(g, Attribute.INDICES)) != null) {
                WriterVRML2.this.writeIndices(indis, hist + WriterVRML2.spacing);
            }
            if ((colors = VRMLWriterHelper.getDoubleDoubleEdgeAttr(g, Attribute.COLORS)) != null && colors.length > 0) {
                WriterVRML2.this.out.println(hist + "color ");
                WriterVRML2.this.writeColors(colors, hist + WriterVRML2.spacing);
            }
            hist = hist2;
            WriterVRML2.this.out.println(hist + "}");
            if (hasShapeNode) {
                WriterVRML2.this.closeShapeNode(histOld);
            }
        }

        public void visit(IndexedFaceSet g) {
            int[][] indis;
            super.visit(g);
            if (!WriterVRML2.this.dgs.getShowFaces().booleanValue() || g.getNumFaces() == 0) {
                return;
            }
            String histOld = hist;
            GeoTyp typ = GeoTyp.FACE;
            double[][] textCoords = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.TEXTURE_COORDINATES);
            if (textCoords != null) {
                typ = GeoTyp.TEX_FACE;
            }
            boolean hasShapeNode = WriterVRML2.this.tryWriteShapeNode(typ, null);
            if (WriterVRML2.this.useDefs && WriterVRML2.this.wHelp.isDefinedFaceSet(g)) {
                WriterVRML2.this.out.println("" + hist + "USE " + VRMLWriterHelper.str(g.hashCode() + "POLYGON") + " ");
                if (hasShapeNode) {
                    WriterVRML2.this.closeShapeNode(histOld);
                }
                return;
            }
            if (WriterVRML2.this.useDefs && WriterVRML2.this.wHelp.isMultipleUsedFaceSet(g)) {
                WriterVRML2.this.out.print("" + hist + "DEF " + VRMLWriterHelper.str(g.hashCode() + "POLYGON") + " ");
                WriterVRML2.this.wHelp.setDefinedFaceSet(g);
            } else {
                WriterVRML2.this.out.print("" + hist);
            }
            String hist2 = hist;
            hist = hist + WriterVRML2.spacing;
            WriterVRML2.this.out.println("IndexedFaceSet { # " + g.getName());
            double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.COORDINATES);
            if (coords != null) {
                WriterVRML2.this.out.println(hist + "coord ");
                WriterVRML2.this.writeCoords(coords, hist + WriterVRML2.spacing);
            }
            if ((indis = VRMLWriterHelper.getIntIntFaceAttr(g, Attribute.INDICES)) != null) {
                WriterVRML2.this.writeIndices(indis, hist);
            }
            if (textCoords != null) {
                WriterVRML2.this.out.println(hist + "texCoord ");
                WriterVRML2.this.writeTexCoords(textCoords, hist + WriterVRML2.spacing);
                if (WriterVRML2.this.writeTextureCoordIndices) {
                    WriterVRML2.this.out.println(hist + "texCoordIndex ");
                }
            }
            double[][] vertColors = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.COLORS);
            double[][] faceColors = VRMLWriterHelper.getDoubleDoubleFaceAttr(g, Attribute.COLORS);
            if (WriterVRML2.this.dps.getSmoothShading().booleanValue() && vertColors != null) {
                WriterVRML2.this.out.println(hist + "color ");
                WriterVRML2.this.writeColors(vertColors, hist + WriterVRML2.spacing);
                WriterVRML2.this.out.println(hist + "colorPerVertex TRUE");
            } else if (faceColors != null) {
                WriterVRML2.this.out.println(hist + "color ");
                WriterVRML2.this.writeColors(faceColors, hist + WriterVRML2.spacing);
                WriterVRML2.this.out.println(hist + "colorPerVertex FALSE");
            }
            double[][] vertNormals = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.NORMALS);
            double[][] faceNormals = VRMLWriterHelper.getDoubleDoubleFaceAttr(g, Attribute.NORMALS);
            if (WriterVRML2.this.dps.getSmoothShading().booleanValue() && vertNormals != null) {
                WriterVRML2.this.out.println(hist + "normal ");
                WriterVRML2.this.writeNormals(vertNormals, hist + WriterVRML2.spacing);
                WriterVRML2.this.out.println(hist + "normalPerVertex TRUE");
            } else if (faceNormals != null) {
                WriterVRML2.this.out.println(hist + "normal ");
                WriterVRML2.this.writeNormals(faceNormals, hist + WriterVRML2.spacing);
                WriterVRML2.this.out.println(hist + "normalPerVertex FALSE");
            }
            WriterVRML2.this.out.println(hist + "convex FALSE solid FALSE ");
            hist = hist2;
            WriterVRML2.this.out.println(hist + "}");
            if (hasShapeNode) {
                WriterVRML2.this.closeShapeNode(histOld);
            }
        }

        public void visit(Light l) {
            super.visit(l);
        }

        public void visit(DirectionalLight l) {
            if (WriterVRML2.this.moveLightsToSceneRoot) {
                return;
            }
            WriterVRML2.this.writeDirLight(l, hist, WriterVRML2.this.out, null);
            super.visit(l);
        }

        public void visit(PointLight l) {
            if (WriterVRML2.this.moveLightsToSceneRoot) {
                return;
            }
            if (!(l instanceof SpotLight)) {
                WriterVRML2.this.writePointLight(l, hist, WriterVRML2.this.out, null);
            }
            super.visit(l);
        }

        public void visit(SpotLight l) {
            if (WriterVRML2.this.moveLightsToSceneRoot) {
                return;
            }
            WriterVRML2.this.writeSpotLight(l, hist, WriterVRML2.this.out, null, null);
            super.visit(l);
        }

        public void visit(Camera c) {
            WriterVRML2.this.out.println(hist + "Viewpoint { ");
            String oldHist = hist;
            hist = hist + WriterVRML2.spacing;
            WriterVRML2.this.out.println(hist + "fieldOfView " + c.getFieldOfView() * Math.PI / 180.0);
            double[] m = c.getOrientationMatrix();
            FactoredMatrix fm = new FactoredMatrix(m);
            fm.update();
            double[] rotAx = fm.getRotationAxis();
            double ang = fm.getRotationAngle();
            double[] pos = fm.getTranslation();
            WriterVRML2.this.out.println(hist + "position 0 0 0");
            hist = oldHist;
            WriterVRML2.this.out.println(hist + "}");
            super.visit(c);
        }

        public void visit(Transformation t) {
            super.visit(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GeoTyp {
        TEX_FACE,
        FACE,
        TUBE,
        LINE,
        SPHERE,
        POINT;

    }
}

