/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.util.LoggingSystem;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;

public class TargaFile {
    private byte FHimageIDLength = 0;
    private byte FHcolorMapType = 0;
    private byte FHimageType = 0;
    private short FHcolorMapOrigin = 0;
    private short FHcolorMapLength = 0;
    private byte FHcolorMapDepth = 0;
    private short FHimageXOrigin = 0;
    private short FHimageYOrigin = 0;
    private short FHwidth = 0;
    private short FHheight = 0;
    private byte FHbitCount = 0;
    private byte FHimageDescriptor = 0;
    private int filePointer = 0;
    private byte[] fileContents = null;
    private byte[] data = null;

    public byte[] getData() {
        return this.data;
    }

    public int getWidth() {
        return this.FHwidth;
    }

    public int getHeight() {
        return this.FHheight;
    }

    public int getBPP() {
        return this.FHbitCount;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public static BufferedImage getBufferedImage(InputStream is) {
        TargaFile loader = new TargaFile();
        loader.load(is);
        int width = loader.getWidth();
        int height = loader.getHeight();
        int bytePerPixel = loader.getBPP() / 8;
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        byte[] imageData = loader.getData();
        for (int j = height - 1; j >= 0; --j) {
            for (int i = 0; i < width; ++i) {
                int index = ((height - 1 - j) * width + i) * bytePerPixel;
                int alpha = bytePerPixel == 4 ? imageData[index + 3] : -1;
                int color = (alpha & 0xFF) << 24 | (imageData[index + 0] & 0xFF) << 16 | (imageData[index + 1] & 0xFF) << 8 | imageData[index + 2] & 0xFF;
                bufferedImage.setRGB(i, j, color);
            }
        }
        return bufferedImage;
    }

    public void load(InputStream dis) {
        this.FHimageIDLength = 0;
        this.FHcolorMapType = 0;
        this.FHimageType = 0;
        this.FHcolorMapOrigin = 0;
        this.FHcolorMapLength = 0;
        this.FHcolorMapDepth = 0;
        this.FHimageXOrigin = 0;
        this.FHimageYOrigin = 0;
        this.FHwidth = 0;
        this.FHheight = 0;
        this.FHbitCount = 0;
        this.FHimageDescriptor = 0;
        this.filePointer = 0;
        try {
            int v;
            LinkedList<Byte> content = new LinkedList<Byte>();
            while ((v = dis.read()) != -1) {
                content.add((byte)v);
            }
            this.fileContents = new byte[content.size()];
            int i = 0;
            Iterator i$ = content.iterator();
            while (i$.hasNext()) {
                byte b = (Byte)i$.next();
                this.fileContents[i++] = b;
            }
            System.out.println("read " + this.fileContents.length);
            this.FHimageIDLength = (byte)this.readUnsignedByte();
            this.FHcolorMapType = (byte)this.readUnsignedByte();
            this.FHimageType = (byte)this.readUnsignedByte();
            this.FHcolorMapOrigin = this.readShort();
            this.FHcolorMapLength = this.readShort();
            this.FHcolorMapDepth = (byte)this.readUnsignedByte();
            this.FHimageXOrigin = this.readShort();
            this.FHimageYOrigin = this.readShort();
            this.FHwidth = this.readShort();
            this.FHheight = this.readShort();
            this.FHbitCount = (byte)this.readUnsignedByte();
            this.FHimageDescriptor = (byte)this.readUnsignedByte();
            if (this.FHimageType != 2 && this.FHimageType != 3) {
                if (this.FHimageType == 10) {
                    this.loadCompressed();
                }
                this.fileContents = null;
                return;
            }
            int bytesPerPixel = this.FHbitCount / 8;
            this.data = new byte[this.FHwidth * this.FHheight * bytesPerPixel];
            System.arraycopy(this.fileContents, this.filePointer, this.data, 0, this.data.length);
            if (this.FHbitCount == 24 || this.FHbitCount == 32) {
                for (int loop = 0; loop < this.data.length; loop += bytesPerPixel) {
                    byte btemp = this.data[loop];
                    this.data[loop] = this.data[loop + 2];
                    this.data[loop + 2] = btemp;
                }
            }
            this.fileContents = null;
        }
        catch (Exception x) {
            x.printStackTrace();
            LoggingSystem.getLogger(this).log(Level.WARNING, "exception while loading", x.getMessage());
        }
    }

    public void loadCompressed() {
        int bytesPerPixel = this.FHbitCount / 8;
        this.data = new byte[this.FHwidth * this.FHheight * bytesPerPixel];
        int pixelcount = this.FHwidth * this.FHheight;
        int currentbyte = 0;
        int currentpixel = 0;
        byte[] colorbuffer = new byte[bytesPerPixel];
        try {
            do {
                int counter;
                int chunkheader = 0;
                chunkheader = this.readUnsignedByte();
                if (chunkheader < 128) {
                    ++chunkheader;
                    for (counter = 0; counter < chunkheader; counter = (int)((short)(counter + 1))) {
                        this.readColorBuffer(colorbuffer);
                        this.data[currentbyte + 0] = colorbuffer[2];
                        this.data[currentbyte + 1] = colorbuffer[1];
                        this.data[currentbyte + 2] = colorbuffer[0];
                        if (bytesPerPixel == 4) {
                            this.data[currentbyte + 3] = (byte)this.readUnsignedByte();
                        }
                        currentbyte += bytesPerPixel;
                        if (++currentpixel <= pixelcount) continue;
                        throw new IOException("Too many pixels read");
                    }
                } else {
                    chunkheader -= 127;
                    this.readColorBuffer(colorbuffer);
                    for (counter = 0; counter < chunkheader; counter = (int)((short)(counter + 1))) {
                        this.data[currentbyte + 0] = colorbuffer[2];
                        this.data[currentbyte + 1] = colorbuffer[1];
                        this.data[currentbyte + 2] = colorbuffer[0];
                        if (bytesPerPixel == 4) {
                            this.data[currentbyte + 3] = (byte)this.readUnsignedByte();
                        }
                        currentbyte += bytesPerPixel;
                        if (++currentpixel <= pixelcount) continue;
                        throw new IOException("Too many pixels read");
                    }
                }
            } while (currentpixel < pixelcount);
        }
        catch (Exception x) {
            x.printStackTrace();
            LoggingSystem.getLogger(this).log(Level.WARNING, "exception while loading compressed", x.getMessage());
        }
    }

    private void readColorBuffer(byte[] buffer) {
        buffer[0] = (byte)this.readUnsignedByte();
        buffer[1] = (byte)this.readUnsignedByte();
        buffer[2] = (byte)this.readUnsignedByte();
    }

    private int readUnsignedByte() {
        return this.fileContents[this.filePointer++] & 0xFF;
    }

    private short readShort() {
        int s1 = this.fileContents[this.filePointer++] & 0xFF;
        int s2 = (this.fileContents[this.filePointer++] & 0xFF) << 8;
        return (short)(s1 | s2);
    }
}

