/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.util.LoggingSystem;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;

public class SimpleURLPolicy
extends Policy {
    private static final AllPermission ALL_PERM = new AllPermission();
    private final HashSet restricted = new HashSet();
    private final LinkedList restrictedPermissions = new LinkedList();

    public SimpleURLPolicy(Collection permissions, URL url) {
        this(permissions, Collections.singleton(url));
    }

    public SimpleURLPolicy(Collection permissions, Collection urls) {
        this.restrictedPermissions.addAll(permissions);
        this.restricted.addAll(urls);
        this.restricted.add(null);
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions pc = new Permissions();
        if (this.restricted.contains(codesource.getLocation())) {
            for (Permission element : this.restrictedPermissions) {
                pc.add(element);
            }
        } else {
            pc.add(ALL_PERM);
        }
        return pc;
    }

    public void refresh() {
        LoggingSystem.getLogger(this).log(Level.FINER, "refresh called");
    }
}

