/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.util.LoggingSystem;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Secure {
    public static String getProperty(final String name, final String def) {
        String result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name, def);
                }
            });
        }
        catch (Throwable t) {
            result = def;
        }
        return result;
    }

    public static String getProperty(final String name) {
        return Secure.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    public static String setProperty(final String name, final String value) {
        return Secure.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(name, value);
            }
        });
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        T ret = null;
        try {
            ret = AccessController.doPrivileged(action);
        }
        catch (Throwable e) {
            LoggingSystem.getLogger(Secure.class).log(Level.INFO, "security problem:", e);
        }
        return ret;
    }
}

