/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.geometry.GeometryUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointSet;
import de.jreality.scene.Scene;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.util.ClippingPlaneCollector;
import de.jreality.util.CopyVisitor;
import de.jreality.util.LightCollector;
import de.jreality.util.LoggingSystem;
import de.jreality.util.PathCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneGraphUtility {
    public static SceneGraphComponent createFullSceneGraphComponent() {
        return SceneGraphUtility.createFullSceneGraphComponent("unnamed");
    }

    public static SceneGraphComponent createFullSceneGraphComponent(String name) {
        SceneGraphComponent c = new SceneGraphComponent();
        c.setTransformation(new Transformation());
        c.setAppearance(new Appearance());
        c.setName(name);
        return c;
    }

    public static void replaceChild(SceneGraphComponent c, SceneGraphComponent ch) {
        int n = c.getChildComponentCount();
        if (n == 0) {
            c.addChild(ch);
            return;
        }
        SceneGraphComponent och = c.getChildComponent(0);
        if (och == ch) {
            return;
        }
        c.removeChild(och);
        c.addChild(ch);
    }

    public static void removeChildren(final SceneGraphComponent c) {
        Scene.executeWriter(c, new Runnable(){

            public void run() {
                while (c.getChildComponentCount() > 0) {
                    c.removeChild(c.getChildComponent(0));
                }
            }
        });
    }

    public static void setMetric(SceneGraphComponent r, int metric) {
        int sig = metric;
        if (r.getAppearance() == null) {
            r.setAppearance(new Appearance());
        }
        r.getAppearance().setAttribute("metric", sig);
    }

    public static int getMetric(SceneGraphPath sgp) {
        EffectiveAppearance eap = EffectiveAppearance.create(sgp);
        int sig = eap.getAttribute("metric", 0);
        return sig;
    }

    public static List<SceneGraphPath> collectLights(SceneGraphComponent rootNode) {
        return (List)new LightCollector(rootNode).visit();
    }

    public static List<SceneGraphPath> collectClippingPlanes(SceneGraphComponent rootNode) {
        return (List)new ClippingPlaneCollector(rootNode).visit();
    }

    public static List<SceneGraphPath> getPathsBetween(SceneGraphComponent begin, final SceneGraphNode end) {
        PathCollector.Matcher matcher = new PathCollector.Matcher(){

            public boolean matches(SceneGraphPath p) {
                return p.getLastElement() == end;
            }
        };
        return new PathCollector(matcher, begin).visit();
    }

    public static List<SceneGraphPath> getPathsToNamedNodes(SceneGraphComponent root, final String name) {
        PathCollector.Matcher matcher = new PathCollector.Matcher(){

            public boolean matches(SceneGraphPath p) {
                return p.getLastElement().getName().equals(name);
            }
        };
        return new PathCollector(matcher, root).visit();
    }

    public static void removeChildNode(final SceneGraphComponent parent, SceneGraphNode node) {
        node.accept(new SceneGraphVisitor(){

            public void visit(Appearance a) {
                if (parent.getAppearance() != a) {
                    throw new IllegalArgumentException("no such child!");
                }
                parent.setAppearance(null);
            }

            public void visit(Camera c) {
                if (parent.getCamera() != c) {
                    throw new IllegalArgumentException("no such child!");
                }
                parent.setCamera(null);
            }

            public void visit(Geometry g) {
                if (parent.getGeometry() != g) {
                    throw new IllegalArgumentException("no such child!");
                }
                parent.setGeometry(null);
            }

            public void visit(Light l) {
                if (parent.getLight() != l) {
                    throw new IllegalArgumentException("no such child!");
                }
                parent.setLight(null);
            }

            public void visit(Transformation t) {
                if (parent.getTransformation() != t) {
                    throw new IllegalArgumentException("no such child!");
                }
                parent.setTransformation(null);
            }

            public void visit(SceneGraphComponent c) {
                if (!parent.getChildNodes().contains(c)) {
                    throw new IllegalArgumentException("no such child!");
                }
                parent.removeChild(c);
            }
        });
    }

    public static void addChildNode(final SceneGraphComponent parent, SceneGraphNode node) {
        node.accept(new SceneGraphVisitor(){

            public void visit(Appearance a) {
                parent.setAppearance(a);
            }

            public void visit(Camera c) {
                parent.setCamera(c);
            }

            public void visit(Geometry g) {
                parent.setGeometry(g);
            }

            public void visit(Light l) {
                parent.setLight(l);
            }

            public void visit(Transformation t) {
                parent.setTransformation(t);
            }

            public void visit(SceneGraphComponent c) {
                parent.addChild(c);
            }
        });
    }

    public static int getIndexOfChild(SceneGraphComponent parent, SceneGraphComponent child) {
        int l = parent.getChildComponentCount();
        for (int i = 0; i < l; ++i) {
            if (parent.getChildComponent(i) != child) continue;
            return i;
        }
        return -1;
    }

    public static <T extends SceneGraphNode> T copy(T template) {
        CopyVisitor cv = new CopyVisitor();
        template.accept(cv);
        return (T)cv.getCopy();
    }

    public static Geometry getFirstGeometry(SceneGraphComponent sgc) {
        class GetFirstGeometryVisitor
        extends SceneGraphVisitor {
            boolean found = false;
            Geometry geom = null;

            GetFirstGeometryVisitor() {
            }

            public void visit(Geometry g) {
                if (this.found) {
                    return;
                }
                this.geom = g;
                this.found = true;
            }

            public void visit(SceneGraphComponent c) {
                if (this.found) {
                    return;
                }
                c.childrenAccept(this);
            }

            Geometry getGeometry() {
                return this.geom;
            }
        }
        GetFirstGeometryVisitor gfgv = new GetFirstGeometryVisitor();
        gfgv.visit(sgc);
        return gfgv.getGeometry();
    }

    public static SceneGraphComponent flatten(SceneGraphComponent sgc) {
        return SceneGraphUtility.flatten(sgc, false);
    }

    public static SceneGraphComponent flatten(SceneGraphComponent sgc, boolean rejectInvis) {
        return SceneGraphUtility.flatten(sgc, rejectInvis, true);
    }

    public static SceneGraphComponent flatten(SceneGraphComponent sgc, final boolean rejectInvis, final boolean removeTform) {
        final double[] flipit = P3.makeStretchMatrix(null, new double[]{-1.0, 0.0, -1.0, 0.0, -1.0});
        final ArrayList geoms = new ArrayList();
        SceneGraphVisitor v = new SceneGraphVisitor(){
            SceneGraphPath thePath = new SceneGraphPath();

            public void visit(PointSet oldi) {
                PointSet geometry = SceneGraphUtility.copy(oldi);
                if (geometry.getVertexAttributes(Attribute.COORDINATES) == null) {
                    return;
                }
                double[][] v = null;
                double[][] nv = null;
                double[] currentMatrix = this.thePath.getMatrix(null);
                if (removeTform) {
                    v = geometry.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
                    nv = Rn.matrixTimesVector((double[][])null, currentMatrix, v);
                    geometry.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
                }
                double[] cmp = null;
                if (geometry instanceof IndexedFaceSet) {
                    IndexedFaceSet ifs = (IndexedFaceSet)geometry;
                    double[] mat = Rn.transpose(null, currentMatrix);
                    mat[14] = 0.0;
                    mat[13] = 0.0;
                    mat[12] = 0.0;
                    Rn.inverse(mat, mat);
                    cmp = mat;
                    if (ifs.getFaceAttributes(Attribute.NORMALS) != null) {
                        v = ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
                        if (removeTform) {
                            nv = Rn.matrixTimesVector((double[][])null, cmp, v);
                            ifs.setFaceAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
                        } else if (Rn.determinant(currentMatrix) < 0.0) {
                            nv = Rn.matrixTimesVector((double[][])null, flipit, v);
                            ifs.setFaceAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
                        }
                    }
                    if (ifs.getVertexAttributes(Attribute.NORMALS) != null) {
                        v = ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
                        if (removeTform) {
                            nv = Rn.matrixTimesVector((double[][])null, cmp, v);
                            ifs.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
                        } else if (Rn.determinant(currentMatrix) < 0.0) {
                            nv = Rn.matrixTimesVector((double[][])null, flipit, v);
                            ifs.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
                        }
                    }
                }
                SceneGraphComponent foo = new SceneGraphComponent();
                foo.setGeometry(geometry);
                if (!removeTform) {
                    MatrixBuilder.euclidean(new Matrix(currentMatrix)).assignTo(foo);
                }
                if (this.thePath.getLastComponent().getAppearance() != null) {
                    foo.setAppearance(this.thePath.getLastComponent().getAppearance());
                }
                foo.setVisible(this.thePath.getLastComponent().isVisible());
                geoms.add(foo);
            }

            public void visit(SceneGraphComponent c) {
                if (rejectInvis && !c.isVisible()) {
                    return;
                }
                this.thePath.push(c);
                c.childrenAccept(this);
                this.thePath.pop();
            }

            public void visit(Sphere s) {
                LoggingSystem.getLogger(GeometryUtility.class).log(Level.WARNING, "Can't flatten a sphere yet");
            }
        };
        v.visit(sgc);
        SceneGraphComponent flat = new SceneGraphComponent();
        if (sgc.getAppearance() != null) {
            flat.setAppearance(sgc.getAppearance());
        }
        for (SceneGraphComponent foo : geoms) {
            flat.addChild(foo);
        }
        return flat;
    }

    public static Appearance findDeepestAppearance(SceneGraphPath theSelection) {
        Appearance selectedAppearance = null;
        Iterator<SceneGraphNode> lit = theSelection.reverseIterator();
        while (lit.hasNext()) {
            SceneGraphNode selt = lit.next();
            if (selt == null) continue;
            if (selt instanceof Appearance) {
                selectedAppearance = (Appearance)selt;
            } else if (selt instanceof SceneGraphComponent) {
                selectedAppearance = ((SceneGraphComponent)selt).getAppearance();
            }
            if (selectedAppearance == null) continue;
            break;
        }
        return selectedAppearance;
    }

    public static void removeLights(Viewer viewer) {
        SceneGraphComponent root = viewer.getSceneRoot();
        List<SceneGraphPath> lightpath = SceneGraphUtility.collectLights(root);
        for (SceneGraphPath sgp : lightpath) {
            Light light = (Light)sgp.getLastElement();
            SceneGraphComponent lightnode = sgp.getLastComponent();
            lightnode.setLight(null);
        }
    }
}

