/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.util.LoggingSystem;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;

public class Rectangle3D {
    public static final Rectangle3D EMPTY_BOX = new Rectangle3D();
    public static final Rectangle3D unitCube = new Rectangle3D();
    double[][] bounds = new double[2][3];
    double[] center = new double[3];
    double[] extent = new double[3];

    public Rectangle3D() {
        this.initialize();
    }

    public Rectangle3D(double w, double h, double d) {
        this();
        this.bounds[0][0] = 0.0;
        this.bounds[0][1] = 0.0;
        this.bounds[0][2] = 0.0;
        this.bounds[1][0] = w;
        this.bounds[1][1] = h;
        this.bounds[1][2] = d;
    }

    public Rectangle3D(double[][] vlist) {
        this();
        this.computeFromVectorList(vlist);
    }

    public void initialize() {
        Rn.setToValue(this.bounds[0], Double.MAX_VALUE);
        Rn.setToValue(this.bounds[1], -1.7976931348623157E308);
    }

    public void copyInto(Rectangle3D bb) {
        System.arraycopy(this.bounds[0], 0, bb.bounds[0], 0, this.bounds[0].length);
        System.arraycopy(this.bounds[1], 0, bb.bounds[1], 0, this.bounds[1].length);
        bb.update();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isEmpty()) {
            sb.append("IsEmpty");
            return sb.toString();
        }
        sb.append("Min:\t" + Rn.toString(this.bounds[0]) + "\n");
        sb.append("Max:\t" + Rn.toString(this.bounds[1]) + "\n");
        sb.append("Center:\t" + Rn.toString(this.center) + "\n");
        sb.append("Extent:\t" + Rn.toString(this.extent) + "\n");
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.getMinX() > this.getMaxX() || this.getMinY() > this.getMaxY() || this.getMinZ() > this.getMaxZ();
    }

    public void update() {
        if (this.isEmpty()) {
            return;
        }
        Rn.linearCombination(this.center, 0.5, this.bounds[0], 0.5, this.bounds[1]);
        Rn.subtract(this.extent, this.bounds[1], this.bounds[0]);
    }

    public Rectangle3D transformByMatrix(Rectangle3D target, double[] aTransform) {
        int i;
        double[][] cube = new double[8][3];
        double[][] tcube = new double[8][3];
        if (target == null) {
            target = new Rectangle3D();
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    cube[i * 4 + j * 2 + k][0] = this.bounds[i][0];
                    cube[i * 4 + j * 2 + k][1] = this.bounds[j][1];
                    cube[i * 4 + j * 2 + k][2] = this.bounds[k][2];
                }
            }
        }
        Rn.matrixTimesVector(tcube, aTransform, cube);
        for (i = 0; i < 8; ++i) {
            LoggingSystem.getLogger(this).log(Level.FINER, Rn.toString(tcube[i]));
        }
        Rn.calculateBounds(target.bounds, tcube);
        target.update();
        return target;
    }

    public Rectangle3D computeFromVectorList(double[][] vlist) {
        if (vlist[0].length == 3) {
            Rn.calculateBounds(this.bounds, vlist);
        } else if (vlist[0].length == 4) {
            Pn.calculateBounds(this.bounds, vlist);
        } else {
            throw new IllegalArgumentException("computeFromVectorList: invalid vlist dimension");
        }
        this.update();
        return this;
    }

    public Rectangle3D unionWith(Rectangle3D aBound, Rectangle3D target) {
        if (target == null) {
            target = this;
        }
        if (this.isEmpty() && !aBound.isEmpty()) {
            System.arraycopy(aBound.bounds[0], 0, this.bounds[0], 0, 3);
            System.arraycopy(aBound.bounds[1], 0, this.bounds[1], 0, 3);
            target.update();
            return target;
        }
        if (!this.isEmpty() && aBound.isEmpty()) {
            System.arraycopy(this.bounds[0], 0, target.bounds[0], 0, 3);
            System.arraycopy(this.bounds[1], 0, target.bounds[1], 0, 3);
            target.update();
            return target;
        }
        if (this.isEmpty() && aBound.isEmpty()) {
            return target;
        }
        Rn.min(target.bounds[0], aBound.bounds[0], this.bounds[0]);
        Rn.max(target.bounds[1], aBound.bounds[1], this.bounds[1]);
        target.update();
        return target;
    }

    public double[] getCenter() {
        this.update();
        return (double[])this.center.clone();
    }

    public double[] getExtent() {
        this.update();
        return (double[])this.extent.clone();
    }

    public double getMaxExtent() {
        double max = Math.max(Math.max(this.extent[0], this.extent[1]), this.extent[2]);
        return max;
    }

    public Rectangle2D convertToRectangle2D(Rectangle2D rec) {
        Rectangle2D screenExtent = rec == null ? new Rectangle2D.Double() : rec;
        screenExtent.setFrameFromDiagonal(this.bounds[0][0], this.bounds[1][0], this.bounds[1][0], this.bounds[1][1]);
        return screenExtent;
    }

    public double[][] getBounds() {
        return (double[][])this.bounds.clone();
    }

    public void setBounds(double[][] b) {
        if (b.length != 2 || b[0].length != 3) {
            return;
        }
        this.bounds = (double[][])b.clone();
        this.update();
    }

    public double getMinX() {
        return this.bounds[0][0];
    }

    public double getMaxX() {
        return this.bounds[1][0];
    }

    public double getMinY() {
        return this.bounds[0][1];
    }

    public double getMaxY() {
        return this.bounds[1][1];
    }

    public double getMinZ() {
        return this.bounds[0][2];
    }

    public double getMaxZ() {
        return this.bounds[1][2];
    }

    public double[] getCenter(double[] store) {
        if (store == null) {
            return this.getCenter();
        }
        this.update();
        System.arraycopy(this.center, 0, store, 0, 3);
        return store;
    }

    public double[] getExtent(double[] store) {
        if (store == null) {
            return this.getExtent();
        }
        this.update();
        System.arraycopy(this.extent, 0, store, 0, 3);
        return store;
    }

    public double[][] getBounds(double[][] store) {
        if (store == null) {
            return this.getBounds();
        }
        System.arraycopy(this.bounds[0], 0, store[0], 0, 3);
        System.arraycopy(this.bounds[1], 0, store[1], 0, 3);
        return store;
    }

    public void scale(double d) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                double[] dArray = this.bounds[j];
                int n = i;
                dArray[n] = dArray[n] * d;
            }
        }
    }

    public void add(double d) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                double[] dArray = this.bounds[j];
                int n = i;
                dArray[n] = dArray[n] + (j == 0 ? -d : d);
            }
        }
    }

    static {
        double[][] bds = new double[2][3];
        bds[0][2] = -1.0;
        bds[0][1] = -1.0;
        bds[0][0] = -1.0;
        bds[1][2] = 1.0;
        bds[1][1] = 1.0;
        bds[1][0] = 1.0;
        unitCube.setBounds(bds);
        unitCube.update();
    }
}

