/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.Scene;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.pick.AABBTree;

public class PickUtility {
    public static String AABB_TREE = "AABBTree";
    private static final int DEFAULT_TRIANGLES_PER_BOX = 10;

    private PickUtility() {
    }

    public static void assignFaceAABBTree(IndexedFaceSet ifs) {
        PickUtility.assignFaceAABBTree(ifs, 10);
    }

    public static void assignFaceAABBTree(IndexedFaceSet ifs, int maxTrianglesPerBox) {
        if (ifs.getNumFaces() == 0) {
            return;
        }
        ifs.setGeometryAttributes(AABB_TREE, AABBTree.construct(ifs, maxTrianglesPerBox));
    }

    public static void assignFaceAABBTrees(SceneGraphComponent comp) {
        PickUtility.assignFaceAABBTrees(comp, 10);
    }

    public static void assignFaceAABBTrees(SceneGraphComponent comp, final int maxTrianglesPerBox) {
        comp.accept(new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                if (c.getGeometry() != null && c.getGeometry() instanceof IndexedFaceSet) {
                    PickUtility.assignFaceAABBTree((IndexedFaceSet)c.getGeometry(), maxTrianglesPerBox);
                }
                c.childrenAccept(this);
            }
        });
    }

    public static void setPickable(SceneGraphComponent cmp, boolean pickable) {
        if (cmp.getAppearance() == null) {
            cmp.setAppearance(new Appearance());
        }
        cmp.getAppearance().setAttribute("pickable", pickable);
    }

    public static void setPickable(SceneGraphComponent cmp, boolean pickPoints, boolean pickEdges, boolean pickFaces) {
        if (cmp.getAppearance() == null) {
            cmp.setAppearance(new Appearance());
        }
        cmp.getAppearance().setAttribute("pointShader.pickable", pickPoints);
        cmp.getAppearance().setAttribute("lineShader.pickable", pickEdges);
        cmp.getAppearance().setAttribute("polygonShader.pickable", pickFaces);
    }

    public static void setPickable(Geometry g, boolean pickable) {
        g.setGeometryAttributes("pickable", pickable);
    }

    public static void clearPickableAttributes(final SceneGraphComponent cmp) {
        Scene.executeWriter(cmp, new Runnable(){

            public void run() {
                cmp.accept(new SceneGraphVisitor(){

                    public void visit(Appearance a) {
                        a.setAttribute("pointShader.pickable", Appearance.INHERITED);
                        a.setAttribute("lineShader.pickable", Appearance.INHERITED);
                        a.setAttribute("polygonShader.pickable", Appearance.INHERITED);
                        a.setAttribute("pickable", Appearance.INHERITED);
                    }

                    public void visit(SceneGraphComponent c) {
                        c.childrenWriteAccept(this, false, true, false, false, false, false);
                    }
                });
            }
        });
    }
}

