/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.util.Secure;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;

public class NativePathUtility {
    public static void set(String pathPrefix) {
        String vmName = Secure.getProperty("java.vm.name");
        if (!vmName.contains("HotSpot")) {
            return;
        }
        String webstartVersion = Secure.getProperty("webstart.version");
        if (webstartVersion != null) {
            System.out.println("I'm webstart");
            return;
        }
        String applet = Secure.getProperty("java.version.applet");
        if (applet != null) {
            System.out.println("I'm an applet");
            return;
        }
        String sysOsName = Secure.getProperty("os.name").toLowerCase();
        String sysOsArch = Secure.getProperty("os.arch").toLowerCase();
        String jniPath = pathPrefix + File.separator;
        if (sysOsName.startsWith("windows")) {
            jniPath = jniPath + "win";
            jniPath = sysOsArch.contains("64") ? jniPath + "64" : jniPath + "32";
        }
        if (sysOsName.startsWith("linux")) {
            jniPath = jniPath + "linux";
            jniPath = sysOsArch.contains("64") ? jniPath + "64" : jniPath + "32";
        }
        if (sysOsName.startsWith("mac os x")) {
            jniPath = jniPath + "macosx";
        }
        File jniDir = new File(jniPath);
        try {
            Class<ClassLoader> clazz = ClassLoader.class;
            Field field = clazz.getDeclaredField("sys_paths");
            field.setAccessible(true);
            String[] jniPaths = (String[])field.get(clazz);
            LinkedList<String> pathList = new LinkedList<String>();
            pathList.addAll(Arrays.asList(jniPaths));
            pathList.add(jniDir.getAbsolutePath());
            jniPaths = pathList.toArray(jniPaths);
            field.set(null, jniPaths);
            field.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

