/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingSystem {
    private static final Level GLOBAL_LEVEL = Level.SEVERE;
    private static LoggingSystem logSystem = new LoggingSystem();
    private final Logger logger;
    private final Formatter formatter = new SimpleFormatter(){

        public synchronized String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            String message = this.formatMessage(record);
            sb.append(record.getLevel().getLocalizedName());
            if (record.getSourceMethodName() != null) {
                sb.append(" [");
                sb.append(record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(46) + 1)).append(".");
                sb.append(record.getSourceMethodName());
            }
            sb.append("]: ");
            sb.append(message);
            sb.append("\n");
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    };

    private LoggingSystem() {
        this.logger = Logger.getLogger("de.jreality");
        try {
            this.setDebugUse();
        }
        catch (SecurityException se) {
            this.logger.info("no permission to change log level");
        }
    }

    private void setDebugUse() {
        this.logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(this.formatter);
        this.logger.addHandler(handler);
        this.logger.setLevel(GLOBAL_LEVEL);
        handler.setLevel(Level.ALL);
        Logger.getLogger("de.jreality.scene.geometry").setLevel(Level.FINER);
        Logger.getLogger("de.jreality.reader").setLevel(Level.FINEST);
        Logger.getLogger("de.jreality.renderman").setLevel(Level.FINE);
    }

    public static Logger getLogger(Object o) {
        try {
            return logSystem.getLog(o.getClass());
        }
        catch (Throwable t) {
            return Logger.getLogger("de.jreality");
        }
    }

    public static Logger getLogger(Class clazz) {
        try {
            return logSystem.getLog(clazz);
        }
        catch (Throwable t) {
            return Logger.getLogger("de.jreality");
        }
    }

    private Logger getLog(Class clazz) {
        Package p = clazz.getPackage();
        if (p == null) {
            return this.logger;
        }
        String name = p.getName();
        return Logger.getLogger(name);
    }
}

