/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.util.Secure;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class Input {
    private InputStream inputStream;
    private String description;
    private File sourceFile;
    private URL sourceURL;

    public Input(URL url) throws IOException {
        this(url.toString(), url.openStream());
        this.sourceURL = url;
    }

    public Input(File file) throws FileNotFoundException {
        this(file.toString(), new FileInputStream(file));
        this.sourceFile = file;
    }

    public Input(String description, InputStream is) {
        this.description = description;
        this.inputStream = new BufferedInputStream(is);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Reader getReader() {
        return new InputStreamReader(this.inputStream);
    }

    public Reader getReader(String encoding) throws UnsupportedEncodingException {
        return new InputStreamReader(this.inputStream, encoding);
    }

    public Input getRelativeInput(String name) throws IOException {
        if (this.sourceFile != null) {
            File p = this.sourceFile.getParentFile();
            return new Input(p == null ? new File(name) : new File(p, name));
        }
        if (this.sourceURL != null) {
            return new Input(new URL(this.sourceURL, name));
        }
        throw new IOException("cannot resolve \"" + name + "\" relative to \"" + this.description + '\"');
    }

    public Input resolveInput(String name) throws IOException {
        try {
            URL test = ClassLoader.getSystemResource(name);
            if (test != null) {
                return new Input(test);
            }
            URI uri = new URI(name);
            if (uri.isAbsolute()) {
                return new Input(uri.toURL());
            }
            URI base = this.sourceFile != null ? this.sourceFile.toURI() : (this.sourceURL != null ? new URI(this.sourceURL.toExternalForm()) : new URI("file:" + Secure.getProperty("user.dir", "/").replace(File.separatorChar, '/')).normalize());
            URI resolved = base.resolve(uri);
            if (this.sourceFile != null && resolved.getScheme().equals("file")) {
                return new Input(new File(resolved));
            }
            return new Input(resolved.toURL());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        catch (IllegalArgumentException e2) {
            throw new MalformedURLException(e2.getMessage());
        }
    }

    public File toFile() throws UnsupportedOperationException {
        if (this.sourceFile == null) {
            throw new UnsupportedOperationException("not a file");
        }
        return this.sourceFile;
    }

    public URL toURL() throws MalformedURLException {
        if (this.sourceURL != null) {
            return this.sourceURL;
        }
        if (this.sourceFile != null) {
            return this.sourceFile.toURL();
        }
        throw new MalformedURLException("cannot convert " + this.description + " to URL.");
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "Input: " + this.description;
    }

    public static Input getInput(URL url) throws IOException {
        return new Input(url);
    }

    public static Input getInput(File file) throws IOException {
        return new Input(file);
    }

    public static Input getInput(String description, InputStream in) throws IOException {
        return new Input(description, in);
    }

    public static Input getInput(String resourceName) throws IOException {
        File f1;
        File dir;
        Input ret;
        File f;
        if (resourceName.indexOf("://") != -1) {
            try {
                return Input.getInput(new URL(resourceName));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((f = new File(resourceName)).isAbsolute()) {
            return Input.getInput(f);
        }
        URL test = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        Input input = ret = test == null ? null : new Input(test);
        if (ret != null) {
            return ret;
        }
        String currentDir = null;
        try {
            currentDir = Secure.getProperty("jreality.data", "/net/MathVis/data/testData3D");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (currentDir != null) {
            try {
                dir = new File(currentDir);
                f1 = new File(dir, resourceName);
                if (f1.exists()) {
                    return new Input(f1);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        try {
            currentDir = Secure.getProperty("user.dir");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        System.out.println("getInput currentDir " + currentDir);
        if (currentDir != null) {
            try {
                dir = new File(currentDir);
                f1 = new File(dir, resourceName);
                if (f1.exists()) {
                    return new Input(f1);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        throw new IOException("Resource not found [" + resourceName + "]");
    }

    public Input copy() throws IOException {
        if (this.sourceFile != null) {
            return new Input(this.sourceFile);
        }
        if (this.sourceURL != null) {
            return new Input(this.sourceURL);
        }
        throw new UnsupportedOperationException("only for files and URLs");
    }

    public String getContentAsString() throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        Reader r = this.getReader();
        char[] buf = new char[1024];
        while ((read = r.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        return sb.toString();
    }
}

