/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Transformation;
import java.util.WeakHashMap;

public class DefaultMatrixSupport {
    private static final double[] IDENTITY = Rn.identityMatrix(4);
    private WeakHashMap<Transformation, double[]> store = new WeakHashMap();
    private static final DefaultMatrixSupport instance = new DefaultMatrixSupport();
    SceneGraphComponent cc;

    public static DefaultMatrixSupport getSharedInstance() {
        return instance;
    }

    public void storeDefault(Transformation trafo, double[] defMatrix) {
        this.store.put(trafo, defMatrix);
    }

    public void storeAsDefault(Transformation trafo) {
        this.storeDefault(trafo, trafo.getMatrix());
    }

    public void restoreDefault(Transformation trafo, boolean clear) {
        double[] defMatrix = this.store.get(trafo);
        if (defMatrix != null && Rn.equals(defMatrix, trafo.getMatrix())) {
            return;
        }
        if (defMatrix == null && !clear) {
            return;
        }
        if (!trafo.isReadOnly()) {
            trafo.setMatrix(defMatrix != null ? defMatrix : IDENTITY);
        }
    }

    public void restoreDefaultMatrices(SceneGraphComponent root, final boolean clear) {
        root.accept(new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                DefaultMatrixSupport.this.cc = c;
                c.childrenWriteAccept(this, true, false, false, false, false, false);
            }

            public void visit(Transformation t) {
                DefaultMatrixSupport.this.restoreDefault(t, clear);
            }
        });
    }

    public void storeDefaultMatrices(SceneGraphComponent root) {
        root.accept(new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                c.childrenAccept(this);
            }

            public void visit(Transformation t) {
                DefaultMatrixSupport.this.storeAsDefault(t);
            }
        });
    }
}

