/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import java.util.Set;

public class CopyVisitor
extends SceneGraphVisitor {
    SceneGraphNode created;

    public SceneGraphNode getCopy() {
        return this.created;
    }

    public void visit(Appearance a) {
        Appearance newApp = new Appearance();
        this.copyAttr(a, newApp);
        this.created = newApp;
    }

    public void visit(Camera c) {
        Camera newCamera = new Camera();
        this.copyAttr(c, newCamera);
        this.created = newCamera;
    }

    public void visit(Cylinder c) {
        Cylinder newCyl = new Cylinder();
        this.copyAttr(c, newCyl);
        this.created = newCyl;
    }

    public void visit(DirectionalLight l) {
        DirectionalLight newLight = new DirectionalLight();
        this.copyAttr(l, newLight);
        this.created = newLight;
    }

    public void visit(IndexedFaceSet i) {
        IndexedFaceSet newIFS = new IndexedFaceSet();
        this.copyAttr(i, newIFS);
        this.created = newIFS;
    }

    public void visit(IndexedLineSet g) {
        IndexedLineSet newILS = new IndexedLineSet();
        this.copyAttr(g, newILS);
        this.created = newILS;
    }

    public void visit(PointSet p) {
        PointSet newPS = new PointSet();
        this.copyAttr(p, newPS);
        this.created = newPS;
    }

    public void visit(SceneGraphComponent c) {
        SceneGraphComponent newSGC = new SceneGraphComponent();
        this.copyAttr(c, newSGC);
        this.created = newSGC;
    }

    public void visit(Sphere s) {
        Sphere newSphere = new Sphere();
        this.copyAttr(s, newSphere);
        this.created = newSphere;
    }

    public void visit(SpotLight l) {
        SpotLight newLight = new SpotLight();
        this.copyAttr(l, newLight);
        this.created = newLight;
    }

    public void visit(ClippingPlane c) {
        ClippingPlane newCP = new ClippingPlane();
        this.copyAttr(c, newCP);
        this.created = newCP;
    }

    public void visit(PointLight l) {
        PointLight newLight = new PointLight();
        this.copyAttr(l, newLight);
        this.created = newLight;
    }

    public void visit(Transformation t) {
        Transformation newTrans = new Transformation();
        this.copyAttr(t, newTrans);
        this.created = newTrans;
    }

    public void copyAttr(SceneGraphNode src, SceneGraphNode dst) {
        dst.setName(src.getName());
    }

    public void copyAttr(SceneGraphComponent src, SceneGraphComponent dst) {
        this.copyAttr((SceneGraphNode)src, (SceneGraphNode)dst);
        dst.setVisible(src.isVisible());
        dst.setOwner(src.getOwner());
    }

    public void copyAttr(Appearance src, Appearance dst) {
        Set lst = src.getStoredAttributes();
        for (String aName : lst) {
            dst.setAttribute(aName, src.getAttribute(aName));
        }
        this.copyAttr((SceneGraphNode)src, (SceneGraphNode)dst);
    }

    public void copyAttr(Transformation src, Transformation dst) {
        dst.setMatrix(src.getMatrix());
        this.copyAttr((SceneGraphNode)src, (SceneGraphNode)dst);
    }

    public void copyAttr(Light src, Light dst) {
        dst.setColor(src.getColor());
        dst.setIntensity(src.getIntensity());
        this.copyAttr((SceneGraphNode)src, (SceneGraphNode)dst);
    }

    public void copyAttr(DirectionalLight src, DirectionalLight dst) {
        this.copyAttr((Light)src, (Light)dst);
    }

    public void copyAttr(SpotLight src, SpotLight dst) {
        dst.setConeAngle(src.getConeAngle());
        dst.setConeDeltaAngle(src.getConeDeltaAngle());
        dst.setFalloffA0(src.getFalloffA0());
        dst.setFalloffA1(src.getFalloffA1());
        dst.setFalloffA2(src.getFalloffA2());
        dst.setDistribution(src.getDistribution());
        dst.setUseShadowMap(src.isUseShadowMap());
        dst.setShadowMapX(src.getShadowMapX());
        dst.setShadowMapY(src.getShadowMapY());
        dst.setShadowMap(src.getShadowMap());
        this.copyAttr((Light)src, (Light)dst);
    }

    public void copyAttr(Geometry src, Geometry dst) {
        dst.setGeometryAttributes(src.getGeometryAttributes());
        this.copyAttr((SceneGraphNode)src, (SceneGraphNode)dst);
    }

    public void copyAttr(Sphere src, Sphere dst) {
        this.copyAttr((Geometry)src, (Geometry)dst);
    }

    public void copyAttr(Cylinder src, Cylinder dst) {
        this.copyAttr((Geometry)src, (Geometry)dst);
    }

    public void copyAttr(PointSet src, PointSet dst) {
        dst.setVertexCountAndAttributes(src.getVertexAttributes());
        this.copyAttr((Geometry)src, (Geometry)dst);
    }

    public void copyAttr(IndexedLineSet src, IndexedLineSet dst) {
        dst.setEdgeCountAndAttributes(src.getEdgeAttributes());
        this.copyAttr((PointSet)src, (PointSet)dst);
    }

    public void copyAttr(IndexedFaceSet src, IndexedFaceSet dst) {
        dst.setFaceCountAndAttributes(src.getFaceAttributes());
        this.copyAttr((IndexedLineSet)src, (IndexedLineSet)dst);
    }

    public void copyAttr(Camera src, Camera dst) {
        dst.setEyeSeparation(src.getEyeSeparation());
        dst.setFar(src.getFar());
        dst.setFieldOfView(src.getFieldOfView());
        dst.setFocus(src.getFocus());
        dst.setNear(src.getNear());
        dst.setOnAxis(src.isOnAxis());
        dst.setOrientationMatrix(src.getOrientationMatrix());
        dst.setPerspective(src.isPerspective());
        dst.setStereo(src.isStereo());
        if (!src.isOnAxis()) {
            dst.setViewPort(src.getViewPort());
        }
        this.copyAttr((SceneGraphNode)src, (SceneGraphNode)dst);
    }

    public void visit(SceneGraphNode m) {
        throw new IllegalStateException(m.getClass() + " not handled by " + this.getClass().getName());
    }
}

