/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Quaternion;
import de.jreality.math.Rn;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.util.ConfigurationAttributes;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import de.jreality.util.SceneGraphUtility;
import de.jreality.util.Secure;
import de.jreality.util.SystemProperties;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.prefs.Preferences;

public class CameraUtility {
    public static Matrix cameraOrientation = new Matrix();
    public static Matrix inverseCameraOrientation = new Matrix();
    static boolean debug;
    public static final int MIDDLE_EYE = 0;
    public static final int LEFT_EYE = 1;
    public static final int RIGHT_EYE = 2;
    static double nearFarFactor;
    private static final String FOV = "camera:field_of_view";
    private static final String FOCUS = "camera:focus";
    private static final String FOCLEN = "camera:focal_length";
    private static final String EYESEP = "camera:eye_separation";
    private static final String PERSP = "camera:perspective";
    private static final String ONAXIS = "camera:on_axis";
    private static final String STEREO = "camera:stereo";
    private static double[] standardFrame;

    private CameraUtility() {
    }

    public static Camera getCamera(Viewer v) {
        if (v == null || v.getCameraPath() == null || !(v.getCameraPath().getLastElement() instanceof Camera)) {
            throw new IllegalStateException("Viewer has no camera!");
        }
        return (Camera)v.getCameraPath().getLastElement();
    }

    public static SceneGraphComponent getCameraNode(Viewer v) {
        return v.getCameraPath().getLastComponent();
    }

    public static void encompassNew(Viewer v) {
        SceneGraphPath avatarPath = v.getCameraPath().popNew();
        if (avatarPath.getLength() > 1) {
            avatarPath.pop();
        }
        SceneGraphPath toBound = new SceneGraphPath(v.getSceneRoot());
        CameraUtility.encompass(avatarPath, toBound, v.getCameraPath(), 1.1, SceneGraphUtility.getMetric(v.getCameraPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encompass(Viewer viewer) {
        SceneGraphPath cp = viewer.getCameraPath();
        if (cp == null) {
            throw new IllegalStateException("camerapath == null");
        }
        if (cp.getLength() < 3) {
            throw new IllegalStateException("can't encompass: possibly Camera attached to root");
        }
        boolean visible = false;
        SceneGraphComponent cameraBranch = (SceneGraphComponent)cp.iterator(1).next();
        SceneGraphComponent root = viewer.getSceneRoot();
        try {
            if (root.isDirectAncestor(cameraBranch)) {
                visible = cameraBranch.isVisible();
                cameraBranch.setVisible(false);
            }
            CameraUtility.encompass(viewer, root, true);
        }
        finally {
            cameraBranch.setVisible(visible);
        }
    }

    public static void encompass(Viewer viewer, SceneGraphComponent sgc, boolean setStereoParameters) {
        CameraUtility.encompass(viewer, sgc, setStereoParameters, 0);
    }

    public static void encompass(Viewer viewer, SceneGraphComponent sgc, boolean setStereoParameters, int metric) {
        Rectangle3D worldBox = BoundingBoxUtility.calculateBoundingBox(sgc);
        if (worldBox == null || worldBox.isEmpty()) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.WARNING, "encompass: empty bounding box");
            return;
        }
        SceneGraphPath w2a = viewer.getCameraPath().popNew();
        w2a.pop();
        double[] w2ava = w2a.getInverseMatrix(null);
        worldBox.transformByMatrix(worldBox, w2ava);
        if (worldBox == null || worldBox.isEmpty()) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.WARNING, "encompass: empty bounding box");
            return;
        }
        LoggingSystem.getLogger(CameraUtility.class).log(Level.FINER, "BBox: " + worldBox.toString());
        Camera cam = CameraUtility.getCamera(viewer);
        double[] extent = worldBox.getExtent();
        double ww = extent[1] > extent[0] ? extent[1] : extent[0];
        double focus = 0.5 * ww / Math.tan(Math.PI * cam.getFieldOfView() / 360.0);
        double[] to = worldBox.getCenter();
        to[2] = to[2] + extent[2] * 0.5;
        double[] tofrom = new double[]{0.0, 0.0, focus};
        double[] from = Rn.add(null, to, tofrom);
        if (debug) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.FINER, "translate: " + Rn.toString(from));
        }
        double[] newCamToWorld = P3.makeTranslationMatrix(null, from, metric);
        double[] newWorldToCam = Rn.inverse(null, newCamToWorld);
        CameraUtility.getCameraNode(viewer).getTransformation().setMatrix(newCamToWorld);
        double[] centerWorld = Rn.matrixTimesVector(null, newWorldToCam, worldBox.getCenter());
        if (setStereoParameters) {
            cam.setFocus(Math.abs(centerWorld[2]));
            cam.setEyeSeparation(cam.getFocus() / 12.0);
        }
        Rectangle3D cameraBox = worldBox.transformByMatrix(null, newWorldToCam);
        if (debug) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.FINER, "Bbox: " + cameraBox.toString());
        }
        double zmin = cameraBox.getMinZ();
        double zmax = cameraBox.getMaxZ();
        if (cam.getFar() > 0.0 && zmax < 0.0 && -zmax > 0.1 * cam.getFar()) {
            cam.setFar(-10.0 * zmax);
        }
        if (zmin < 0.0 && -zmin < 10.0 * cam.getNear()) {
            cam.setNear(-0.1 * zmin);
        }
    }

    public static double getAspectRatio(Viewer v) {
        if (!v.hasViewingComponent()) {
            return 1.0;
        }
        Dimension d = v.getViewingComponentSize();
        return d.getHeight() > 0.0 ? d.getWidth() / d.getHeight() : 1.0;
    }

    public static double[] getCameraToNDC(Viewer v) {
        Camera cam = CameraUtility.getCamera(v);
        double aspectRatio = CameraUtility.getAspectRatio(v);
        return CameraUtility.getCameraToNDC(cam, aspectRatio);
    }

    public static double[] getCameraToNDC(Camera cam, double aspectRatio) {
        return CameraUtility.getCameraToNDC(cam, aspectRatio, 0);
    }

    public static double[] getCameraToNDC(Camera cam, double aspectRatio, int which) {
        return CameraUtility.getCameraToNDC(cam, aspectRatio, which, 0);
    }

    public static double[] getCameraToNDC(Camera cam, double aspectRatio, int which, int metric) {
        Rectangle2D viewPort = CameraUtility.getViewport(cam, aspectRatio);
        if (which == 0) {
            double[] cameraToNDC = null;
            cameraToNDC = cam.isPerspective() ? P3.makePerspectiveProjectionMatrix(null, viewPort, cam.getNear(), cam.getFar()) : P3.makeOrthographicProjectionMatrix(null, viewPort, cam.getNear(), cam.getFar());
            return cameraToNDC;
        }
        double[] eyePosition = CameraUtility.getEyePosition(cam, which);
        double[] moveToEye = P3.makeTranslationMatrix(null, eyePosition, metric);
        Rectangle2D newVP = CameraUtility.getOffAxisViewPort(cam, viewPort, eyePosition);
        double[] c2ndc = P3.makePerspectiveProjectionMatrix(null, newVP, cam.getNear(), cam.getFar());
        double[] iMoveToEye = Rn.inverse(null, moveToEye);
        double[] ret = Rn.times(null, c2ndc, iMoveToEye);
        return ret;
    }

    public static double[] getEyePosition(Camera cam, int which) {
        if (which == 0) {
            return new double[]{0.0, 0.0, 0.0, 1.0};
        }
        double factor = which == 1 ? -1.0 : 1.0;
        double[] eyePosition = new double[]{factor * cam.getEyeSeparation() / 2.0, 0.0, 0.0, 0.0};
        if (cam.getOrientationMatrix() != null) {
            Rn.matrixTimesVector(eyePosition, cam.getOrientationMatrix(), eyePosition);
            Pn.dehomogenize(eyePosition, eyePosition);
        }
        if (eyePosition[3] == 0.0) {
            eyePosition[3] = 1.0;
        }
        return eyePosition;
    }

    public static Rectangle2D getOffAxisViewPort(Camera cam, Rectangle2D viewPort, double[] eyePosition) {
        double x = eyePosition[0];
        double y = eyePosition[1];
        double z = eyePosition[2];
        Rectangle2D.Double newVP = new Rectangle2D.Double();
        double focus = cam.getFocus();
        double newFocus = focus + z;
        double fscale = 1.0 / newFocus;
        newVP.setFrameFromDiagonal(fscale * (viewPort.getMinX() * focus - x), fscale * (viewPort.getMinY() * focus - y), fscale * (viewPort.getMaxX() * focus - x), fscale * (viewPort.getMaxY() * focus - y));
        return newVP;
    }

    public static Rectangle2D getViewport(Camera cam, double aspectRatio) {
        Rectangle2D viewPort = null;
        if (cam.isOnAxis() || cam.getViewPort() == null) {
            viewPort = new Rectangle2D.Double();
            double hwidth = Math.tan(Math.PI / 180 * cam.getFieldOfView() / 2.0);
            if (!cam.isPerspective()) {
                hwidth *= cam.getFocus();
            }
            if (aspectRatio > 1.0) {
                viewPort.setFrameFromDiagonal(-hwidth * aspectRatio, -hwidth, hwidth * aspectRatio, hwidth);
            } else {
                viewPort.setFrameFromDiagonal(-hwidth, -hwidth / aspectRatio, hwidth, hwidth / aspectRatio);
            }
        } else {
            viewPort = cam.getViewPort();
        }
        return viewPort;
    }

    public static double[][] getNearViewport(Viewer v) {
        Object vp = null;
        Camera camera = CameraUtility.getCamera(v);
        Rectangle2D vp1 = CameraUtility.getViewport(camera, CameraUtility.getAspectRatio(v));
        double near = camera.getNear();
        double[][] nearCorners = new double[4][];
        return nearCorners;
    }

    public static double[] getNDCToCamera(Viewer v) {
        return Rn.inverse(null, CameraUtility.getCameraToNDC(v));
    }

    public static double[] getNDCToCamera(Camera cam, double aspectRatio) {
        return Rn.inverse(null, CameraUtility.getCameraToNDC(cam, aspectRatio));
    }

    public static void encompass(SceneGraphPath avatarPath, SceneGraphPath scene, SceneGraphPath cameraPath) {
        CameraUtility.encompass(avatarPath, scene, cameraPath, 0.0, 0);
    }

    public static void encompass(SceneGraphPath avatarPath, SceneGraphPath scene, SceneGraphPath cameraPath, double margin, int metric) {
        Rectangle3D bounds = BoundingBoxUtility.calculateBoundingBox(scene.getLastComponent());
        if (bounds.isEmpty()) {
            return;
        }
        Matrix rootToScene = new Matrix();
        scene.getMatrix(rootToScene.getArray(), 0, scene.getLength() - 2);
        Rectangle3D worldBounds = bounds.transformByMatrix(new Rectangle3D(), rootToScene.getArray());
        Rectangle3D avatarBounds = worldBounds.transformByMatrix(new Rectangle3D(), avatarPath.getInverseMatrix(null));
        double[] e = avatarBounds.getExtent();
        double radius = Math.sqrt(e[0] * e[0] + e[2] * e[2] + e[1] * e[1]);
        double[] c = avatarBounds.getCenter();
        c[2] = c[2] + margin * radius;
        Matrix camMatrix = new Matrix();
        cameraPath.getInverseMatrix(camMatrix.getArray(), avatarPath.getLength());
        Camera camera = (Camera)cameraPath.getLastElement();
        camera.setFar(margin * 5.0 * radius);
        camera.setNear(0.02 * radius);
        SceneGraphComponent avatar = avatarPath.getLastComponent();
        Matrix m = new Matrix(avatar.getTransformation());
        if (SystemProperties.isPortal) {
            return;
        }
        if (camera.isPerspective()) {
            MatrixBuilder.init(m, metric).translate(c).translate(camMatrix.getColumn(3)).assignTo(avatar);
            camera.setFocus(Math.abs(m.getColumn(3)[2]));
        } else {
            double ww = e[1] > e[0] ? e[1] : e[0];
            double focus = ww / Math.tan(Math.PI * camera.getFieldOfView() / 360.0);
            camera.setFocus(Math.abs(focus));
        }
        camera.setEyeSeparation(camera.getFocus() / 12.0);
    }

    public static void loadPreferences(Camera cam) {
        Preferences prefs = CameraUtility.getCameraPreferences();
        if (prefs == null) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.INFO, "could not get camera preferences");
            return;
        }
        cam.setFieldOfView(prefs.getDouble(FOV, cam.getFieldOfView()));
        cam.setFocus(prefs.getDouble(FOCUS, cam.getFocus()));
        cam.setFocalLength(prefs.getDouble(FOCLEN, cam.getFocalLength()));
        cam.setEyeSeparation(prefs.getDouble(EYESEP, cam.getEyeSeparation()));
        cam.setPerspective(prefs.getBoolean(PERSP, cam.isPerspective()));
        cam.setOnAxis(prefs.getBoolean(ONAXIS, cam.isOnAxis()));
        cam.setStereo(prefs.getBoolean(STEREO, cam.isStereo()));
    }

    public static void savePreferences(Camera cam) {
        Preferences prefs = CameraUtility.getCameraPreferences();
        if (prefs == null) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.INFO, "could not get camera preferences");
            return;
        }
        prefs.putDouble(FOV, cam.getFieldOfView());
        prefs.putDouble(FOCUS, cam.getFocus());
        prefs.putDouble(FOCLEN, cam.getFocalLength());
        prefs.putDouble(EYESEP, cam.getEyeSeparation());
        prefs.putBoolean(PERSP, cam.isPerspective());
        prefs.putBoolean(ONAXIS, cam.isOnAxis());
        prefs.putBoolean(STEREO, cam.isStereo());
    }

    private static Preferences getCameraPreferences() {
        return Secure.doPrivileged(new PrivilegedAction<Preferences>(){

            @Override
            public Preferences run() {
                return Preferences.userNodeForPackage(Camera.class);
            }
        });
    }

    public static double getNDCExtent(double[] o2ndc) {
        double[][] images = new double[4][4];
        Matrix imageFrame = new Matrix(Rn.times(null, o2ndc, standardFrame));
        for (int i = 0; i < 4; ++i) {
            images[i] = imageFrame.getColumn(i);
            images[i] = Pn.dehomogenize(null, images[i]);
        }
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            double[] tmp = Rn.subtract(null, images[3], images[i]);
            double t = Math.sqrt(Rn.innerProduct(tmp, tmp, 2));
            if (!(t > d)) continue;
            d = t;
        }
        return d;
    }

    public static double getScalingFactor(double[] o2w, int metric) {
        double factor = 0.0;
        Quaternion q1 = new Quaternion();
        Quaternion q2 = new Quaternion();
        double[] tv = new double[4];
        double[] sv = new double[4];
        boolean[] flipped = new boolean[1];
        P3.factorMatrix(o2w, tv, q1, q2, sv, flipped, metric);
        factor = (sv[0] + sv[1] + sv[2]) / 3.0;
        return factor;
    }

    static {
        try {
            String foo = Secure.getProperty("de.jreality.viewerapp.env");
            if (foo != null && foo.indexOf("portal") != -1) {
                ConfigurationAttributes config = ConfigurationAttributes.getDefaultConfiguration();
                double[] rot = config.getDoubleArray("camera.orientation");
                MatrixBuilder mb = MatrixBuilder.euclidean();
                double camRot = 0.0;
                if (rot != null) {
                    camRot = rot[0] * (Math.PI / 180);
                    mb.rotate(camRot, new double[]{rot[1], rot[2], rot[3]});
                }
                cameraOrientation = mb.getMatrix();
                inverseCameraOrientation = cameraOrientation.getInverse();
            }
        }
        catch (SecurityException se) {
            LoggingSystem.getLogger(CameraUtility.class).log(Level.WARNING, "Security exception in getting configuration options", se);
        }
        debug = false;
        nearFarFactor = 0.9;
        standardFrame = Rn.transpose(null, new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0});
    }
}

