/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.view;

import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.ui.viewerapp.ViewerAppMenu;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;

public class ToggleViewerFullScreen
extends AbstractJrAction {
    private boolean isFullscreen = false;
    private boolean showMenu = false;
    private ViewerApp viewerApp;
    private JFrame fsf;
    private JFrame frame;
    private ViewerAppMenu menu;
    private Component viewer;
    private static List<WeakReference<ToggleViewerFullScreen>> sharedInstances = new LinkedList<WeakReference<ToggleViewerFullScreen>>();

    private ToggleViewerFullScreen(String name, ViewerApp viewerApp) {
        super(name);
        this.viewerApp = viewerApp;
        this.frame = viewerApp.getFrame();
        this.fsf = new JFrame("jReality Viewer");
        this.fsf.setUndecorated(true);
        this.setShortDescription("Toggle full screen of viewing component");
        this.setShortCut(70, 1, true);
    }

    public static ToggleViewerFullScreen sharedInstance(String name, ViewerApp viewerApp) {
        if (viewerApp == null) {
            throw new UnsupportedOperationException("ViewerApp not allowed to be null!");
        }
        AbstractJrAction sharedInstance = null;
        Iterator<WeakReference<ToggleViewerFullScreen>> it = sharedInstances.iterator();
        while (it.hasNext()) {
            WeakReference<ToggleViewerFullScreen> ref = it.next();
            ToggleViewerFullScreen obj = (ToggleViewerFullScreen)ref.get();
            if (obj == null) {
                it.remove();
                continue;
            }
            if (obj.viewerApp != viewerApp) continue;
            sharedInstance = obj;
        }
        if (sharedInstance == null) {
            sharedInstance = new ToggleViewerFullScreen(name, viewerApp);
            sharedInstances.add(new WeakReference<AbstractJrAction>(sharedInstance));
        }
        sharedInstance.setName(name);
        return sharedInstance;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.menu == null && this.viewerApp.isCreateMenu()) {
            this.menu = this.viewerApp.getMenu();
        }
        if (this.isFullscreen) {
            if (this.showMenu) {
                this.menu.showMenuBar(true);
            }
            if (this.menu != null) {
                this.frame.setJMenuBar(this.menu.getMenuBar());
            }
            this.viewerApp.update();
            this.frame.setVisible(true);
            this.fsf.dispose();
            this.fsf.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
            this.isFullscreen = false;
        } else {
            this.fsf.getContentPane().removeAll();
            this.viewer = this.viewerApp.getViewingComponent();
            this.fsf.getContentPane().add(this.viewer);
            if (this.viewerApp.isCreateMenu()) {
                ViewerAppMenu menu = this.viewerApp.getMenu();
                this.showMenu = menu.isShowMenuBar();
                if (this.showMenu) {
                    menu.showMenuBar(false);
                }
                this.fsf.setJMenuBar(menu.getMenuBar());
            }
            this.fsf.validate();
            this.fsf.getGraphicsConfiguration().getDevice().setFullScreenWindow(this.fsf);
            this.frame.setVisible(false);
            this.isFullscreen = true;
        }
        if (this.viewer != null) {
            this.viewer.requestFocusInWindow();
        }
    }
}

