/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.view;

import de.jreality.ui.viewerapp.ViewerAppMenu;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Maximize
extends AbstractJrAction {
    private boolean isFullscreen = false;
    private Frame frame;
    private static List<WeakReference<Maximize>> sharedInstances = new LinkedList<WeakReference<Maximize>>();

    private Maximize(String name, Frame frame) {
        super(name);
        this.frame = frame;
        this.setShortDescription("Maximize/Restore size of ViewerApp's frame");
    }

    public static Maximize sharedInstance(String name, Frame frame) {
        if (frame == null) {
            throw new UnsupportedOperationException("Frame not allowed to be null!");
        }
        AbstractJrAction sharedInstance = null;
        Iterator<WeakReference<Maximize>> it = sharedInstances.iterator();
        while (it.hasNext()) {
            WeakReference<Maximize> ref = it.next();
            Maximize obj = (Maximize)ref.get();
            if (obj == null) {
                it.remove();
                continue;
            }
            if (obj.frame != frame) continue;
            sharedInstance = obj;
        }
        if (sharedInstance == null) {
            sharedInstance = new Maximize(name, frame);
            sharedInstances.add(new WeakReference<AbstractJrAction>(sharedInstance));
        }
        sharedInstance.setName(name);
        return sharedInstance;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isFullscreen) {
            this.frame.dispose();
            this.frame.setUndecorated(false);
            this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
            this.setName(ViewerAppMenu.MAXIMIZE);
            this.frame.validate();
            this.frame.pack();
            this.frame.setVisible(true);
            this.isFullscreen = false;
        } else {
            this.frame.dispose();
            this.frame.setUndecorated(true);
            this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(this.frame);
            this.setName(ViewerAppMenu.RESTORE);
            this.frame.validate();
            this.isFullscreen = true;
        }
    }
}

