/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.io.JrScene;
import de.jreality.scene.Viewer;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.writer.u3d.WriterU3D;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

public class ExportU3D
extends AbstractJrAction {
    private Viewer viewer;

    public ExportU3D(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Save scene as a U3D file");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, "u3d", "Adobe u3d files");
        if (file == null) {
            return;
        }
        try {
            WriterU3D writer = new WriterU3D();
            JrScene s = new JrScene(this.viewer.getSceneRoot());
            s.addPath("cameraPath", this.viewer.getCameraPath());
            ToolSystem ts = ToolSystem.toolSystemForViewer(this.viewer);
            if (ts.getAvatarPath() != null) {
                s.addPath("avatarPath", ts.getAvatarPath());
            }
            if (ts.getEmptyPickPath() != null) {
                s.addPath("emptyPickPath", ts.getEmptyPickPath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            writer.writeScene(s, fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.parentComp, "Save failed: " + ioe.getMessage());
        }
    }
}

