/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.writer.WriterSTL;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JComponent;

public class ExportSTL
extends AbstractJrAction {
    private Viewer viewer;
    private JComponent options;

    public ExportSTL(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Export the current scene as STL file");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, this.options, "stl", "STL Files");
        if (file == null) {
            return;
        }
        try {
            WriterSTL.write(this.viewer.getSceneRoot(), (OutputStream)new FileOutputStream(file));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

