/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.scene.Viewer;
import de.jreality.softviewer.PSRenderer;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class ExportPS
extends AbstractJrAction {
    private Viewer viewer;

    public ExportPS(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Export the current scene as PostScript file");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, "ps", "PostScript Files");
        if (file == null) {
            return;
        }
        Dimension d = this.viewer.getViewingComponentSize();
        try {
            PSRenderer rv = new PSRenderer(new PrintWriter(file), d.width, d.height);
            rv.setCameraPath(this.viewer.getCameraPath());
            rv.setSceneRoot(this.viewer.getSceneRoot());
            rv.setAuxiliaryRoot(this.viewer.getAuxiliaryRoot());
            rv.render();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }
}

