/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.io.JrScene;
import de.jreality.scene.Viewer;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.writer.pdf.WriterPDF;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ExportPDF
extends AbstractJrAction {
    private static final long serialVersionUID = 1L;
    private Viewer viewer = null;
    private PDFExportAccessory accessory = new PDFExportAccessory();

    public ExportPDF(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Save scene as a PDF file");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, (JComponent)this.accessory, "pdf", "PDF files");
        if (file == null) {
            return;
        }
        try {
            WriterPDF writer = new WriterPDF();
            writer.setPreferences(this.accessory.getPreferences());
            writer.setSize(this.accessory.getPDFSize());
            JrScene s = new JrScene(this.viewer.getSceneRoot());
            s.addPath("cameraPath", this.viewer.getCameraPath());
            ToolSystem ts = ToolSystem.toolSystemForViewer(this.viewer);
            if (ts.getAvatarPath() != null) {
                s.addPath("avatarPath", ts.getAvatarPath());
            }
            if (ts.getEmptyPickPath() != null) {
                s.addPath("emptyPickPath", ts.getEmptyPickPath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            writer.writeScene(s, fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.parentComp, "Save failed: " + ioe.getMessage());
        }
    }

    private class PDFExportAccessory
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox prefsCombo = new JComboBox<WriterPDF.PDF3DPreferences>(WriterPDF.PDF3DPreferences.values());
        private SpinnerNumberModel widthModel = new SpinnerNumberModel(800, 1, 10000, 10);
        private SpinnerNumberModel heightModel = new SpinnerNumberModel(600, 1, 10000, 10);
        private JSpinner widthSpinner = new JSpinner(this.widthModel);
        private JSpinner heightSpinner = new JSpinner(this.heightModel);

        public PDFExportAccessory() {
            this.setBorder(BorderFactory.createTitledBorder("PDF Options"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 0, 0);
            c.weightx = 1.0;
            c.fill = 2;
            c.gridwidth = -1;
            this.add((Component)new JLabel("Tool Set:"), c);
            c.gridwidth = 0;
            this.add((Component)this.prefsCombo, c);
            c.gridwidth = -1;
            this.add((Component)new JLabel("Size:"), c);
            c.gridwidth = 0;
            JPanel sizePanel = new JPanel();
            sizePanel.setLayout(new FlowLayout());
            sizePanel.add(this.widthSpinner);
            sizePanel.add(new JLabel("X"));
            sizePanel.add(this.heightSpinner);
            this.add((Component)sizePanel, c);
        }

        public WriterPDF.PDF3DPreferences getPreferences() {
            WriterPDF.PDF3DPreferences prefs = (WriterPDF.PDF3DPreferences)((Object)this.prefsCombo.getSelectedItem());
            if (prefs != null) {
                return prefs;
            }
            return WriterPDF.PDF3DPreferences.Default;
        }

        public Dimension getPDFSize() {
            return new Dimension(this.widthModel.getNumber().intValue(), this.heightModel.getNumber().intValue());
        }
    }
}

