/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import de.jreality.writer.WriterOBJ;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ExportOBJ
extends AbstractSelectionListenerAction {
    public ExportOBJ(String name, SelectionManager sm, Component parentComp) {
        super(name, sm, parentComp);
        this.setShortDescription("Export selected IndexedFaceSet as OBJ file");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, "obj", "OBJ files");
        if (file == null) {
            return;
        }
        IndexedFaceSet ifs = this.getSelection().getLastElement() instanceof Geometry ? (IndexedFaceSet)this.getSelection().getLastElement() : (IndexedFaceSet)this.getSelection().getLastComponent().getGeometry();
        try {
            WriterOBJ.write(ifs, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException exc) {
            exc.printStackTrace();
        }
    }

    public boolean isEnabled(SelectionEvent e) {
        if (e.geometrySelected() && e.getSelection().getLastElement() instanceof IndexedFaceSet) {
            return true;
        }
        Geometry g = null;
        if (e.componentSelected()) {
            g = e.getSelection().getLastComponent().getGeometry();
        }
        return g instanceof IndexedFaceSet;
    }
}

