/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.ui.viewerapp.Selection;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.util.LoggingSystem;
import java.util.logging.Level;

public class SelectionTool
extends AbstractTool {
    static final InputSlot activationSlot = InputSlot.getDevice("SelectionActivation");
    private SelectionManager sm;
    private Selection selection;

    public SelectionTool(SelectionManager sm) {
        super(new InputSlot[0]);
        this.addCurrentSlot(activationSlot);
        this.sm = sm;
    }

    public SelectionTool() {
        this((SelectionManager)null);
    }

    public SelectionTool(ViewerApp v) {
        this(v.getSelectionManager());
    }

    public void perform(ToolContext tc) {
        if (tc.getAxisState(activationSlot).isReleased()) {
            return;
        }
        PickResult pr = tc.getCurrentPick();
        if (pr == null) {
            return;
        }
        this.selection = new Selection(pr.getPickPath().popNew());
        if (this.sm != null) {
            this.sm.setSelection(this.selection);
        }
        LoggingSystem.getLogger(SelectionTool.class).log(Level.INFO, "SELECTED COMPONENT: " + (this.selection != null ? this.selection.getLastComponent().getName() : "default"));
    }
}

